/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.kuali.kra.award.paymentreports.Frequency;
import org.kuali.kra.award.paymentreports.FrequencyBase;
import org.kuali.kra.award.paymentreports.Report;
import org.kuali.kra.award.paymentreports.ValidClassReportFrequency;
import org.kuali.kra.award.paymentreports.ValidFrequencyBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.AwardTemplateReportTermService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardTemplateReportTermServiceImpl
implements AwardTemplateReportTermService {
    private BusinessObjectService businessObjectService;

    public String getReportTypeForAjaxCall(String reportClassCode) throws Exception {
        Collection reportTypes = this.getReportTypesUsingReportClassCode(reportClassCode);
        String attributeNames = "";
        for (Object aReportCode : reportTypes) {
            Report aReport = (Report)this.businessObjectService.findBySinglePrimaryKey(Report.class, aReportCode);
            if (aReport == null) continue;
            attributeNames = attributeNames + "," + aReportCode + ";" + aReport.getDescription();
        }
        return attributeNames;
    }

    public Collection getReportTypesUsingReportClassCode(String reportClassCode) throws Exception {
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> classReportFreqParams = new HashMap<String, String>();
        classReportFreqParams.put("reportClassCode", reportClassCode);
        Collection coll = this.businessObjectService.findMatching(ValidClassReportFrequency.class, classReportFreqParams);
        HashSet<String> reportTypes = new HashSet<String>();
        if (!coll.isEmpty()) {
            for (ValidClassReportFrequency aVcrf : coll) {
                reportTypes.add(aVcrf.getReportCode());
            }
        }
        return reportTypes;
    }

    public String getFrequencyForAjaxCall(String reportCode, String reportClass) throws Exception {
        Collection frequencyCodes = this.getFrequencyUsingReportCodeAndClass(reportCode, reportClass);
        String attributeNames = "";
        for (Object aFrequencyCode : frequencyCodes) {
            Frequency aFrequency = (Frequency)this.businessObjectService.findBySinglePrimaryKey(Frequency.class, aFrequencyCode);
            if (aFrequency == null) continue;
            attributeNames = attributeNames + "," + aFrequencyCode + ";" + aFrequency.getDescription();
        }
        return attributeNames;
    }

    public Collection getFrequencyUsingReportCodeAndClass(String reportCode, String reportClass) throws Exception {
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> classReportFreqParams = new HashMap<String, String>();
        classReportFreqParams.put("reportCode", reportCode);
        classReportFreqParams.put("reportClassCode", reportClass);
        Collection coll = this.businessObjectService.findMatching(ValidClassReportFrequency.class, classReportFreqParams);
        HashSet<String> frequencyCodes = new HashSet<String>();
        if (!coll.isEmpty()) {
            for (ValidClassReportFrequency aVcrf : coll) {
                frequencyCodes.add(aVcrf.getFrequencyCode());
            }
        }
        return frequencyCodes;
    }

    public String getFrequencyBaseForAjaxCall(String frequencyCode) throws Exception {
        Collection frequencyBaseCodes = this.getFrequencyBaseUsingFrequencyCode(frequencyCode);
        String attributeNames = "";
        for (Object aFrequencyBaseCode : frequencyBaseCodes) {
            FrequencyBase aFrequencyBase = (FrequencyBase)this.businessObjectService.findBySinglePrimaryKey(FrequencyBase.class, aFrequencyBaseCode);
            if (aFrequencyBase == null) continue;
            attributeNames = attributeNames + "," + aFrequencyBaseCode + ";" + aFrequencyBase.getDescription();
        }
        return attributeNames;
    }

    public Collection getFrequencyBaseUsingFrequencyCode(String frequencyCode) throws Exception {
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("frequencyCode", frequencyCode);
        Collection coll = this.businessObjectService.findMatching(ValidFrequencyBase.class, params);
        HashSet<String> frequencyBaseCodes = new HashSet<String>();
        if (!coll.isEmpty()) {
            for (ValidFrequencyBase aVcrf : coll) {
                frequencyBaseCodes.add(aVcrf.getFrequencyBaseCode());
            }
        }
        return frequencyBaseCodes;
    }
}

