/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.List;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.service.KcEmailService;
import org.kuali.kra.util.EmailAttachment;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class KcEmailServiceImpl
implements KcEmailService {
    private static final Log LOG = LogFactory.getLog(KcEmailServiceImpl.class);
    public static final String DEFAULT_ENCODING = "UTF-8";
    private JavaMailSenderImpl mailSender;
    private ParameterService parameterService;

    public void setMailSender(JavaMailSenderImpl mailSender) {
        this.mailSender = mailSender;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void sendEmail(String from, Set<String> toAddresses, String subject, Set<String> ccAddresses, Set<String> bccAddresses, String body, boolean htmlMessage) {
        this.sendEmailWithAttachments(from, toAddresses, subject, ccAddresses, bccAddresses, body, htmlMessage, null);
    }

    public void sendEmailWithAttachments(String from, Set<String> toAddresses, String subject, Set<String> ccAddresses, Set<String> bccAddresses, String body, boolean htmlMessage, List<EmailAttachment> attachments) {
        if (this.mailSender != null) {
            if (CollectionUtils.isEmpty(toAddresses) && CollectionUtils.isEmpty(ccAddresses) && CollectionUtils.isEmpty(bccAddresses)) {
                return;
            }
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = null;
            try {
                helper = new MimeMessageHelper(message, true, DEFAULT_ENCODING);
                helper.setFrom(from);
                if (StringUtils.isNotBlank((String)subject)) {
                    helper.setSubject(subject);
                } else {
                    LOG.warn((Object)"Sending message with empty subject.");
                }
                if (this.isEmailTestEnabled()) {
                    helper.setText(this.getTestMessageBody(body, toAddresses, ccAddresses, bccAddresses), true);
                    String toAddress = this.getEmailNotificationTestAddress();
                    if (StringUtils.isNotBlank((String)this.getEmailNotificationTestAddress())) {
                        helper.addTo(toAddress);
                    }
                } else {
                    helper.setText(body, htmlMessage);
                    if (CollectionUtils.isNotEmpty(toAddresses)) {
                        for (String toAddress : toAddresses) {
                            try {
                                helper.addTo(toAddress);
                            }
                            catch (Exception ex) {
                                LOG.warn((Object)"Could not set to address:", (Throwable)ex);
                            }
                        }
                    }
                    if (CollectionUtils.isNotEmpty(ccAddresses)) {
                        for (String ccAddress : ccAddresses) {
                            try {
                                helper.addCc(ccAddress);
                            }
                            catch (Exception ex) {
                                LOG.warn((Object)"Could not set to address:", (Throwable)ex);
                            }
                        }
                    }
                    if (CollectionUtils.isNotEmpty(bccAddresses)) {
                        for (String bccAddress : bccAddresses) {
                            try {
                                helper.addBcc(bccAddress);
                            }
                            catch (Exception ex) {
                                LOG.warn((Object)"Could not set to address:", (Throwable)ex);
                            }
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(attachments)) {
                    for (EmailAttachment attachment : attachments) {
                        try {
                            helper.addAttachment(attachment.getFileName(), (InputStreamSource)new ByteArrayResource(attachment.getContents()), attachment.getMimeType());
                        }
                        catch (Exception ex) {
                            LOG.warn((Object)"Could not set to address:", (Throwable)ex);
                        }
                    }
                }
                this.mailSender.send(message);
            }
            catch (MessagingException ex) {
                LOG.error((Object)"Failed to create mime message helper.", (Throwable)ex);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to send email.", (Throwable)e);
            }
        } else {
            LOG.info((Object)"Failed to send email due to inability to obtain valid email mailSender, please check your configuration.");
        }
    }

    private String getEmailNotificationTestAddress() {
        String testAddress = this.parameterService.getParameterValueAsString("KC-GEN", "All", "EMAIL_NOTIFICATION_TEST_ADDRESS");
        return testAddress;
    }

    private String getTestMessageBody(String body, Set<String> toAddresses, Set<String> ccAddresses, Set<String> bccAddresses) {
        StringBuffer testEmailBody = new StringBuffer("");
        testEmailBody.append("-----------------------------------------------------------<br/>");
        testEmailBody.append("TEST MODE<br/>");
        testEmailBody.append("In Production mode this mail will be sent to the following... <br/>");
        if (CollectionUtils.isNotEmpty(toAddresses)) {
            testEmailBody.append("TO: ");
            testEmailBody.append(toAddresses);
        }
        if (CollectionUtils.isNotEmpty(ccAddresses)) {
            testEmailBody.append("CC: ");
            testEmailBody.append(toAddresses);
        }
        if (CollectionUtils.isNotEmpty(bccAddresses)) {
            testEmailBody.append("BCC: ");
            testEmailBody.append(toAddresses);
        }
        testEmailBody.append("<br/>-----------------------------------------------------------");
        return testEmailBody.toString() + "<br/>" + body;
    }

    private boolean isEmailTestEnabled() {
        Boolean emailTestEnabled = this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "EMAIL_NOTIFICATIONS_TEST_ENABLED");
        return emailTestEnabled == null ? false : emailTestEnabled;
    }

    public String getDefaultFromAddress() {
        String fromAddress = this.parameterService.getParameterValueAsString("KC-GEN", "All", "EMAIL_NOTIFICATION_FROM_ADDRESS");
        return fromAddress != null ? fromAddress : ConfigContext.getCurrentContextConfig().getProperties().getProperty("mail.from");
    }
}

