/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.Collection;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.service.KcPessimisticLockService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.transaction.annotation.Transactional;

public class KcPessimisticLockServiceImpl
implements KcPessimisticLockService {
    private static final long MINUTES_TO_MILLISECONDS = 60000L;
    private static final int DEFAULT_EXPIRATION_AGE = 1440;
    private ParameterService parameterService;
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Transactional
    public void clearExpiredLocks() {
        long now = this.getCurrentTime();
        long expirationAgeMillis = this.getExpirationAgeMillis();
        Collection locks = this.getAllLocks();
        for (PessimisticLock lock : locks) {
            long lockTime = lock.getGeneratedTimestamp().getTime();
            if (now - lockTime < expirationAgeMillis) continue;
            this.businessObjectService.delete((PersistableBusinessObject)lock);
        }
    }

    protected Collection<PessimisticLock> getAllLocks() {
        return this.businessObjectService.findAll(PessimisticLock.class);
    }

    protected long getCurrentTime() {
        return this.dateTimeService.getCurrentTimestamp().getTime();
    }

    protected long getExpirationAgeMillis() {
        return (long)this.getLockExpirationAge() * 60000L;
    }

    protected int getLockExpirationAge() {
        try {
            String timeoutStr = this.getParameterValue("pessimisticLocking.expirationAge");
            return Integer.parseInt(timeoutStr);
        }
        catch (Exception ex) {
            return 1440;
        }
    }

    protected String getParameterValue(String key) {
        return this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, key);
    }
}

