/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.RolePersons;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.PermissionAttributes;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.UnitAuthorizationService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;

public class KraAuthorizationServiceImpl
implements KraAuthorizationService {
    private UnitAuthorizationService unitAuthorizationService;
    private KcPersonService kcPersonService;
    private RoleService roleManagementService;
    private IdentityService identityManagementService;
    private PermissionService permissionService;

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }

    public void setKcPersonService(KcPersonService personService) {
        this.kcPersonService = personService;
    }

    public void setRoleManagementService(RoleService roleManagementService) {
        this.roleManagementService = roleManagementService;
    }

    public void setIdentityManagementService(IdentityService identityManagementService) {
        this.identityManagementService = identityManagementService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public List<String> getUserNames(Permissionable permissionable, String roleName) {
        ArrayList<String> userNames = new ArrayList<String>();
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put(permissionable.getDocumentKey(), permissionable.getDocumentNumberForPermission());
        Collection users = this.roleManagementService.getRoleMemberPrincipalIds(permissionable.getNamespace(), roleName, new HashMap(qualifiedRoleAttributes));
        for (String userId : users) {
            Principal principal = this.identityManagementService.getPrincipal(userId);
            if (principal == null) continue;
            userNames.add(principal.getPrincipalName());
        }
        return userNames;
    }

    public void addRole(String userId, String roleName, Permissionable permissionable) {
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put(permissionable.getDocumentKey(), permissionable.getDocumentNumberForPermission());
        this.roleManagementService.assignPrincipalToRole(userId, permissionable.getNamespace(), roleName, new HashMap(qualifiedRoleAttributes));
        this.forceFlushRoleCaches();
    }

    public void removeRole(String userId, String roleName, Permissionable permissionable) {
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put(permissionable.getDocumentKey(), permissionable.getDocumentNumberForPermission());
        this.roleManagementService.removePrincipalFromRole(userId, permissionable.getNamespace(), roleName, new HashMap(qualifiedRoleAttributes));
        this.forceFlushRoleCaches();
    }

    public boolean hasPermission(String userId, Permissionable permissionable, String permissionName) {
        return this.hasPermission(userId, permissionable, permissionable.getNamespace(), permissionName);
    }

    public boolean hasPermission(String userId, Permissionable permissionable, String permissionNamespace, String permissionName) {
        boolean userHasPermission = false;
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put(permissionable.getDocumentKey(), permissionable.getDocumentNumberForPermission());
        permissionable.populateAdditionalQualifiedRoleAttributes(qualifiedRoleAttributes);
        Map permissionAttributes = PermissionAttributes.getAttributes((String)permissionName);
        String unitNumber = permissionable.getLeadUnitNumber();
        if (StringUtils.isNotEmpty((String)permissionable.getDocumentNumberForPermission())) {
            userHasPermission = this.permissionService.isAuthorized(userId, permissionNamespace, permissionName, qualifiedRoleAttributes);
        }
        if (!userHasPermission && StringUtils.isNotEmpty((String)unitNumber)) {
            userHasPermission = this.unitAuthorizationService.hasPermission(userId, unitNumber, permissionNamespace, permissionName);
        }
        return userHasPermission;
    }

    public boolean hasRole(String userId, Permissionable permissionable, String roleName) {
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put(permissionable.getDocumentKey(), permissionable.getDocumentNumberForPermission());
        Role role = this.roleManagementService.getRoleByNamespaceCodeAndName(permissionable.getNamespace(), roleName);
        if (role != null) {
            return this.roleManagementService.principalHasRole(userId, Collections.singletonList(role.getId()), new HashMap(qualifiedRoleAttributes));
        }
        return false;
    }

    public List<String> getRoles(String userId, Permissionable permissionable) {
        HashSet roleNames = new HashSet();
        String documentNumber = permissionable.getDocumentNumberForPermission();
        HashMap<String, String> qualifiedRoleAttrs = new HashMap<String, String>();
        qualifiedRoleAttrs.put(permissionable.getDocumentKey(), documentNumber);
        if (documentNumber != null) {
            ArrayList<String> roleIds = new ArrayList<String>();
            HashMap<String, String> roleNameIdMap = new HashMap<String, String>();
            for (String role : permissionable.getRoleNames()) {
                String roleId = this.roleManagementService.getRoleIdByNamespaceCodeAndName(permissionable.getNamespace(), role);
                roleNameIdMap.put(roleId, role);
                roleIds.add(roleId);
            }
            List membershipInfoList = this.roleManagementService.getRoleMembers(roleIds, new HashMap(qualifiedRoleAttrs));
            for (RoleMembership memberShipInfo : membershipInfoList) {
                if (!memberShipInfo.getMemberId().equalsIgnoreCase(userId)) continue;
                roleNames.add(roleNameIdMap.get(memberShipInfo.getRoleId()));
            }
        }
        return new ArrayList<String>(roleNames);
    }

    public List<KcPerson> getPersonsInRole(Permissionable permissionable, String roleName) {
        ArrayList<KcPerson> persons = new ArrayList<KcPerson>();
        if (permissionable != null && StringUtils.isNotBlank((String)roleName)) {
            HashMap<String, String> qualifiedRoleAttrs = new HashMap<String, String>();
            qualifiedRoleAttrs.put(permissionable.getDocumentKey(), permissionable.getDocumentNumberForPermission());
            Collection users = this.roleManagementService.getRoleMemberPrincipalIds(permissionable.getNamespace(), roleName, new HashMap(qualifiedRoleAttrs));
            for (String userId : users) {
                KcPerson person = this.kcPersonService.getKcPersonByPersonId(userId);
                if (person == null || !person.getActive().booleanValue()) continue;
                persons.add(person);
            }
        }
        return persons;
    }

    public List<RolePersons> getAllRolePersons(Permissionable permissionable) {
        ArrayList<RolePersons> rolePersonsList = new ArrayList<RolePersons>();
        if (permissionable != null) {
            List roleNames = permissionable.getRoleNames();
            for (String roleName : roleNames) {
                List usernames = this.getUserNames(permissionable, roleName);
                RolePersons rolePersons = new RolePersons();
                rolePersonsList.add(rolePersons);
                if (roleName.contains("Aggregator")) {
                    rolePersons.setAggregator(usernames);
                    continue;
                }
                if (roleName.contains("Viewer")) {
                    rolePersons.setViewer(usernames);
                    continue;
                }
                if (roleName.contains("Narrative Writer")) {
                    rolePersons.setNarrativewriter(usernames);
                    continue;
                }
                if (!roleName.contains("Budget Creator")) continue;
                rolePersons.setBudgetcreator(usernames);
            }
        }
        return rolePersonsList;
    }

    public boolean hasRole(String userId, String namespace, String roleName) {
        Role role = this.roleManagementService.getRoleByNamespaceCodeAndName(namespace, roleName);
        if (role != null) {
            return this.roleManagementService.principalHasRole(userId, Collections.singletonList(role.getId()), null);
        }
        return false;
    }

    public void forceFlushRoleCaches() {
    }

    public RoleService getRoleService() {
        return this.roleManagementService;
    }

    public IdentityService getIdentityService() {
        return this.identityManagementService;
    }
}

