/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPersonExtendedAttributes;
import org.kuali.kra.service.MultiCampusIdentityService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationContract;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class MultiCampusIdentityServiceImpl
implements MultiCampusIdentityService {
    private BusinessObjectService businessObjectService;
    private IdentityService identityService;

    public String getMultiCampusPrincipalName(String principalName, String campusCode) {
        String result = principalName;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("multiCampusPrincipalName", principalName);
        Collection multiCampusPersons = this.getBusinessObjectService().findMatching(KcPersonExtendedAttributes.class, fieldValues);
        for (KcPersonExtendedAttributes multiCampusPerson : multiCampusPersons) {
            String principalId = multiCampusPerson.getPersonId();
            if (!this.hasCampusAffiliation(principalId, campusCode)) continue;
            result = this.getIdentityService().getPrincipal(principalId).getPrincipalName();
            break;
        }
        return result;
    }

    private boolean hasCampusAffiliation(String principalId, String campusCode) {
        boolean hasCampusAffiliation = false;
        Entity entityInfo = this.getIdentityService().getEntityByPrincipalId(principalId);
        for (EntityAffiliationContract affiliation : entityInfo.getAffiliations()) {
            if (!StringUtils.equals((String)campusCode, (String)affiliation.getCampusCode())) continue;
            hasCampusAffiliation = true;
            break;
        }
        return hasCampusAffiliation;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }
}

