/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationCorrespondent;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.OrganizationService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class OrganizationServiceImpl
implements OrganizationService {
    private BusinessObjectService businessObjectService;
    private static final String ORGANIZATION_ID = "organizationId";

    public String getOrganizationName(String organizationId) {
        String organizationName = null;
        Organization organization = this.getOrganization(organizationId);
        if (organization != null) {
            organizationName = organization.getOrganizationName();
        }
        return organizationName;
    }

    public Organization getOrganization(String organizationId) {
        Organization organization = null;
        if (StringUtils.isNotEmpty((String)organizationId)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put(ORGANIZATION_ID, organizationId);
            organization = (Organization)this.businessObjectService.findByPrimaryKey(Organization.class, primaryKeys);
        }
        return organization;
    }

    public List<OrganizationCorrespondent> retrieveOrganizationCorrespondentsByOrganizationId(String organizationId) {
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(ORGANIZATION_ID, organizationId);
        List organizationCorrespondents = (List)this.getBusinessObjectService().findMatching(OrganizationCorrespondent.class, queryMap);
        return organizationCorrespondents;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }
}

