/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.PersonSignature;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;

public class PersonSignatureLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = 749587517623905557L;

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals("person.userName")) continue;
                field.setFieldConversions("principalName:person.userName,principalId:personId");
            }
        }
        return rows;
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        KcPerson person;
        String userName = (String)lookupForm.getFieldsForLookup().get("person.userName");
        if (StringUtils.isNotEmpty((String)userName) && (person = this.getKcPersonService().getKcPersonByUserName(userName)) != null) {
            lookupForm.getFieldsForLookup().put("personId", person.getPersonId());
        }
        return super.performLookup(lookupForm, resultTable, bounded);
    }

    public KcPersonService getKcPersonService() {
        return (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List searchResults = super.getSearchResults(fieldValues);
        if (!searchResults.isEmpty() && StringUtils.isNotBlank((String)fieldValues.get("person.userName"))) {
            return this.filterSearchResults(searchResults, fieldValues.get("person.userName"));
        }
        return searchResults;
    }

    protected List<PersonSignature> filterSearchResults(List<PersonSignature> searchResults, String userName) {
        ArrayList<PersonSignature> filteredList = new ArrayList<PersonSignature>();
        String regexp = StringUtils.replace((String)userName, (String)"*", (String)".*").toUpperCase() + "$";
        for (PersonSignature personSignature : searchResults) {
            if (!personSignature.getPerson().getUserName().toUpperCase().matches(regexp)) continue;
            filteredList.add(personSignature);
        }
        return filteredList;
    }
}

