/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipExpertiseBase;
import org.kuali.kra.common.committee.bo.CommitteeResearchAreaBase;
import org.kuali.kra.dao.ResearchAreaReferencesDao;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.kra.service.ResearchAreaCurrentReferencerHolderBase;
import org.kuali.kra.service.ResearchAreasServiceBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ResearchAreasServiceBaseImpl
implements ResearchAreasServiceBase {
    private static final String COLUMN_CODE_1 = "%3A";
    private static final String COLUMN_CODE_2 = "%4A";
    private static final String CREATE_RESEARCH_AREA = "RaCreate";
    private static final String UPDATE_PARENT_RESEARCH_AREA = "RaUpdateParent";
    private static final String UPDATE_RESEARCH_AREA_ACTIVE_FLAG = "RaUpdateActiveIndicator";
    private static final String UPDATE_RESEARCH_AREA_DESCRIPTION = "RaUpdateDescription";
    private static final String RESEARCH_AREA_CODE = "researchAreaCode";
    private static final String COMMITTEE_ID = "committeeId";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String CODE = "Code";
    private static final String TRUE = "true";
    private static final String ACTIVE = "Active";
    private static final String DESCRIPTION = "Description";
    private static final String PARENT_CODE = "ParentCode";
    private static final String PARENT_RESEARCH_AREA_CODE = "parentResearchAreaCode";
    private static final String NEW_PARENT = "NewParent";
    private BusinessObjectService businessObjectService;
    private ResearchAreaReferencesDao researchAreaReferencesDao;

    public String getSubResearchAreasForTreeView(String researchAreaCode, boolean activeOnly) {
        String researchAreas = "<h3>";
        for (ResearchAreaBase researchArea : this.getSubResearchAreas(researchAreaCode, activeOnly)) {
            researchAreas = researchAreas + researchArea.getResearchAreaCode() + " " + COLUMN_CODE_1 + " " + researchArea.getDescription() + " " + COLUMN_CODE_2 + " " + researchArea.isActive() + "</h3><h3>";
        }
        researchAreas = researchAreas.substring(0, researchAreas.length() - 4);
        return researchAreas;
    }

    protected List<ResearchAreaBase> getSubResearchAreas(String researchAreaCode, boolean activeOnly) {
        ArrayList<ResearchAreaBase> researchAreasList = new ArrayList<ResearchAreaBase>();
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(PARENT_RESEARCH_AREA_CODE, researchAreaCode);
        if (activeOnly) {
            fieldValues.put("active", activeOnly);
        }
        researchAreasList.addAll(this.businessObjectService.findMatchingOrderBy(this.getResearchAreaBOClassHook(), fieldValues, RESEARCH_AREA_CODE, true));
        return researchAreasList;
    }

    public boolean isResearchAreaExist(String researchAreaCode, String researchAreas) {
        boolean isExist;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(RESEARCH_AREA_CODE, researchAreaCode);
        boolean bl = isExist = this.businessObjectService.findByPrimaryKey(this.getResearchAreaBOClassHook(), fieldValues) != null;
        if (isExist && StringUtils.isNotBlank((String)researchAreas)) {
            for (String raCode : researchAreas.split(";")) {
                if (raCode.equals(researchAreaCode)) {
                    isExist = false;
                    break;
                }
                if (!this.isExistInDeletedChildren(researchAreaCode, raCode)) continue;
                isExist = false;
                break;
            }
        }
        return isExist;
    }

    public boolean checkResearchAreaAndDescendantsNotReferenced(String researchAreaCode) {
        boolean retValue = true;
        ResearchAreaBase researchArea = (ResearchAreaBase)this.getBusinessObjectService().findBySinglePrimaryKey(this.getResearchAreaBOClassHook(), (Object)researchAreaCode);
        if (researchArea != null) {
            retValue = this.checkResearchAreaTree(researchArea);
        }
        return retValue;
    }

    private boolean checkResearchAreaTree(ResearchAreaBase researchArea) {
        boolean retValue = true;
        String researchAreaCode = researchArea.getResearchAreaCode();
        if (this.getResearchAreaReferencesDao().isResearchAreaReferencedByAnyCommittee(researchAreaCode) || this.getResearchAreaReferencesDao().isResearchAreaReferencedByAnyCommitteeMember(researchAreaCode) || this.getResearchAreaReferencesDao().isResearchAreaReferencedByAnyProtocol(researchAreaCode)) {
            retValue = false;
        } else {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(PARENT_RESEARCH_AREA_CODE, researchAreaCode);
            List subResearchAreas = (List)this.getBusinessObjectService().findMatching(this.getResearchAreaBOClassHook(), fieldValues);
            for (ResearchAreaBase subResearchArea : subResearchAreas) {
                if (this.checkResearchAreaTree(subResearchArea)) continue;
                retValue = false;
                break;
            }
        }
        return retValue;
    }

    public void deleteResearchAreaAndDescendants(String researchAreaCode) {
        ResearchAreaBase researchArea = (ResearchAreaBase)this.getBusinessObjectService().findBySinglePrimaryKey(this.getResearchAreaBOClassHook(), (Object)researchAreaCode);
        if (researchArea != null) {
            this.getBusinessObjectService().delete((PersistableBusinessObject)researchArea);
            this.deleteChildrenResearchAreas(researchAreaCode);
            this.updateHasChildrenFlag(researchArea.getParentResearchAreaCode());
        }
    }

    private void deleteChildrenResearchAreas(String parentResearchAreaCode) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(PARENT_RESEARCH_AREA_CODE, parentResearchAreaCode);
        List researchAreas = (List)this.businessObjectService.findMatching(this.getResearchAreaBOClassHook(), fieldValues);
        for (ResearchAreaBase researchArea : researchAreas) {
            this.deleteChildrenResearchAreas(researchArea.getResearchAreaCode());
            this.businessObjectService.delete((PersistableBusinessObject)researchArea);
        }
    }

    private void updateHasChildrenFlag(String researchAreaCode) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(PARENT_RESEARCH_AREA_CODE, researchAreaCode);
        if (this.businessObjectService.countMatching(this.getResearchAreaBOClassHook(), fieldValues) > 0) {
            this.setHasChildrenFlag(researchAreaCode, true);
        } else {
            this.setHasChildrenFlag(researchAreaCode, false);
        }
    }

    private void setHasChildrenFlag(String researchAreaCode, boolean hasChildrenFlag) {
        ResearchAreaBase researchArea = (ResearchAreaBase)this.businessObjectService.findBySinglePrimaryKey(this.getResearchAreaBOClassHook(), (Object)researchAreaCode);
        if (researchArea.getHasChildrenFlag() != hasChildrenFlag) {
            researchArea.setHasChildrenFlag(hasChildrenFlag);
            this.businessObjectService.save((PersistableBusinessObject)researchArea);
        }
    }

    protected boolean isExistInDeletedChildren(String researchAreaCode, String raCode) {
        boolean isExist = false;
        for (ResearchAreaBase researchArea : this.getSubResearchAreas(raCode, false)) {
            if (researchAreaCode.equals(researchArea.getResearchAreaCode())) {
                isExist = true;
                break;
            }
            isExist = this.isExistInDeletedChildren(researchAreaCode, researchArea.getResearchAreaCode());
        }
        return isExist;
    }

    public void saveResearchAreas(String raChangeXML) throws ParserConfigurationException, IOException, SAXException {
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(raChangeXML));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document raChangesDocument = db.parse(is);
        List raChanges = this.getRaChanges(raChangesDocument);
        for (Element raChange : raChanges) {
            Map details = this.getRaChangeDetails(raChange);
            if (details.containsKey(CREATE_RESEARCH_AREA)) {
                boolean active = StringUtils.equalsIgnoreCase((String)((String)((Map)details.get(CREATE_RESEARCH_AREA)).get(ACTIVE)), (String)TRUE);
                ResearchAreaBase researchArea = this.getNewResearchAreaInstanceHook((String)((Map)details.get(CREATE_RESEARCH_AREA)).get(CODE), (String)((Map)details.get(CREATE_RESEARCH_AREA)).get(PARENT_CODE), (String)((Map)details.get(CREATE_RESEARCH_AREA)).get(DESCRIPTION), active);
                this.businessObjectService.save((PersistableBusinessObject)researchArea);
                this.setHasChildrenFlag((String)((Map)details.get(CREATE_RESEARCH_AREA)).get(PARENT_CODE), true);
            }
            if (details.containsKey(UPDATE_RESEARCH_AREA_DESCRIPTION)) {
                ResearchAreaBase researchArea = (ResearchAreaBase)this.businessObjectService.findBySinglePrimaryKey(this.getResearchAreaBOClassHook(), ((Map)details.get(UPDATE_RESEARCH_AREA_DESCRIPTION)).get(CODE));
                researchArea.setDescription((String)((Map)details.get(UPDATE_RESEARCH_AREA_DESCRIPTION)).get(DESCRIPTION));
                this.businessObjectService.save((PersistableBusinessObject)researchArea);
            }
            if (details.containsKey(UPDATE_RESEARCH_AREA_ACTIVE_FLAG)) {
                ResearchAreaBase researchArea = (ResearchAreaBase)this.businessObjectService.findBySinglePrimaryKey(this.getResearchAreaBOClassHook(), ((Map)details.get(UPDATE_RESEARCH_AREA_ACTIVE_FLAG)).get(CODE));
                researchArea.setActive(true);
                this.businessObjectService.save((PersistableBusinessObject)researchArea);
            }
            if (!details.containsKey(UPDATE_PARENT_RESEARCH_AREA)) continue;
            ResearchAreaBase researchArea = (ResearchAreaBase)this.businessObjectService.findBySinglePrimaryKey(this.getResearchAreaBOClassHook(), ((Map)details.get(UPDATE_PARENT_RESEARCH_AREA)).get(CODE));
            researchArea.setParentResearchAreaCode((String)((Map)details.get(UPDATE_PARENT_RESEARCH_AREA)).get(NEW_PARENT));
            this.businessObjectService.save((PersistableBusinessObject)researchArea);
            this.setHasChildrenFlag((String)((Map)details.get(UPDATE_PARENT_RESEARCH_AREA)).get(NEW_PARENT), true);
            this.updateHasChildrenFlag((String)((Map)details.get(UPDATE_PARENT_RESEARCH_AREA)).get("OldParent"));
        }
    }

    List<Element> getRaChanges(Document doc) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList nodes = doc.getElementsByTagName("RaChangesElement");
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            elements.add((Element)nodes.item(i));
        }
        return elements;
    }

    Map<String, Map<String, String>> getRaChangeDetails(Element raChange) {
        HashMap<String, Map<String, String>> raChangeDetails = new HashMap<String, Map<String, String>>();
        NodeList raChangeDetail = raChange.getChildNodes();
        for (int i = 0; i < raChangeDetail.getLength(); ++i) {
            if (raChangeDetail.item(i).getNodeType() != 1) continue;
            raChangeDetails.put(raChangeDetail.item(i).getNodeName(), this.raChangeAttribute(raChangeDetail.item(i)));
        }
        return raChangeDetails;
    }

    private Map<String, String> raChangeAttribute(Node raChangeDetail) {
        HashMap<String, String> raChangeAttributes = new HashMap<String, String>();
        NodeList attributes = raChangeDetail.getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.item(i).getNodeType() != 1) continue;
            raChangeAttributes.put(attributes.item(i).getNodeName(), attributes.item(i).getFirstChild().getNodeValue());
        }
        return raChangeAttributes;
    }

    public ProtocolBase getCurrentProtocolReferencingResearchArea(String researchAreaCode) {
        ProtocolBase retValue = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(RESEARCH_AREA_CODE, researchAreaCode);
        List pras = (List)this.getBusinessObjectService().findMatching(this.getProtocolResearchAreaBOClassHook(), fieldValues);
        for (ProtocolResearchAreaBase pra : pras) {
            ProtocolBase parentProtocol = pra.getProtocol();
            if (null == parentProtocol || !parentProtocol.isActive()) continue;
            retValue = parentProtocol;
            break;
        }
        return retValue;
    }

    private boolean isCurrentVersion(CommitteeBase committee) {
        boolean retValue = false;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(COMMITTEE_ID, committee.getCommitteeId());
        List committees = (List)this.getBusinessObjectService().findMatchingOrderBy(this.getCommitteeBOClassHook(), fieldValues, SEQUENCE_NUMBER, false);
        if (committees != null && !committees.isEmpty() && ((CommitteeBase)committees.get(0)).getSequenceNumber().equals(committee.getSequenceNumber())) {
            retValue = true;
        }
        return retValue;
    }

    public CommitteeBase getCurrentCommitteeReferencingResearchArea(String researchAreaCode) {
        CommitteeBase retValue = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(RESEARCH_AREA_CODE, researchAreaCode);
        List cras = (List)this.getBusinessObjectService().findMatching(this.getCommitteeResearchAreaBOClassHook(), fieldValues);
        for (CommitteeResearchAreaBase cra : cras) {
            CommitteeBase parentCommittee = (CommitteeBase)this.getBusinessObjectService().findBySinglePrimaryKey(this.getCommitteeBOClassHook(), (Object)cra.getCommitteeIdFk());
            if (null == parentCommittee || !this.isCurrentVersion(parentCommittee)) continue;
            retValue = parentCommittee;
            break;
        }
        return retValue;
    }

    public CommitteeMembershipBase getCurrentCommitteeMembershipReferencingResearchArea(String researchAreaCode) {
        CommitteeMembershipBase retValue = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(RESEARCH_AREA_CODE, researchAreaCode);
        List cmes = (List)this.getBusinessObjectService().findMatching(this.getCommitteeMembershipExpertiseClassHook(), fieldValues);
        for (CommitteeMembershipExpertiseBase cme : cmes) {
            CommitteeBase parentCommittee;
            CommitteeMembershipBase parentCommitteeMembership = (CommitteeMembershipBase)this.getBusinessObjectService().findBySinglePrimaryKey(this.getCommitteeMembershipBOClassHook(), (Object)cme.getCommitteeMembershipIdFk());
            if (null == parentCommitteeMembership || parentCommitteeMembership.hasTermEnded() || null == (parentCommittee = (CommitteeBase)this.getBusinessObjectService().findBySinglePrimaryKey(this.getCommitteeBOClassHook(), (Object)parentCommitteeMembership.getCommitteeIdFk())) || !this.isCurrentVersion(parentCommittee)) continue;
            retValue = parentCommitteeMembership;
            break;
        }
        return retValue;
    }

    protected abstract Class<? extends CommitteeMembershipBase> getCommitteeMembershipBOClassHook();

    protected abstract Class<? extends CommitteeMembershipExpertiseBase> getCommitteeMembershipExpertiseClassHook();

    private void inactivateChildrenResearchAreas(String parentResearchAreaCode) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(PARENT_RESEARCH_AREA_CODE, parentResearchAreaCode);
        List researchAreas = (List)this.businessObjectService.findMatching(this.getResearchAreaBOClassHook(), fieldValues);
        for (ResearchAreaBase researchArea : researchAreas) {
            this.inactivateChildrenResearchAreas(researchArea.getResearchAreaCode());
            researchArea.setActive(false);
            this.businessObjectService.save((PersistableBusinessObject)researchArea);
        }
    }

    public void deactivateResearchAreaAndDescendants(String researchAreaCode) throws Exception {
        ResearchAreaBase researchArea = (ResearchAreaBase)this.businessObjectService.findBySinglePrimaryKey(this.getResearchAreaBOClassHook(), (Object)researchAreaCode);
        if (researchArea != null) {
            researchArea.setActive(false);
            this.businessObjectService.save((PersistableBusinessObject)researchArea);
            this.inactivateChildrenResearchAreas(researchAreaCode);
        }
    }

    public ResearchAreaCurrentReferencerHolderBase getAnyCurrentReferencerForResearchAreaOrDescendant(String researchAreaCode) {
        ResearchAreaCurrentReferencerHolderBase retValue = ResearchAreaCurrentReferencerHolderBase.NO_REFERENCER;
        ProtocolBase referencingProtocol = this.getCurrentProtocolReferencingResearchArea(researchAreaCode);
        if (null != referencingProtocol) {
            retValue = new ResearchAreaCurrentReferencerHolderBase(researchAreaCode, referencingProtocol, null, null);
        } else {
            CommitteeBase referencingCommittee = this.getCurrentCommitteeReferencingResearchArea(researchAreaCode);
            if (null != referencingCommittee) {
                retValue = new ResearchAreaCurrentReferencerHolderBase(researchAreaCode, null, referencingCommittee, null);
            } else {
                CommitteeMembershipBase referencingCommitteeMembership = this.getCurrentCommitteeMembershipReferencingResearchArea(researchAreaCode);
                if (null != referencingCommitteeMembership) {
                    CommitteeBase parentCommittee = (CommitteeBase)this.getBusinessObjectService().findBySinglePrimaryKey(this.getCommitteeBOClassHook(), (Object)referencingCommitteeMembership.getCommitteeIdFk());
                    retValue = new ResearchAreaCurrentReferencerHolderBase(researchAreaCode, null, parentCommittee, referencingCommitteeMembership);
                } else {
                    ResearchAreaBase subResearchArea;
                    HashMap<String, Object> fieldValues = new HashMap<String, Object>();
                    fieldValues.put(PARENT_RESEARCH_AREA_CODE, researchAreaCode);
                    fieldValues.put("active", true);
                    List subResearchAreas = (List)this.getBusinessObjectService().findMatching(this.getResearchAreaBOClassHook(), fieldValues);
                    Iterator i$ = subResearchAreas.iterator();
                    while (i$.hasNext() && (retValue = this.getAnyCurrentReferencerForResearchAreaOrDescendant((subResearchArea = (ResearchAreaBase)i$.next()).getResearchAreaCode())) == ResearchAreaCurrentReferencerHolderBase.NO_REFERENCER) {
                    }
                }
            }
        }
        return retValue;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ResearchAreaReferencesDao getResearchAreaReferencesDao() {
        if (null == this.researchAreaReferencesDao) {
            this.setResearchAreaReferencesDao((ResearchAreaReferencesDao)KraServiceLocator.getService(ResearchAreaReferencesDao.class));
        }
        return this.researchAreaReferencesDao;
    }

    public void setResearchAreaReferencesDao(ResearchAreaReferencesDao researchAreaReferencesDao) {
        this.researchAreaReferencesDao = researchAreaReferencesDao;
    }

    protected abstract Class<? extends CommitteeBase> getCommitteeBOClassHook();

    protected abstract Class<? extends CommitteeResearchAreaBase> getCommitteeResearchAreaBOClassHook();

    protected abstract Class<? extends ProtocolResearchAreaBase> getProtocolResearchAreaBOClassHook();

    protected abstract Class<? extends ResearchAreaBase> getResearchAreaBOClassHook();

    protected abstract ResearchAreaBase getNewResearchAreaInstanceHook(String var1, String var2, String var3, boolean var4);
}

