/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import com.google.common.collect.Sets;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.SeparatelySequenceableAssociate;
import org.kuali.kra.SequenceAssociate;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.Sequenceable;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.service.VersionException;
import org.kuali.kra.service.impl.SequenceUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.ObjectUtils;

public class SequenceUtils {
    private static final String SEQUENCING_ERR_MSG = "An error occured sequencing";
    private static final Log LOG = LogFactory.getLog(SequenceUtils.class);
    private final Set<SequenceAssociate<?>> alreadySequencedAssociates = Collections.synchronizedSet(Sets.newSetFromMap(new IdentityHashMap()));

    public <T extends SequenceOwner<?>> T sequence(T oldVersion) throws VersionException {
        try {
            SequenceOwner newVersion = (SequenceOwner)ObjectUtils.deepCopy(oldVersion);
            newVersion.incrementSequenceNumber();
            this.resetPersistenceState((SequenceAssociate)newVersion);
            this.sequenceAssociations((SequenceAssociate)newVersion);
            return (T)newVersion;
        }
        catch (Exception e) {
            LOG.error((Object)SEQUENCING_ERR_MSG, (Throwable)e);
            throw new VersionException((Throwable)e);
        }
    }

    public <T extends SeparatelySequenceableAssociate> T sequence(T oldAssociate) throws VersionException {
        try {
            SeparatelySequenceableAssociate newAssociate = (SeparatelySequenceableAssociate)ObjectUtils.deepCopy(oldAssociate);
            newAssociate.incrementSequenceNumber();
            newAssociate.resetPersistenceState();
            return (T)newAssociate;
        }
        catch (Exception e) {
            LOG.error((Object)SEQUENCING_ERR_MSG, (Throwable)e);
            throw new VersionException((Throwable)e);
        }
    }

    public <T extends SeparatelySequenceableAssociate> List<T> sequence(List<T> oldAssociates) throws VersionException {
        try {
            ArrayList<SeparatelySequenceableAssociate> newAssociates = new ArrayList<SeparatelySequenceableAssociate>();
            for (SeparatelySequenceableAssociate oldAssociate : oldAssociates) {
                newAssociates.add(this.sequence(oldAssociate));
            }
            return newAssociates;
        }
        catch (Exception e) {
            LOG.error((Object)SEQUENCING_ERR_MSG, (Throwable)e);
            throw new VersionException((Throwable)e);
        }
    }

    private void sequenceAssociations(SequenceAssociate<?> associate) {
        this.alreadySequencedAssociates.add(associate);
        this.sequenceOneToOneAssociations(associate);
        this.sequenceCollections(associate);
    }

    private void sequenceOneToOneAssociations(SequenceAssociate<?> parent) {
        this.sequenceOneToOneAssociations(parent.getClass(), parent);
    }

    private void sequenceOneToOneAssociations(Class clazz, SequenceAssociate<?> parent) {
        for (Field field : clazz.getDeclaredFields()) {
            try {
                Method getter;
                Object obj;
                if (this.skipVersioning(field) || (obj = this.getSequenceAssociateReference(parent, getter = this.findReadMethod(parent, field))) == null || !SequenceAssociate.class.isAssignableFrom(obj.getClass())) continue;
                this.executeSequencing((SequenceAssociate)obj, parent);
            }
            catch (GetterException e) {
                LOG.debug((Object)("No getter found for " + field.getName()), (Throwable)e);
            }
        }
        if (clazz.getSuperclass() != null) {
            this.sequenceOneToOneAssociations(clazz.getSuperclass(), parent);
        }
    }

    private void sequenceCollections(SequenceAssociate<?> parent) {
        this.sequenceCollections(parent.getClass(), parent);
    }

    private void sequenceCollections(Class clazz, SequenceAssociate<?> parent) {
        for (Field field : clazz.getDeclaredFields()) {
            try {
                Collection c;
                if (!this.isFieldACollection(field)) continue;
                Method getter = this.findReadMethod(parent, field);
                if (this.skipVersioning(field) || (c = this.getSequenceAssociateCollection(parent, getter)) == null) continue;
                for (Object obj : c) {
                    if (!SequenceAssociate.class.isAssignableFrom(obj.getClass())) continue;
                    SequenceAssociate associate = (SequenceAssociate)obj;
                    this.executeSequencing(associate, parent);
                }
            }
            catch (GetterException e) {
                LOG.debug((Object)("No getter found for " + field.getName()), (Throwable)e);
            }
        }
        if (clazz.getSuperclass() != null) {
            this.sequenceCollections(clazz.getSuperclass(), parent);
        }
    }

    private void executeSequencing(SequenceAssociate<?> associate, SequenceAssociate<?> parent) {
        if (associate != null && parent != null && !this.alreadySequencedAssociates.contains(associate)) {
            SequenceOwner owner = parent instanceof SequenceOwner ? (SequenceOwner)parent : parent.getSequenceOwner();
            this.setSequenceOwner(associate, owner);
            if (!this.isAssociateAlsoASequenceOwner(associate)) {
                this.sequenceAssociations(associate);
            }
            this.resetPersistenceState(associate);
        }
    }

    private void resetPersistenceState(SequenceAssociate<?> associate) {
        if (associate instanceof PersistableBusinessObject) {
            ((PersistableBusinessObject)associate).setVersionNumber(null);
        }
        associate.resetPersistenceState();
    }

    private boolean isFieldASequenceAssociate(Field field) {
        return this.isFieldASpecifiedType(field, SequenceAssociate.class);
    }

    private boolean isFieldASpecifiedType(Field field, Class<?> type) {
        return type.isAssignableFrom(field.getType());
    }

    private Object getSequenceAssociateReference(SequenceAssociate<?> parent, Method getter) {
        return this.getProperty(parent, getter);
    }

    private boolean isAssociateAlsoASequenceOwner(SequenceAssociate<?> associate) {
        return SequenceOwner.class.isAssignableFrom(associate.getClass());
    }

    private boolean isFieldACollection(Field field) {
        return Collection.class.isAssignableFrom(field.getType());
    }

    private Collection<SequenceAssociate<?>> getSequenceAssociateCollection(Sequenceable parent, Method getter) {
        return (Collection)this.getProperty((Object)parent, getter);
    }

    private <T extends SequenceOwner<?>> void setSequenceOwner(SequenceAssociate<T> toSet, SequenceOwner<?> potentialOwner) {
        if (toSet.getSequenceOwner() != toSet) {
            toSet.setSequenceOwner(potentialOwner);
        }
    }

    private <T> T getProperty(Object o, Method getter) throws PropertyAccessException {
        try {
            return (T)getter.invoke(o, (Object[])null);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException((Throwable)e);
        }
    }

    private Method findReadMethod(Object parent, Field field) throws GetterException {
        PropertyDescriptor pd;
        try {
            pd = PropertyUtils.getPropertyDescriptor((Object)parent, (String)field.getName());
            if (pd == null) {
                throw new GetterException(String.format("The property descriptor for field [%s] on class [%s] could not be found", field.getName(), parent.getClass().getName()));
            }
        }
        catch (IllegalAccessException e) {
            throw new GetterException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new GetterException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new GetterException((Throwable)e);
        }
        Method getter = pd.getReadMethod();
        if (getter == null) {
            throw new GetterException(String.format("No getter defined for field [%s] on class [%s]", field.getName(), parent.getClass().getName()));
        }
        return getter;
    }

    private boolean skipVersioning(Field field) {
        return field.getAnnotation(SkipVersioning.class) != null;
    }
}

