/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.SystemAuthorizationService;
import org.kuali.kra.service.UnitAclLoadService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.util.GlobalVariables;

public class UnitAclLoadServiceImpl
implements UnitAclLoadService {
    private KraAuthorizationService kraAuthorizationService;
    private RoleService roleManagementService;
    private SystemAuthorizationService systemAuthorizationService;

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public void setRoleManagementService(RoleService roleManagementService) {
        this.roleManagementService = roleManagementService;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    public void loadUnitAcl(Permissionable permissionable) {
        String creatorUserId = this.getCreator();
        HashMap<String, String> roleIdMap = new HashMap<String, String>();
        Role role = null;
        Collection kraRoleTemplates = this.getDocumentDefaultAcl(permissionable.getLeadUnitNumber(), permissionable.getDocumentRoleTypeCode());
        for (RoleMembership kraRoleTemplate : kraRoleTemplates) {
            String key;
            String personId = kraRoleTemplate.getMemberId();
            if (personId == null || StringUtils.equals((String)personId, (String)creatorUserId) || !StringUtils.isEmpty((String)((String)roleIdMap.get(key = kraRoleTemplate.getRoleId() + "|" + personId)))) continue;
            role = this.roleManagementService.getRole(kraRoleTemplate.getRoleId());
            roleIdMap.put(key, role.getName());
            this.kraAuthorizationService.addRole(personId, role.getName(), permissionable);
        }
    }

    public String getCreator() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    protected Collection<RoleMembership> getDocumentDefaultAcl(String unitNumber, String documentTypeCode) {
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put("unitNumber", unitNumber);
        ArrayList<String> roleIds = new ArrayList<String>();
        List proposalRoles = this.systemAuthorizationService.getRoles(documentTypeCode);
        for (Role role : proposalRoles) {
            roleIds.add(role.getId());
        }
        List membershipInfoList = this.roleManagementService.getRoleMembers(roleIds, new HashMap(qualifiedRoleAttributes));
        return membershipInfoList;
    }
}

