/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.SeparatelySequenceableAssociate;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.Sequenceable;
import org.kuali.kra.service.VersionException;
import org.kuali.kra.service.VersioningService;
import org.kuali.kra.service.impl.SequenceUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class VersioningServiceImpl
implements VersioningService {
    private static final double NANOS_PER_SECOND = 1.0E9;
    private static final String IN = " in ";
    private static final String SECONDS = " seconds";
    private static final String TO = " to ";
    private static final String VERSIONED_FROM = " versioned from ";
    private static final String PERIOD = ".";
    private static final Log LOG = LogFactory.getLog(VersioningServiceImpl.class);

    public <T extends SequenceOwner<?>> T createNewVersion(T oldVersion) throws VersionException {
        long time = VersioningServiceImpl.getCurrentTime();
        SequenceOwner newVersion = new SequenceUtils().sequence(oldVersion);
        this.logVersionOperation(time, oldVersion, (Sequenceable)newVersion);
        return (T)newVersion;
    }

    public <T extends SeparatelySequenceableAssociate> T versionAssociate(T oldAssociate) throws VersionException {
        long time = VersioningServiceImpl.getCurrentTime();
        SequenceUtils sequenceUtils = new SequenceUtils();
        SeparatelySequenceableAssociate newAssociate = sequenceUtils.sequence(oldAssociate);
        this.logVersionOperation(time, oldAssociate, (Sequenceable)newAssociate);
        return (T)newAssociate;
    }

    public <T extends SeparatelySequenceableAssociate> List<T> versionAssociates(List<T> oldAssociates) throws VersionException {
        long time = VersioningServiceImpl.getCurrentTime();
        SequenceUtils sequenceUtils = new SequenceUtils();
        List newAssociates = sequenceUtils.sequence(oldAssociates);
        this.logVersionOperation(time, oldAssociates, newAssociates);
        return newAssociates;
    }

    protected static long getCurrentTime() {
        return System.nanoTime();
    }

    protected static double calcElapsedTimeInSeconds(long startTime, long endTime) {
        return (double)(endTime - startTime) / 1.0E9;
    }

    protected static String getNonQualifiedClassName(Object o) {
        String name = o.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    protected void logVersionOperation(long startTime, Sequenceable oldVersion, Sequenceable newVersion) {
        this.logVersionOperation(startTime, Collections.singletonList(oldVersion), Collections.singletonList(newVersion));
    }

    protected <T extends Sequenceable> void logVersionOperation(long startTime, List<T> oldVersions, List<T> newVersions) {
        if (LOG.isInfoEnabled()) {
            double seconds = VersioningServiceImpl.calcElapsedTimeInSeconds((long)startTime, (long)VersioningServiceImpl.getCurrentTime());
            for (int i = 0; i < oldVersions.size(); ++i) {
                StringBuilder versionLoggingMessage = new StringBuilder().append(VersioningServiceImpl.getNonQualifiedClassName(oldVersions.get(i))).append(" versioned from ").append(((Sequenceable)oldVersions.get(i)).getSequenceNumber()).append(" to ").append(((Sequenceable)newVersions.get(i)).getSequenceNumber()).append(" in ").append(seconds).append(" seconds");
                LOG.info((Object)versionLoggingMessage);
            }
        }
    }
}

