/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.document;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.util.GlobalVariables;

public class SubAwardDocument
extends ResearchDocumentBase
implements Copyable,
SessionDocument {
    private static final long serialVersionUID = 5454534590787613256L;
    private transient boolean documentSaveAfterVersioning;
    private List<SubAward> subAwardList;
    public static final String DOCUMENT_TYPE_CODE = "SAWD";

    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public SubAwardDocument() {
        this.init();
    }

    public SubAward getSubAward() {
        return this.getSubAwardList().size() > 0 ? (SubAward)this.getSubAwardList().get(0) : new SubAward();
    }

    public void setSubAward(SubAward subAward) {
        this.subAwardList.set(0, subAward);
    }

    public void setSubAwardList(List<SubAward> subAwardList) {
        this.subAwardList = subAwardList;
    }

    public List<SubAward> getSubAwardList() {
        return this.subAwardList;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        String newStatus = statusChangeEvent.getNewRouteStatus();
        if ("F".equalsIgnoreCase(newStatus)) {
            this.getVersionHistoryService().updateVersionHistory((SequenceOwner)this.getSubAward(), VersionStatus.ACTIVE, GlobalVariables.getUserSession().getPrincipalName());
        }
        if (newStatus.equalsIgnoreCase("X") || newStatus.equalsIgnoreCase("D")) {
            this.getVersionHistoryService().updateVersionHistory((SequenceOwner)this.getSubAward(), VersionStatus.CANCELED, GlobalVariables.getUserSession().getPrincipalName());
        }
        for (SubAward subAward : this.subAwardList) {
            subAward.setSubAwardDocument(this);
        }
    }

    public boolean isEditable() {
        WorkflowDocument workflowDoc = this.getDocumentHeader().getWorkflowDocument();
        return workflowDoc.isInitiated() || workflowDoc.isSaved();
    }

    protected void init() {
        this.subAwardList = new ArrayList();
        this.subAwardList.add(new SubAward());
    }

    public boolean isDocumentSaveAfterVersioning() {
        return this.documentSaveAfterVersioning;
    }

    public void setDocumentSaveAfterSubAwardLookupEditOrVersion(boolean documentSaveAfterVersioning) {
        this.documentSaveAfterVersioning = documentSaveAfterVersioning;
    }

    protected VersionHistoryService getVersionHistoryService() {
        return (VersionHistoryService)KraServiceLocator.getService(VersionHistoryService.class);
    }

    public boolean isProcessComplete() {
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && (this.getDocumentHeader().getWorkflowDocument().isFinal() || this.getDocumentHeader().getWorkflowDocument().isProcessed() || ((KraWorkflowService)KraServiceLocator.getService(KraWorkflowService.class)).hasPendingApprovalRequests(this.getDocumentHeader().getWorkflowDocument()))) {
            isComplete = true;
        }
        return isComplete;
    }

    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getSubAward().getSubAwardCustomDataList();
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        SubAward subAward = this.getSubAward();
        managedLists.add(subAward.getSubAwardFundingSourceList());
        managedLists.add(subAward.getSubAwardContactsList());
        managedLists.add(subAward.getSubAwardCloseoutList());
        return managedLists;
    }

    public String getCustomLockDescriptor(Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        String updatedTimestamp = "";
        if (this.getUpdateTimestamp() != null) {
            updatedTimestamp = new SimpleDateFormat("MM/dd/yyyy KK:mm a").format(this.getUpdateTimestamp());
        }
        if (StringUtils.isNotEmpty((String)activeLockRegion)) {
            return this.getSubAward().getSubAwardCode() + "-" + activeLockRegion + "-" + GlobalVariables.getUserSession().getPrincipalName() + "-" + updatedTimestamp;
        }
        return null;
    }

    public boolean useCustomLockDescriptors() {
        return true;
    }
}

