/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.document;

import java.util.Map;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.subaward.bo.SubAwardAmountReleased;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.DictionaryValidationService;
import org.kuali.rice.krad.util.GlobalVariables;

public class SubAwardInvoiceMaintainableImpl
extends KraMaintainableImpl {
    private static final long serialVersionUID = 7243072336736625204L;
    private transient DateTimeService dateTimeService = (DateTimeService)KraServiceLocator.getService(DateTimeService.class);
    private transient DictionaryValidationService dictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        SubAwardAmountReleased invoice = (SubAwardAmountReleased)document.getNoteTarget();
        invoice.setSubAwardId(Long.valueOf(Long.parseLong(requestParameters.get("subAwardId")[0])));
        invoice.setSubAwardCode(requestParameters.get("subAwardCode")[0]);
        invoice.setSequenceNumber(Integer.valueOf(Integer.parseInt(requestParameters.get("sequenceNumber")[0])));
        invoice.setCreatedDate(this.getDateTimeService().getCurrentTimestamp());
        invoice.setCreatedBy(GlobalVariables.getUserSession().getPrincipalId());
    }

    public void prepareForSave() {
        super.prepareForSave();
        SubAwardAmountReleased invoice = (SubAwardAmountReleased)this.getBusinessObject();
        invoice.setDocumentNumber(this.getDocumentNumber());
        GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject");
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)invoice, true);
        GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject");
        if (GlobalVariables.getMessageMap().getErrorCount() == 0) {
            invoice.populateAttachment();
            this.getBusinessObjectService().save((PersistableBusinessObject)invoice);
        }
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        SubAwardAmountReleased invoice = (SubAwardAmountReleased)this.getBusinessObject();
        invoice.setInvoiceStatus(documentHeader.getWorkflowDocument().getStatus().getCode());
        invoice.populateAttachment();
        this.getBusinessObjectService().save((PersistableBusinessObject)invoice);
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)KraServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    protected DictionaryValidationService getDictionaryValidationService() {
        if (this.dictionaryValidationService == null) {
            this.dictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();
        }
        return this.dictionaryValidationService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }
}

