/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.document.authorizer;

import java.util.Map;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAmountReleased;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.document.authorization.SubAwardTask;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class SubAwardInvoiceMaintenanceDocumentAuthorizer
extends MaintenanceDocumentAuthorizerBase {
    private static final long serialVersionUID = -3808004509488121973L;

    public boolean canDisapprove(Document document, Person user) {
        return super.canApprove(document, user);
    }

    public boolean canApprove(Document document, Person user) {
        boolean result = super.canApprove(document, user);
        if (result) {
            MaintenanceDocument maintDoc = (MaintenanceDocument)document;
            try {
                SubAward subAward = (SubAward)this.getBusinessObjectService().findBySinglePrimaryKey(SubAward.class, (Object)((SubAwardAmountReleased)maintDoc.getNewMaintainableObject().getDataObject()).getSubAwardId());
                SubAwardDocument subAwardDoc = (SubAwardDocument)this.getDocumentService().getByDocumentHeaderId(subAward.getSubAwardDocument().getDocumentNumber());
                result &= !this.getTaskAuthorizationService().isAuthorized(user.getPrincipalId(), (Task)new SubAwardTask("modifySubaward", subAwardDoc));
            }
            catch (WorkflowException e) {
                // empty catch block
            }
        }
        return result;
    }

    protected void addRoleQualification(Object primaryDataObjectOrDocument, Map<String, String> attributes) {
        super.addRoleQualification(primaryDataObjectOrDocument, attributes);
        SubAwardAmountReleased invoice = (SubAwardAmountReleased)((MaintenanceDocument)primaryDataObjectOrDocument).getNewMaintainableObject().getDataObject();
        if (invoice != null && invoice.getSubAwardId() != null) {
            attributes.put("subAward", invoice.getSubAwardId().toString());
        }
    }

    protected final TaskAuthorizationService getTaskAuthorizationService() {
        return (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected final BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    protected final DocumentService getDocumentService() {
        return (DocumentService)KraServiceLocator.getService(DocumentService.class);
    }
}

