/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.notification;

import java.util.List;
import org.kuali.kra.common.notification.NotificationContextBase;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.service.KcNotificationModuleRoleService;
import org.kuali.kra.common.notification.service.KcNotificationRoleQualifierService;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.notification.SubAwardNotificationRenderer;
import org.kuali.kra.subaward.notification.SubAwardNotificationRoleQualifierService;
import org.kuali.kra.util.EmailAttachment;

public class SubAwardNotificationContext
extends NotificationContextBase {
    private SubAward subAward;
    private String documentNumber;
    private String actionTypeCode;
    private String contextName;
    private List<EmailAttachment> emailAttachments;
    private String forwardName;

    public SubAwardNotificationContext(SubAward subAward, String actionTypeCode, String contextName, NotificationRenderer renderer, String forwardName) {
        super(renderer);
        this.subAward = subAward;
        this.documentNumber = subAward.getSubAwardDocument().getDocumentNumber();
        this.actionTypeCode = actionTypeCode;
        this.contextName = contextName;
        this.forwardName = forwardName;
        this.setNotificationService((KcNotificationService)KraServiceLocator.getService(KcNotificationService.class));
        this.setNotificationModuleRoleService((KcNotificationModuleRoleService)KraServiceLocator.getService(KcNotificationModuleRoleService.class));
        this.setNotificationRoleQualifierService((KcNotificationRoleQualifierService)KraServiceLocator.getService(SubAwardNotificationRoleQualifierService.class));
        ((SubAwardNotificationRoleQualifierService)this.getNotificationRoleQualifierService()).setSubAward(subAward);
    }

    public SubAwardNotificationContext(SubAward subAward, String actionTypeCode, String contextName) {
        this(subAward, actionTypeCode, contextName, (NotificationRenderer)new SubAwardNotificationRenderer(subAward), "awardActions");
        ((SubAwardNotificationRenderer)this.getRenderer()).setSubAward(subAward);
    }

    public SubAwardNotificationContext(SubAward subAward, String actionTypeCode, String contextName, String forwardName) {
        this(subAward, actionTypeCode, contextName, (NotificationRenderer)new SubAwardNotificationRenderer(subAward), forwardName);
        ((SubAwardNotificationRenderer)this.getRenderer()).setSubAward(subAward);
    }

    public String getModuleCode() {
        return "1";
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    public String getContextName() {
        return this.contextName;
    }

    public List<EmailAttachment> getEmailAttachments() {
        return this.emailAttachments;
    }

    public void setEmailAttachments(List<EmailAttachment> emailAttachments) {
        this.emailAttachments = emailAttachments;
    }

    public SubAward getSubAward() {
        return this.subAward;
    }

    public void setSubAward(SubAward subAward) {
        this.subAward = subAward;
    }

    public String getForwardName() {
        return this.forwardName;
    }

    public void setForwardName(String forwardName) {
        this.forwardName = forwardName;
    }
}

