/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.notification;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.kuali.kra.common.notification.NotificationRendererBase;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.rice.krad.util.GlobalVariables;

public class SubAwardNotificationRenderer
extends NotificationRendererBase {
    private SubAward subAward;

    public SubAwardNotificationRenderer() {
    }

    public SubAwardNotificationRenderer(SubAward subAward) {
        this.subAward = subAward;
    }

    public Map<String, String> getDefaultReplacementParameters() {
        return this.getSubAwardReplacementParameters(this.subAward);
    }

    public Map<String, String> getSubAwardReplacementParameters(SubAward subAward) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy");
        Map result = super.getDefaultReplacementParameters();
        result.put("{SUBAWARD_ID}", subAward.getSubAwardId().toString());
        result.put("{SEQUENCE_NUMBER}", subAward.getSequenceNumber().toString());
        result.put("{SUBAWARD_TITLE}", subAward.getTitle());
        result.put("{LEAD_UNIT}", subAward.getLeadUnitNumber() == null ? "" : subAward.getLeadUnitNumber());
        result.put("{LEAD_UNIT_NAME}", subAward.getLeadUnitName() == null ? "" : subAward.getLeadUnitName());
        result.put("{ACCOUNT_NUMBER}", subAward.getAccountNumber() == null ? "" : subAward.getAccountNumber());
        result.put("{SPONSOR_AWARD_NUMBER}", subAward.getSponsorAwardNumber() == null ? "" : subAward.getSponsorAwardNumber());
        if (subAward.getStatusCode() != null) {
            result.put("{STATUS_CODE}", subAward.getStatusCode().toString());
            result.put("{STATUS_NAME}", subAward.getStatusDescription());
        } else {
            result.put("{STATUS_CODE}", "");
            result.put("{STATUS_NAME}", "");
        }
        if (subAward.getStartDate() != null) {
            result.put("{BEGIN_DATE}", dateFormatter.format(subAward.getStartDate()));
        } else {
            result.put("{BEGIN_DATE}", "");
        }
        if (subAward.getSponsorCode() != null) {
            result.put("{SPONSOR_CODE}", subAward.getSponsorCode());
            result.put("{SPONSOR_NAME}", subAward.getSponsorName());
        } else {
            result.put("{SPONSOR_CODE}", "");
            result.put("{SPONSOR_NAME}", "");
        }
        if (subAward.getPrimeSponsorCode() != null) {
            result.put("{PRIME_SPONSOR_CODE}", subAward.getPrimeSponsorCode());
            result.put("{PRIME_SPONSOR_NAME}", subAward.getPrimeSponsorName());
        } else {
            result.put("{PRIME_SPONSOR_CODE}", "");
            result.put("{PRIME_SPONSOR_NAME}", "");
        }
        result.put("{USER_FULLNAME}", GlobalVariables.getUserSession().getPerson().getName());
        return result;
    }

    public SubAward getSubAward() {
        return this.subAward;
    }

    public void setSubAward(SubAward subAward) {
        this.subAward = subAward;
    }
}

