/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.subawardrule;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class SubAwardAuditRule
extends ResearchDocumentRuleBase
implements DocumentAuditRule {
    private static final String CONTACTS_AUDIT_ERRORS = "contactsAuditErrors";
    private List<AuditError> auditErrors = new ArrayList();

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        this.auditErrors = new ArrayList();
        this.reportAndCreateAuditCluster();
        return valid &= this.checkForAtLeastOneContact(document);
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            AuditCluster existingErrors = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(CONTACTS_AUDIT_ERRORS);
            if (existingErrors == null) {
                KNSGlobalVariables.getAuditErrorMap().put(CONTACTS_AUDIT_ERRORS, new AuditCluster("Contacts", this.auditErrors, "Validation Errors"));
            } else {
                existingErrors.getAuditErrorList().addAll(this.auditErrors);
            }
        }
    }

    protected boolean checkForAtLeastOneContact(Document document) {
        SubAwardDocument subAwardDocument = (SubAwardDocument)document;
        subAwardDocument.getSubAward().getSubAwardContactsList().size();
        if (subAwardDocument.getSubAward().getSubAwardContactsList().size() <= 0) {
            subAwardDocument.getSubAward().setDefaultOpen(false);
            this.auditErrors.add(new AuditError("newSubAwardContact.rolodex.fullName", "subaward.contact.not.added", "subAward.Contacts"));
            return false;
        }
        subAwardDocument.getSubAward().setDefaultOpen(true);
        return true;
    }
}

