/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.subawardrule;

import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rule.event.KraDocumentEventBaseExtension;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.bo.SubAwardCloseout;
import org.kuali.kra.subaward.bo.SubAwardContact;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.subawardrule.SubAwardAmountInfoRule;
import org.kuali.kra.subaward.subawardrule.SubAwardAuditRule;
import org.kuali.kra.subaward.subawardrule.SubAwardCloseoutRule;
import org.kuali.kra.subaward.subawardrule.SubAwardContactRule;
import org.kuali.kra.subaward.subawardrule.SubAwardFinancialAuditRule;
import org.kuali.kra.subaward.subawardrule.SubAwardFundingSourceRule;
import org.kuali.kra.subaward.subawardrule.SubAwardRule;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class SubAwardDocumentRule
extends ResearchDocumentRuleBase
implements SubAwardRule,
SubAwardAmountInfoRule,
SubAwardContactRule,
SubAwardCloseoutRule,
SubAwardFundingSourceRule {
    private static final String STATUS_CODE = ".statusCode";
    private static final String SUBAWARD_TYPE_CODE = ".subAwardTypeCode";
    private static final String REQUISITIONER = ".requisitionerUserName";
    private static final String REQUISITIONER_UNIT = ".requisitionerUnit";
    private static final String PURCHASE_ORDER_NUM = ".purchaseOrderNum";
    private static final String SUBCONTRACTOR_ID = ".organizationId";
    private static final String NEW_SUBAWARD = "document.subAwardList[0]";
    private static final String SUBAWARD_START_DATE = ".startDate";
    private static final String SITEINVESTIGATOR = ".siteInvestigatorId";
    private static final String AMOUNT_INFO_OBLIGATED_AMOUNT = "newSubAwardAmountInfo.obligatedChange";
    private static final String AMOUNT_INFO_ANTICIPATED_AMOUNT = "newSubAwardAmountInfo.anticipatedChange";
    private static final String AMOUNT_INFO_ERRORS = "subAwardAmountInfoErrors";
    private static final String ROLODEX_ID = "newSubAwardContact.rolodex.fullName";
    private static final String CONTACT_TYPE_CODE = "newSubAwardContact.contactTypeCode";
    private static final String CLOSEOUT_TYPE_CODE = "newSubAwardCloseout.closeoutTypeCode";
    private static final String DATE_REQUESTED = "newSubAwardCloseout.dateRequested";
    private static final String DATE_FLLOWUP = "newSubAwardCloseout.dateFollowup";
    private static final String AWARD_NUMBER = "newSubAwardFundingSource.award.awardNumber";

    public boolean processAddSubAwardBusinessRules(SubAward subAward) {
        boolean rulePassed = true;
        return rulePassed &= this.processSaveSubAwardBusinessRules(subAward, NEW_SUBAWARD);
    }

    protected boolean processSaveSubAwardBusinessRules(SubAward subAward, String propertyPrefix) {
        Unit leadUnit;
        boolean rulePassed = true;
        if (subAward.getOrganizationId() == null) {
            rulePassed = false;
            this.reportError(propertyPrefix + SUBCONTRACTOR_ID, "error.required.subrecipient.id", new String[0]);
        }
        if (subAward.getStatusCode() == null) {
            rulePassed = false;
            this.reportError(propertyPrefix + STATUS_CODE, "error.required.statuscode", new String[0]);
        }
        if (subAward.getSubAwardTypeCode() == null) {
            rulePassed = false;
            this.reportError(propertyPrefix + SUBAWARD_TYPE_CODE, "error.required.subaward.typecode", new String[0]);
        }
        if (subAward.getRequisitionerId() == null) {
            rulePassed = false;
            if (subAward.getRequisitionerUserName() == null) {
                this.reportError(propertyPrefix + REQUISITIONER, "error.required.requisitioner", new String[0]);
            } else {
                this.reportError(propertyPrefix + REQUISITIONER, "error.invalid.requisitioner", new String[]{subAward.getRequisitionerUserName()});
            }
        }
        if (subAward.getRequisitionerUnit() != null && (leadUnit = (Unit)this.getBusinessObjectService().findByPrimaryKey(Unit.class, Collections.singletonMap("unitNumber", subAward.getRequisitionerUnit()))) == null) {
            this.reportError(propertyPrefix + REQUISITIONER_UNIT, "error.required.requisitioner.unit", new String[0]);
        }
        if (subAward.getPurchaseOrderNum() == null) {
            rulePassed = false;
            this.reportError(propertyPrefix + PURCHASE_ORDER_NUM, "error.required.purchase.order.num", new String[0]);
        }
        if (subAward.getStartDate() != null && subAward.getEndDate() != null && subAward.getStartDate().after(subAward.getEndDate())) {
            rulePassed = false;
            this.reportError(propertyPrefix + SUBAWARD_START_DATE, "subaward.error.end.date.greater.than.start", new String[0]);
        }
        if (subAward.getSiteInvestigator() == null && subAward.getSiteInvestigatorId() != null) {
            rulePassed = false;
            this.reportError(propertyPrefix + SITEINVESTIGATOR, "error.invalid.siteinvestigator.id", new String[]{subAward.getSiteInvestigatorId().toString()});
        }
        if (subAward.getOrganizationId() != null && subAward.getOrganization() == null) {
            rulePassed = false;
            this.reportError(propertyPrefix + SUBCONTRACTOR_ID, "error.invalid.subrecipient.id", new String[]{subAward.getOrganizationId()});
        }
        return rulePassed;
    }

    public boolean processSaveSubAwardAmountInfoBusinessRule(SubAward subAward) {
        boolean rulePassed = true;
        if (subAward.getTotalObligatedAmount() != null && subAward.getTotalObligatedAmount().isNegative()) {
            rulePassed = false;
            this.reportError(AMOUNT_INFO_ERRORS, "subaward.error.obligated.amount.less.than.zero", new String[0]);
        }
        if (subAward.getTotalAnticipatedAmount() != null && subAward.getTotalAnticipatedAmount().isNegative()) {
            rulePassed = false;
            this.reportError(AMOUNT_INFO_ERRORS, "subaward.error.anticipated.amount.less.than.zero", new String[0]);
        }
        if (subAward.getTotalAvailableAmount() != null && subAward.getTotalAvailableAmount().isNegative()) {
            rulePassed = false;
            this.reportError(AMOUNT_INFO_ERRORS, "subaward.error.amount.released.greater.than.obligated.amount", new String[0]);
        }
        if (subAward.getTotalObligatedAmount().isGreaterThan((AbstractKualiDecimal)subAward.getTotalAnticipatedAmount())) {
            rulePassed = false;
            this.reportError(AMOUNT_INFO_ERRORS, "subaward.error.obligated.amount.greater.than.anticipated.amount", new String[0]);
        }
        return rulePassed;
    }

    public boolean processAddSubAwardAmountInfoBusinessRules(SubAwardAmountInfo amountInfo, SubAward subAward) {
        boolean rulePassed = true;
        GlobalVariables.getMessageMap().addToErrorPath("newSubAwardAmountInfo");
        rulePassed &= this.getDictionaryValidationService().isBusinessObjectValid((BusinessObject)amountInfo);
        GlobalVariables.getMessageMap().removeFromErrorPath("newSubAwardAmountInfo");
        KualiDecimal obligatedAmount = subAward.getTotalObligatedAmount();
        if (amountInfo.getObligatedChange() != null && (obligatedAmount = (KualiDecimal)obligatedAmount.add((AbstractKualiDecimal)amountInfo.getObligatedChange())).isNegative()) {
            rulePassed = false;
            this.reportError(AMOUNT_INFO_OBLIGATED_AMOUNT, "subaward.error.obligated.amount.less.than.zero", new String[0]);
        }
        KualiDecimal anticipatedAmount = subAward.getTotalAnticipatedAmount();
        if (amountInfo.getAnticipatedChange() != null && (anticipatedAmount = (KualiDecimal)anticipatedAmount.add((AbstractKualiDecimal)amountInfo.getAnticipatedChange())).isNegative()) {
            rulePassed = false;
            this.reportError(AMOUNT_INFO_ANTICIPATED_AMOUNT, "subaward.error.anticipated.amount.less.than.zero", new String[0]);
        }
        if (obligatedAmount.isGreaterThan((AbstractKualiDecimal)anticipatedAmount)) {
            rulePassed = false;
            this.reportError(AMOUNT_INFO_ANTICIPATED_AMOUNT, "subaward.error.obligated.amount.greater.than.anticipated.amount", new String[0]);
        }
        if (obligatedAmount.isLessThan((AbstractKualiDecimal)subAward.getTotalAmountReleased())) {
            rulePassed = false;
            this.reportError(AMOUNT_INFO_OBLIGATED_AMOUNT, "subaward.error.oblig.amount.greater.than.amount.released", new String[0]);
        }
        return rulePassed;
    }

    public boolean processDeleteSubAwardAmountInfoBusinessRules(SubAwardAmountInfo subAwardAmountInfo, SubAward subAward) {
        boolean rulePassed = true;
        if (((KualiDecimal)subAward.getTotalObligatedAmount().subtract((AbstractKualiDecimal)subAwardAmountInfo.getObligatedChange())).isLessThan((AbstractKualiDecimal)subAward.getTotalAmountReleased())) {
            rulePassed = false;
            this.reportError(AMOUNT_INFO_OBLIGATED_AMOUNT, "subaward.error.oblig.amount.is.greater.than.amount.released", new String[0]);
        }
        return rulePassed;
    }

    public boolean processAddSubAwardContactBusinessRules(SubAwardContact subAwardContact, SubAward subAward) {
        boolean rulePassed = true;
        if (subAwardContact == null || subAwardContact.getRolodexId() == null) {
            rulePassed = false;
            this.reportError(ROLODEX_ID, "error.required.subaward.contact.rolodex.id", new String[0]);
        }
        if (subAwardContact == null || subAwardContact.getContactTypeCode() == null) {
            rulePassed = false;
            this.reportError(CONTACT_TYPE_CODE, "error.required.subaward.contact.contact.type.code", new String[0]);
        }
        for (SubAwardContact contact : subAward.getSubAwardContactsList()) {
            if (!ObjectUtils.equals((Object)contact.getRolodexId(), (Object)subAwardContact.getRolodexId()) || !ObjectUtils.equals((Object)contact.getContactTypeCode(), (Object)subAwardContact.getContactTypeCode())) continue;
            rulePassed = false;
            String contactName = contact.getRolodex().getFullName();
            if (contactName == null) {
                contactName = contact.getRolodex().getOrganization();
            }
            this.reportError(ROLODEX_ID, "error.subAwardSponsorContact.person.exists", new String[]{contactName});
        }
        return rulePassed;
    }

    public boolean processAddSubAwardCloseoutBusinessRules(SubAwardCloseout subAwardCloseout) {
        boolean rulePassed = true;
        return rulePassed &= this.processSaveSubAwardCloseoutBusinessRules(subAwardCloseout);
    }

    protected boolean processSaveSubAwardCloseoutBusinessRules(SubAwardCloseout subAwardCloseout) {
        boolean rulePassed = true;
        if (subAwardCloseout == null || subAwardCloseout.getCloseoutTypeCode() == null) {
            rulePassed = false;
            this.reportError(CLOSEOUT_TYPE_CODE, "error.required.subaward.closeout.closeout.type.code", new String[0]);
        }
        if (subAwardCloseout == null || subAwardCloseout.getDateRequested() == null) {
            rulePassed = false;
            this.reportError(DATE_REQUESTED, "error.required.subaward.closeout.date.requested", new String[0]);
        }
        if (subAwardCloseout == null || subAwardCloseout.getDateFollowup() == null) {
            rulePassed = false;
            this.reportError(DATE_FLLOWUP, "error.required.subaward.closeout.date.followup", new String[0]);
        }
        return rulePassed;
    }

    public boolean processAddSubAwardFundingSourceBusinessRules(SubAwardFundingSource subAwardFundingSource, SubAward subAward) {
        boolean rulePassed = true;
        return rulePassed &= this.processSaveSubAwardFundingSourceBusinessRules(subAwardFundingSource, subAward);
    }

    protected boolean processSaveSubAwardFundingSourceBusinessRules(SubAwardFundingSource subAwardFundingSource, SubAward subAward) {
        boolean rulePassed = true;
        if (subAwardFundingSource == null || subAwardFundingSource.getAwardId() == null) {
            rulePassed = false;
            this.reportError(AWARD_NUMBER, "error.required.subaward.funding.source.award.number", new String[0]);
        } else {
            for (SubAwardFundingSource fundingSource : subAward.getSubAwardFundingSourceList()) {
                if (!fundingSource.getAwardId().equals(subAwardFundingSource.getAwardId())) continue;
                rulePassed = false;
                AwardService awardService = (AwardService)KraServiceLocator.getService(AwardService.class);
                Award award = awardService.getAward(fundingSource.getAwardId());
                this.reportError(AWARD_NUMBER, "error.required.subaward.funding.source.award.number.duplicate", new String[]{award.getAwardNumber()});
            }
        }
        return rulePassed;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean retval = true;
        retval = super.processRunAuditBusinessRules(document);
        retval &= new SubAwardAuditRule().processRunAuditBusinessRules(document);
        return retval &= new SubAwardFinancialAuditRule().processRunAuditBusinessRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        if (!(document instanceof SubAwardDocument)) {
            return false;
        }
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.addToErrorPath("document");
        this.getDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively(document, this.getMaxDictionaryValidationDepth(), true, false);
        errorMap.removeFromErrorPath("document");
        return true;
    }

    public boolean processRules(KraDocumentEventBaseExtension event) {
        boolean retVal = false;
        retVal = event.getRule().processRules(event);
        return retVal;
    }
}

