/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.subawardrule;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class SubAwardFinancialAuditRule
extends ResearchDocumentRuleBase
implements DocumentAuditRule {
    private static final String SUBAWARD_FINANCIAL_AUDIT_WARNINGS = "subawardFinancialdAuditWarnings";
    private List<AuditError> auditWarnings = new ArrayList();

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        this.auditWarnings = new ArrayList();
        valid &= this.checkForObligatedAmountZero(document);
        this.reportAndCreateFinancialAuditCluster();
        return valid &= this.checkForAnticipatedAmountZero(document);
    }

    protected void reportAndCreateFinancialAuditCluster() {
        if (this.auditWarnings.size() > 0) {
            AuditCluster existingErrors = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(SUBAWARD_FINANCIAL_AUDIT_WARNINGS);
            if (existingErrors == null) {
                KNSGlobalVariables.getAuditErrorMap().put(SUBAWARD_FINANCIAL_AUDIT_WARNINGS, new AuditCluster("Financial", this.auditWarnings, "Warnings"));
            } else {
                existingErrors.getAuditErrorList().addAll(this.auditWarnings);
            }
        }
    }

    protected boolean checkForObligatedAmountZero(Document document) {
        SubAwardDocument subAwardDocument = (SubAwardDocument)document;
        KualiDecimal obligatedAmount = KualiDecimal.ZERO;
        for (SubAwardAmountInfo subAwardAmountInfo : subAwardDocument.getSubAward().getSubAwardAmountInfoList()) {
            if (subAwardAmountInfo.getObligatedChange() == null) continue;
            obligatedAmount = (KualiDecimal)obligatedAmount.add((AbstractKualiDecimal)subAwardAmountInfo.getObligatedChange());
        }
        if (obligatedAmount.isZero()) {
            subAwardDocument.getSubAward().setDefaultOpen(false);
            this.auditWarnings.add(new AuditError("document.subAwardList[0].totalObligatedAmount", "subaward.error.obligated.amount.equal.to.zero", "financial.Financial"));
            return false;
        }
        return true;
    }

    protected boolean checkForAnticipatedAmountZero(Document document) {
        KualiDecimal anticipateAmount = KualiDecimal.ZERO;
        SubAwardDocument subAwardDocument = (SubAwardDocument)document;
        for (SubAwardAmountInfo subAwardAmountInfo : subAwardDocument.getSubAward().getSubAwardAmountInfoList()) {
            if (subAwardAmountInfo.getAnticipatedChange() == null) continue;
            anticipateAmount = (KualiDecimal)anticipateAmount.add((AbstractKualiDecimal)subAwardAmountInfo.getAnticipatedChange());
        }
        if (anticipateAmount.isZero()) {
            subAwardDocument.getSubAward().setDefaultOpen(false);
            this.auditWarnings.add(new AuditError("document.subAwardList[0].totalAnticipatedAmount", "subaward.error.anticipated.amount.equal.to.zero", "financial.Financial"));
            return false;
        }
        return true;
    }
}

