/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.document.authorizer;

import org.kuali.kra.infrastructure.AwardPermissionConstants;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.document.authorization.TimeAndMoneyTask;
import org.kuali.kra.timeandmoney.document.authorizer.TimeAndMoneyAuthorizer;
import org.kuali.rice.krad.document.Document;

public class ModifyTimeAndMoneyAuthorizer
extends TimeAndMoneyAuthorizer {
    public boolean isAuthorized(String userId, TimeAndMoneyTask task) {
        TimeAndMoneyDocument timeAndMoneyDocument = task.getTimeAndMoneyDocument();
        return timeAndMoneyDocument.isNew() ? this.canUserCreateAward(userId, timeAndMoneyDocument) : this.canUserModifyAward(userId, timeAndMoneyDocument);
    }

    protected boolean canUserCreateAward(String userId, TimeAndMoneyDocument timeAndMoneyDocument) {
        return true;
    }

    protected boolean canUserModifyAward(String userId, TimeAndMoneyDocument doc) {
        return !doc.isViewOnly() && this.hasPermission(userId, doc, AwardPermissionConstants.MODIFY_AWARD.getAwardPermission()) && !this.kraWorkflowService.isInWorkflow((Document)doc);
    }
}

