/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.rules;

import java.sql.Date;
import java.util.Map;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.AwardDateRulesHelper;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.TimeAndMoneyForm;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.rule.event.TimeAndMoneyAwardDateSaveEvent;
import org.kuali.kra.timeandmoney.rules.TimeAndMoneyAwardDateSaveRule;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class TimeAndMoneyAwardDateSaveRuleImpl
extends ResearchDocumentRuleBase
implements TimeAndMoneyAwardDateSaveRule {
    private static final String OBLIGATED_DATE_PROPERTY = "obligatedDate";
    private static final String OBLIGATED_END_DATE_PROPERTY = "obligatedEndDate";
    private static final String OBLIGATED_START_DATE_PROPERTY = "obligatedStartDate";
    private static final String FINAL_EXPIRATION_DATE_PROPERTY = "finalExpirationDate";
    private static final String AWARD_EFFECTIVE_DATE_PROPERTY = "document.awardList[0].awardEffectiveDate";

    public boolean processSaveAwardDatesBusinessRules(TimeAndMoneyAwardDateSaveEvent timeAndMoneyAwardDateSaveEvent) {
        TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)timeAndMoneyAwardDateSaveEvent.getDocument();
        this.clearFieldsFromUserSessionMap();
        return this.validateObligatedDates(timeAndMoneyDocument);
    }

    private boolean validateObligatedDates(TimeAndMoneyDocument document) {
        boolean valid = true;
        int i = 0;
        for (Map.Entry awardHierarchyNode : document.getAwardHierarchyNodes().entrySet()) {
            Award award = this.getAwardVersionService().getWorkingAwardVersion(((AwardHierarchyNode)awardHierarchyNode.getValue()).getAwardNumber());
            AwardAmountInfo aai = this.getAwardAmountInfoService().fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
            Date obligatedStartDate = ((AwardHierarchyNode)awardHierarchyNode.getValue()).getCurrentFundEffectiveDate();
            Date obligatedEndDate = ((AwardHierarchyNode)awardHierarchyNode.getValue()).getObligationExpirationDate();
            Date projectEndDate = ((AwardHierarchyNode)awardHierarchyNode.getValue()).getFinalExpirationDate();
            Date projectStartDate = aai.getAward().getAwardEffectiveDate();
            KualiDecimal obligatedTotal = ((AwardHierarchyNode)awardHierarchyNode.getValue()).getAmountObligatedToDate();
            MessageMap errorMap = GlobalVariables.getMessageMap();
            String fieldStarter = "awardHierarchyNodeItems[" + (i + 1);
            String awardId = award.getAwardNumber();
            String finalExpirationField = fieldStarter + "].finalExpirationDate";
            String obligationExirationField = fieldStarter + "].obligationExpirationDate";
            String currentFundEffectiveField = fieldStarter + "].currentFundEffectiveDate";
            boolean validateProjectStartBeforeProjectEnd = AwardDateRulesHelper.validateProjectStartBeforeProjectEnd((MessageMap)errorMap, (Date)projectStartDate, (Date)projectEndDate, (String)finalExpirationField, (String)awardId);
            boolean validateObligationStartBeforeObligationEnd = AwardDateRulesHelper.validateObligationStartBeforeObligationEnd((MessageMap)errorMap, (Date)obligatedStartDate, (Date)obligatedEndDate, (String)obligationExirationField, (String)awardId);
            boolean validateProjectStartBeforeObligationStart = AwardDateRulesHelper.validateProjectStartBeforeObligationStart((MessageMap)errorMap, (Date)projectStartDate, (Date)obligatedStartDate, (String)currentFundEffectiveField, (String)awardId);
            boolean validateProjectStartBeforeObligationEnd = AwardDateRulesHelper.validateProjectStartBeforeObligationEnd((MessageMap)errorMap, (Date)projectStartDate, (Date)obligatedEndDate, (String)obligationExirationField, (String)awardId);
            boolean validateObligationStartBeforeProjectEnd = AwardDateRulesHelper.validateObligationStartBeforeProjectEnd((MessageMap)errorMap, (Date)obligatedStartDate, (Date)projectEndDate, (String)currentFundEffectiveField, (String)awardId);
            boolean validateObligationEndBeforeProjectEnd = AwardDateRulesHelper.validateObligationEndBeforeProjectEnd((MessageMap)errorMap, (Date)obligatedEndDate, (Date)projectEndDate, (String)obligationExirationField, (String)awardId);
            if (!validateProjectStartBeforeProjectEnd) {
                this.addFieldToUserSessionMap(finalExpirationField);
            }
            if (!validateProjectStartBeforeObligationStart || !validateObligationStartBeforeProjectEnd) {
                this.addFieldToUserSessionMap(currentFundEffectiveField);
            }
            if (!(validateObligationStartBeforeObligationEnd && validateProjectStartBeforeObligationEnd && validateObligationEndBeforeProjectEnd)) {
                this.addFieldToUserSessionMap(obligationExirationField);
            }
            boolean bl = valid = valid && validateProjectStartBeforeProjectEnd && validateObligationStartBeforeObligationEnd && validateProjectStartBeforeObligationStart && validateProjectStartBeforeObligationEnd && validateObligationStartBeforeProjectEnd && validateObligationEndBeforeProjectEnd;
            if (obligatedTotal != null && obligatedTotal.isGreaterThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                if (obligatedStartDate == null) {
                    if ("1".equals(this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST"))) {
                        this.reportError(currentFundEffectiveField, "error.award.effective.date.total", new String[0]);
                    } else {
                        this.reportError(currentFundEffectiveField, "error.award.effective.date", new String[0]);
                    }
                    this.addFieldToUserSessionMap(currentFundEffectiveField);
                    valid = false;
                }
                if (obligatedEndDate == null) {
                    if ("1".equals(this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST"))) {
                        this.reportError(obligationExirationField, "error.obligation.expiration.date", new String[0]);
                    } else {
                        this.reportError(obligationExirationField, "error.obligation.expiration.date", new String[0]);
                    }
                    this.addFieldToUserSessionMap(obligationExirationField);
                    valid = false;
                }
            }
            ++i;
        }
        return valid;
    }

    protected void addFieldToUserSessionMap(String fieldName) {
        if (KNSGlobalVariables.getKualiForm() instanceof TimeAndMoneyForm) {
            TimeAndMoneyForm form = (TimeAndMoneyForm)KNSGlobalVariables.getKualiForm();
            System.err.println("addFieldToUserSessionMap: fieldName: '" + fieldName + "'");
            form.getFieldsInError().add(fieldName);
        }
    }

    protected void clearFieldsFromUserSessionMap() {
        if (KNSGlobalVariables.getKualiForm() instanceof TimeAndMoneyForm) {
            TimeAndMoneyForm form = (TimeAndMoneyForm)KNSGlobalVariables.getKualiForm();
            System.err.println("clearFieldsFromUserSessionMap");
            form.getFieldsInError().clear();
        }
    }

    private AwardAmountInfoService getAwardAmountInfoService() {
        return (AwardAmountInfoService)KraServiceLocator.getService(AwardAmountInfoService.class);
    }

    public AwardVersionService getAwardVersionService() {
        return (AwardVersionService)KraServiceLocator.getService(AwardVersionService.class);
    }

    public boolean enforceAwardStartDatePopulated(Award award) {
        boolean valid = true;
        if (award.getAwardEffectiveDate() == null) {
            this.reportError(AWARD_EFFECTIVE_DATE_PROPERTY, "error.award.effective.date.timeAndMoney", new String[0]);
            valid = false;
        }
        return valid;
    }
}

