/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.ResearchDocumentService;
import org.kuali.kra.timeandmoney.AwardAmountInfoHistory;
import org.kuali.kra.timeandmoney.AwardVersionHistory;
import org.kuali.kra.timeandmoney.TimeAndMoneyDocumentHistory;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.history.TransactionDetail;
import org.kuali.kra.timeandmoney.history.TransactionDetailType;
import org.kuali.kra.timeandmoney.history.TransactionType;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyHistoryService;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class TimeAndMoneyHistoryServiceImpl
implements TimeAndMoneyHistoryService {
    private static final int NUMBER_30 = 30;
    BusinessObjectService businessObjectService;
    DocumentService documentService;
    AwardVersionService awardVersionService;
    private String DASH = "-";
    private static final String DEFAULT_TAB = "Versions";
    private static final String ALTERNATE_OPEN_TAB = "Parameters";

    public void getTimeAndMoneyHistory(String awardNumber, Map<Object, Object> timeAndMoneyHistory, List<Integer> columnSpan) throws WorkflowException {
        HashMap<String, String> fieldValues1 = new HashMap<String, String>();
        HashMap<String, Object> fieldValues3 = new HashMap<String, Object>();
        HashMap<String, Object> fieldValues3a = new HashMap<String, Object>();
        HashMap<String, Object> fieldValues5 = new HashMap<String, Object>();
        HashMap<String, String> fieldValues4 = new HashMap<String, String>();
        AwardAmountTransaction awardAmountTransaction = null;
        timeAndMoneyHistory.clear();
        Award award = this.awardVersionService.getWorkingAwardVersion(awardNumber);
        List docs = null;
        int key = 150;
        int j = -1;
        award.refreshReferenceObject("awardDocument");
        fieldValues1.put("rootAwardNumber", this.getRootAwardNumberForDocumentSearch(award.getAwardNumber()));
        docs = (List)this.businessObjectService.findMatching(TimeAndMoneyDocument.class, fieldValues1);
        Collections.sort(docs);
        timeAndMoneyHistory.put(this.buildForwardUrl(award.getAwardDocument().getDocumentNumber()), this.buildAwardDescriptionLine(award, null, (TimeAndMoneyDocument)docs.get(docs.size() - 1)));
        block0: for (TimeAndMoneyDocument tempDoc : docs) {
            TimeAndMoneyDocument doc = (TimeAndMoneyDocument)this.documentService.getByDocumentHeaderId(tempDoc.getDocumentNumber());
            List awardAmountTransactions = doc.getAwardAmountTransactions();
            if (doc.getDocumentHeader().hasWorkflowDocument() && !doc.getDocumentHeader().getWorkflowDocument().isCanceled()) {
                for (AwardAmountInfo awardAmountInfo : award.getAwardAmountInfos()) {
                    if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null || !awardAmountInfo.getTimeAndMoneyDocumentNumber().equals(doc.getDocumentNumber()) || !StringUtils.equalsIgnoreCase((String)doc.getDocumentNumber(), (String)awardAmountInfo.getTimeAndMoneyDocumentNumber())) continue;
                    if (awardAmountTransactions.size() > 0) {
                        awardAmountTransaction = (AwardAmountTransaction)awardAmountTransactions.get(0);
                        timeAndMoneyHistory.put(this.buildForwardUrl(doc.getDocumentNumber()), this.buildAwardDescriptionLine(award, awardAmountInfo, (TimeAndMoneyDocument)docs.get(docs.size() - 1)) + " comments: " + awardAmountTransaction.getComments());
                    }
                    fieldValues5.put("destinationAwardNumber", awardAmountInfo.getAwardNumber());
                    fieldValues5.put("transactionId", 0);
                    fieldValues5.put("timeAndMoneyDocumentNumber", awardAmountInfo.getTimeAndMoneyDocumentNumber());
                    fieldValues5.put("transactionDetailType", TransactionDetailType.PRIMARY.toString());
                    List transactionDetailsA = (List)this.businessObjectService.findMatchingOrderBy(TransactionDetail.class, fieldValues5, "sourceAwardNumber", true);
                    if (transactionDetailsA.size() <= 0) break;
                    TransactionDetail transactionDetail = (TransactionDetail)transactionDetailsA.get(0);
                    timeAndMoneyHistory.put(0, awardAmountInfo);
                    timeAndMoneyHistory.put(key, transactionDetail);
                    ++key;
                    break;
                }
                for (AwardAmountInfo awardAmountInfo : award.getAwardAmountInfos()) {
                    if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null || !awardAmountInfo.getTimeAndMoneyDocumentNumber().equals(doc.getDocumentNumber()) || !StringUtils.equalsIgnoreCase((String)doc.getDocumentNumber(), (String)awardAmountInfo.getTimeAndMoneyDocumentNumber())) continue;
                    if (awardAmountTransactions.size() > 0) {
                        awardAmountTransaction = (AwardAmountTransaction)awardAmountTransactions.get(0);
                        timeAndMoneyHistory.put(this.buildForwardUrl(doc.getDocumentNumber()), this.buildAwardDescriptionLine(award, awardAmountInfo, (TimeAndMoneyDocument)docs.get(docs.size() - 1)) + " comments: " + awardAmountTransaction.getComments());
                    }
                    ArrayList transactionDetails = new ArrayList();
                    fieldValues3.put("sourceAwardNumber", awardAmountInfo.getAwardNumber());
                    fieldValues3.put("transactionId", awardAmountInfo.getTransactionId());
                    fieldValues3.put("timeAndMoneyDocumentNumber", awardAmountInfo.getTimeAndMoneyDocumentNumber());
                    fieldValues5.put("transactionDetailType", TransactionDetailType.PRIMARY.toString());
                    fieldValues3a.put("destinationAwardNumber", awardAmountInfo.getAwardNumber());
                    fieldValues3a.put("transactionId", awardAmountInfo.getTransactionId());
                    fieldValues3a.put("timeAndMoneyDocumentNumber", awardAmountInfo.getTimeAndMoneyDocumentNumber());
                    fieldValues5.put("transactionDetailType", TransactionDetailType.PRIMARY.toString());
                    List transactionDetailsA = (List)this.businessObjectService.findMatchingOrderBy(TransactionDetail.class, fieldValues3, "sourceAwardNumber", true);
                    List transactionDetailsB = (List)this.businessObjectService.findMatchingOrderBy(TransactionDetail.class, fieldValues3a, "sourceAwardNumber", true);
                    transactionDetails.addAll(transactionDetailsA);
                    transactionDetails.addAll(transactionDetailsB);
                    int i = 0;
                    for (TransactionDetail transactionDetail : transactionDetails) {
                        timeAndMoneyHistory.put(awardAmountInfo.getTransactionId(), awardAmountInfo);
                        timeAndMoneyHistory.put(key, transactionDetail);
                        ++key;
                        ++i;
                    }
                    columnSpan.add(i);
                }
            }
            for (AwardAmountInfo awardAmountInfo : award.getAwardAmountInfos()) {
                if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null || !awardAmountInfo.getTimeAndMoneyDocumentNumber().equals(doc.getDocumentNumber()) || !StringUtils.equalsIgnoreCase((String)doc.getDocumentNumber(), (String)awardAmountInfo.getTimeAndMoneyDocumentNumber()) || awardAmountInfo.getTransactionId() != null) continue;
                if (awardAmountTransactions.size() > 0) {
                    awardAmountTransaction = (AwardAmountTransaction)awardAmountTransactions.get(0);
                    timeAndMoneyHistory.put(this.buildForwardUrl(doc.getDocumentNumber()), this.buildAwardDescriptionLine(award, awardAmountInfo, (TimeAndMoneyDocument)docs.get(docs.size() - 1)) + " comments: " + awardAmountTransaction.getComments());
                }
                fieldValues4.put("sourceAwardNumber", awardAmountInfo.getAwardNumber());
                fieldValues4.put("transactionId", "-1");
                fieldValues4.put("timeAndMoneyDocumentNumber", awardAmountInfo.getTimeAndMoneyDocumentNumber());
                fieldValues5.put("transactionDetailType", TransactionDetailType.PRIMARY.toString());
                List dateTransactionDetails = (List)this.businessObjectService.findMatchingOrderBy(TransactionDetail.class, fieldValues4, "sourceAwardNumber", true);
                int i = 0;
                for (TransactionDetail transactionDetail : dateTransactionDetails) {
                    timeAndMoneyHistory.put(j, awardAmountInfo);
                    timeAndMoneyHistory.put(key, transactionDetail);
                    ++key;
                    ++i;
                    --j;
                }
                columnSpan.add(i);
                continue block0;
            }
        }
    }

    public void buildTimeAndMoneyHistoryObjects(String awardNumber, List<AwardVersionHistory> awardVersionHistoryCollection) throws WorkflowException {
        List awardVersionList = (List)this.businessObjectService.findMatchingOrderBy(Award.class, this.getHashMapToFindActiveAward(awardNumber), "sequenceNumber", true);
        Collections.reverse(awardVersionList);
        List docs = null;
        HashMap<String, String> fieldValues1 = new HashMap<String, String>();
        fieldValues1.put("rootAwardNumber", this.getRootAwardNumberForDocumentSearch(((Award)awardVersionList.get(0)).getAwardNumber()));
        docs = (List)this.businessObjectService.findMatchingOrderBy(TimeAndMoneyDocument.class, fieldValues1, "documentNumber", true);
        this.removeCanceledDocs(docs);
        for (Award award : awardVersionList) {
            AwardVersionHistory awardVersionHistory = new AwardVersionHistory(award);
            awardVersionHistory.setDocumentUrl(this.buildForwardUrl(award.getAwardDocument().getDocumentNumber()));
            awardVersionHistory.setAwardDescriptionLine(this.buildNewAwardDescriptionLine(award));
            awardVersionHistory.setTimeAndMoneyDocumentHistoryList(this.getDocHistoryAndValidInfosAssociatedWithAwardVersion(docs, award.getAwardAmountInfos(), award));
            awardVersionHistoryCollection.add(awardVersionHistory);
        }
    }

    public List<TimeAndMoneyDocumentHistory> getDocHistoryAndValidInfosAssociatedWithAwardVersion(List<TimeAndMoneyDocument> docs, List<AwardAmountInfo> awardAmountInfos, Award award) throws WorkflowException {
        ArrayList<TimeAndMoneyDocumentHistory> timeAndMoneyDocumentHistoryList = new ArrayList<TimeAndMoneyDocumentHistory>();
        List validInfos = this.getValidAwardAmountInfosAssociatedWithAwardVersion(awardAmountInfos, award);
        List awardVersionDocs = this.getValidDocumentsCreatedForAwardVersion(docs, validInfos);
        Collections.reverse(awardVersionDocs);
        for (TimeAndMoneyDocument doc : awardVersionDocs) {
            TimeAndMoneyDocumentHistory docHistory = new TimeAndMoneyDocumentHistory();
            docHistory.setTimeAndMoneyDocument(doc);
            docHistory.setDocumentUrl(this.buildForwardUrl(doc.getDocumentNumber()));
            docHistory.setTimeAndMoneyDocumentDescriptionLine(this.buildNewTimeAndMoneyDescriptionLine(doc));
            docHistory.setValidAwardAmountInfoHistoryList(this.retrieveAwardAmountInfosFromPrimaryTransactions(doc, validInfos));
            timeAndMoneyDocumentHistoryList.add(docHistory);
        }
        return timeAndMoneyDocumentHistoryList;
    }

    protected List<AwardAmountInfoHistory> retrieveAwardAmountInfosFromPrimaryTransactions(TimeAndMoneyDocument doc, List<AwardAmountInfo> validInfos) {
        ArrayList<AwardAmountInfoHistory> primaryInfos = new ArrayList<AwardAmountInfoHistory>();
        primaryInfos.addAll(this.captureMoneyInfos(doc, validInfos));
        primaryInfos.addAll(this.captureDateInfos(doc, validInfos));
        primaryInfos.addAll(this.captureInitialTransactionInfo(doc, validInfos));
        return primaryInfos;
    }

    protected List<AwardAmountInfoHistory> captureMoneyInfos(TimeAndMoneyDocument doc, List<AwardAmountInfo> validInfos) {
        ArrayList<AwardAmountInfoHistory> moneyInfoHistoryList = new ArrayList<AwardAmountInfoHistory>();
        HashMap<String, Object> fieldValues1 = new HashMap<String, Object>();
        HashMap<String, Object> fieldValues1a = new HashMap<String, Object>();
        HashMap<String, Object> fieldValues2 = new HashMap<String, Object>();
        for (AwardAmountInfo awardAmountInfo : validInfos) {
            if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null || !StringUtils.equalsIgnoreCase((String)doc.getDocumentNumber(), (String)awardAmountInfo.getTimeAndMoneyDocumentNumber())) continue;
            fieldValues1.put("sourceAwardNumber", awardAmountInfo.getAwardNumber());
            fieldValues1.put("transactionId", awardAmountInfo.getTransactionId());
            fieldValues1.put("transactionDetailType", TransactionDetailType.PRIMARY.toString());
            fieldValues1a.put("destinationAwardNumber", awardAmountInfo.getAwardNumber());
            fieldValues1a.put("transactionId", awardAmountInfo.getTransactionId());
            fieldValues1a.put("transactionDetailType", TransactionDetailType.PRIMARY.toString());
            fieldValues2.put("transactionId", awardAmountInfo.getTransactionId());
            fieldValues2.put("transactionDetailType", TransactionDetailType.INTERMEDIATE.toString());
            List transactionDetails = (List)this.businessObjectService.findMatchingOrderBy(TransactionDetail.class, fieldValues1, "transactionDetailId", true);
            List transactionDetailsA = (List)this.businessObjectService.findMatchingOrderBy(TransactionDetail.class, fieldValues1a, "transactionDetailId", true);
            transactionDetails.addAll(transactionDetailsA);
            List transactionDetailsB = (List)this.businessObjectService.findMatchingOrderBy(TransactionDetail.class, fieldValues2, "transactionDetailId", true);
            if (transactionDetails.size() <= 0) continue;
            AwardAmountInfoHistory awardAmountInfoHistory = new AwardAmountInfoHistory();
            awardAmountInfoHistory.setAwardAmountInfo(awardAmountInfo);
            awardAmountInfoHistory.setTransactionType(TransactionType.MONEY.toString());
            awardAmountInfoHistory.setPrimaryDetail((TransactionDetail)transactionDetails.get(0));
            awardAmountInfoHistory.setIntermediateDetails(transactionDetailsB);
            moneyInfoHistoryList.add(awardAmountInfoHistory);
        }
        return moneyInfoHistoryList;
    }

    protected List<AwardAmountInfoHistory> captureDateInfos(TimeAndMoneyDocument doc, List<AwardAmountInfo> validInfos) {
        ArrayList<AwardAmountInfoHistory> dateInfoHistoryList = new ArrayList<AwardAmountInfoHistory>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        for (AwardAmountInfo awardAmountInfo : validInfos) {
            if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null || !StringUtils.equalsIgnoreCase((String)doc.getDocumentNumber(), (String)awardAmountInfo.getTimeAndMoneyDocumentNumber()) || awardAmountInfo.getTransactionId() != null) continue;
            fieldValues.put("sourceAwardNumber", awardAmountInfo.getAwardNumber());
            fieldValues.put("transactionId", "-1");
            fieldValues.put("timeAndMoneyDocumentNumber", awardAmountInfo.getTimeAndMoneyDocumentNumber());
            List dateTransactionDetails = (List)this.businessObjectService.findMatchingOrderBy(TransactionDetail.class, fieldValues, "sourceAwardNumber", true);
            if (dateTransactionDetails.size() <= 0) continue;
            AwardAmountInfoHistory awardAmountInfoHistory = new AwardAmountInfoHistory();
            awardAmountInfoHistory.setAwardAmountInfo(awardAmountInfo);
            awardAmountInfoHistory.setTransactionType(TransactionType.DATE.toString());
            dateInfoHistoryList.add(awardAmountInfoHistory);
        }
        return dateInfoHistoryList;
    }

    protected List<AwardAmountInfoHistory> captureInitialTransactionInfo(TimeAndMoneyDocument doc, List<AwardAmountInfo> validInfos) {
        ArrayList<AwardAmountInfoHistory> initialInfoHistoryList = new ArrayList<AwardAmountInfoHistory>();
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        for (AwardAmountInfo awardAmountInfo : validInfos) {
            if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null || !StringUtils.equalsIgnoreCase((String)doc.getDocumentNumber(), (String)awardAmountInfo.getTimeAndMoneyDocumentNumber())) continue;
            fieldValues.put("destinationAwardNumber", awardAmountInfo.getAwardNumber());
            fieldValues.put("transactionId", 0);
            fieldValues.put("timeAndMoneyDocumentNumber", awardAmountInfo.getTimeAndMoneyDocumentNumber());
            fieldValues.put("transactionDetailType", TransactionDetailType.PRIMARY.toString());
            List transactionDetailsA = (List)this.businessObjectService.findMatchingOrderBy(TransactionDetail.class, fieldValues, "sourceAwardNumber", true);
            if (transactionDetailsA.size() <= 0) break;
            AwardAmountInfoHistory awardAmountInfoHistory = new AwardAmountInfoHistory();
            awardAmountInfoHistory.setAwardAmountInfo(awardAmountInfo);
            awardAmountInfoHistory.setTransactionType(TransactionType.INITIAL.toString());
            initialInfoHistoryList.add(awardAmountInfoHistory);
            break;
        }
        return initialInfoHistoryList;
    }

    protected String buildNewTimeAndMoneyDescriptionLine(TimeAndMoneyDocument doc) {
        AwardAmountTransaction aat = (AwardAmountTransaction)doc.getAwardAmountTransactions().get(0);
        String noticeDate = aat.getNoticeDate() != null ? aat.getNoticeDate().toString() : "None";
        String transactionTypeDescription = aat.getAwardTransactionType() != null ? aat.getAwardTransactionType().getDescription() : "None";
        return "Time And Money Document: " + transactionTypeDescription + ", notice date: " + noticeDate + ", updated " + this.getUpdateTimeAndUser(doc) + ". Comments: " + (aat.getComments() == null ? "None" : aat.getComments());
    }

    protected List<AwardAmountInfo> getValidAwardAmountInfosAssociatedWithAwardVersion(List<AwardAmountInfo> awardAmountInfos, Award award) {
        ArrayList<AwardAmountInfo> validInfos = new ArrayList<AwardAmountInfo>();
        for (AwardAmountInfo awardAmountInfo : awardAmountInfos) {
            if (awardAmountInfo.getOriginatingAwardVersion() == null || !awardAmountInfo.getOriginatingAwardVersion().equals(award.getSequenceNumber())) continue;
            validInfos.add(awardAmountInfo);
        }
        return validInfos;
    }

    protected List<TimeAndMoneyDocument> getValidDocumentsCreatedForAwardVersion(List<TimeAndMoneyDocument> docs, List<AwardAmountInfo> validInfos) {
        ArrayList<TimeAndMoneyDocument> validDocs = new ArrayList<TimeAndMoneyDocument>();
        for (TimeAndMoneyDocument doc : docs) {
            if (!this.isInValidInfosCollection(doc, validInfos).booleanValue()) continue;
            validDocs.add(doc);
        }
        return validDocs;
    }

    protected Boolean isInValidInfosCollection(TimeAndMoneyDocument doc, List<AwardAmountInfo> validInfos) {
        Boolean valid = false;
        for (AwardAmountInfo awardAmountInfo : validInfos) {
            if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null || !awardAmountInfo.getTimeAndMoneyDocumentNumber().equals(doc.getDocumentNumber())) continue;
            valid = true;
            break;
        }
        return valid;
    }

    protected void removeCanceledDocs(List<TimeAndMoneyDocument> docs) {
        ArrayList<TimeAndMoneyDocument> tempCanceledDocs = new ArrayList<TimeAndMoneyDocument>();
        for (TimeAndMoneyDocument doc : docs) {
            if (!doc.getDocumentHeader().hasWorkflowDocument() || !doc.getDocumentHeader().getWorkflowDocument().isCanceled()) continue;
            tempCanceledDocs.add(doc);
        }
        docs.removeAll(tempCanceledDocs);
    }

    public List<TimeAndMoneyDocument> buildTimeAndMoneyListForAwardDisplay(Award award) throws WorkflowException {
        HashMap<String, String> fieldValues1 = new HashMap<String, String>();
        fieldValues1.put("rootAwardNumber", award.getAwardNumber());
        List docs = (List)this.businessObjectService.findMatchingOrderBy(TimeAndMoneyDocument.class, fieldValues1, "documentNumber", true);
        this.removeCanceledDocs(docs);
        return docs;
    }

    public AwardVersionService getAwardVersionService() {
        this.awardVersionService = (AwardVersionService)KraServiceLocator.getService(AwardVersionService.class);
        return this.awardVersionService;
    }

    protected Map<String, String> getHashMapToFindActiveAward(String goToAwardNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("awardNumber", goToAwardNumber);
        return map;
    }

    public void setAwardVersionService(AwardVersionService awardVersionService) {
        this.awardVersionService = awardVersionService;
    }

    public String getRootAwardNumberForDocumentSearch(String awardNumber) {
        String[] splitAwardNumber = awardNumber.split(this.DASH);
        StringBuilder returnString = new StringBuilder(12);
        returnString.append(splitAwardNumber[0]);
        returnString.append(this.DASH);
        returnString.append("00001");
        return returnString.toString();
    }

    protected String buildAwardDescriptionLine(Award award, AwardAmountInfo awardAmountInfo, TimeAndMoneyDocument timeAndMoneyDocument) {
        AwardAmountTransaction aat = (AwardAmountTransaction)timeAndMoneyDocument.getAwardAmountTransactions().get(0);
        String versionNumber = awardAmountInfo == null || awardAmountInfo.getOriginatingAwardVersion() == null ? award.getSequenceNumber().toString() : awardAmountInfo.getOriginatingAwardVersion().toString();
        String noticeDate = aat.getNoticeDate() != null ? aat.getNoticeDate().toString() : "None";
        String transactionTypeDescription = award.getAwardTransactionType() != null ? award.getAwardTransactionType().getDescription() : "None";
        return "Award Version " + versionNumber + ", " + transactionTypeDescription + ", notice date: " + noticeDate + ", updated " + this.getUpdateTimeAndUser(award);
    }

    protected String buildNewAwardDescriptionLine(Award award) {
        String versionNumber = award.getSequenceNumber().toString();
        String noticeDate = award.getNoticeDate() != null ? award.getNoticeDate().toString() : "None";
        String transactionTypeDescription = award.getAwardTransactionType() != null ? award.getAwardTransactionType().getDescription() : "None";
        return "Award Version " + versionNumber + ", " + transactionTypeDescription + ", notice date: " + noticeDate + ", updated " + this.getUpdateTimeAndUser(award) + ". Comments:" + (award.getAwardCurrentActionComments().getComments() == null ? "None." : award.getAwardCurrentActionComments().getComments());
    }

    protected String getUpdateTimeAndUser(Award award) {
        return award.getUpdateTimeAndUser();
    }

    protected String getUpdateTimeAndUser(TimeAndMoneyDocument doc) {
        String createDateStr = null;
        String updateUser = null;
        if (doc.getUpdateTimestamp() != null) {
            createDateStr = CoreApiServiceLocator.getDateTimeService().toString((Date)doc.getUpdateTimestamp(), "MM/dd/yy");
            updateUser = doc.getUpdateUser().length() > 30 ? doc.getUpdateUser().substring(0, 30) : doc.getUpdateUser();
        }
        return createDateStr + " by " + updateUser;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected String buildForwardUrl(String documentNumber) {
        ResearchDocumentService researchDocumentService = (ResearchDocumentService)KraServiceLocator.getService(ResearchDocumentService.class);
        String forward = researchDocumentService.getDocHandlerUrl(documentNumber);
        forward = (forward = forward.replaceFirst(DEFAULT_TAB, ALTERNATE_OPEN_TAB)).indexOf("?") == -1 ? forward + "?" : forward + "&";
        forward = forward + "docId=" + documentNumber;
        forward = forward + "&command=displayDocSearchView";
        if (GlobalVariables.getUserSession().isBackdoorInUse()) {
            forward = forward + "&backdoorId=" + GlobalVariables.getUserSession().getPrincipalName();
        }
        String returnVal = "<a href=\"" + forward + "\"target=\"_blank\">" + documentNumber + "</a>";
        return returnVal;
    }
}

