/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.transactions;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.timeandmoney.TimeAndMoneyForm;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.transactions.AddTransactionRuleEvent;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;
import org.kuali.kra.timeandmoney.transactions.PendingTransaction;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;

public class TransactionBean
implements Serializable {
    private static final long serialVersionUID = -5513993757805685581L;
    private PendingTransaction newPendingTransaction;
    private AwardAmountTransaction newAwardAmountTransaction;
    private transient KualiRuleService ruleService;
    private TimeAndMoneyForm form;

    public TransactionBean(TimeAndMoneyForm form) {
        this.form = form;
        this.init();
    }

    public boolean addPendingTransactionItem() {
        this.sumDirectIndirectIfViewEnabled();
        AddTransactionRuleEvent event = this.generateAddEvent();
        this.updateDocumentFromSession(event.getTimeAndMoneyDocument());
        boolean success = this.getRuleService().applyRules((KualiDocumentEvent)event);
        if (success) {
            this.getTimeAndMoneyDocument().add(this.getNewPendingTransaction());
            this.init();
        }
        return success;
    }

    private void sumDirectIndirectIfViewEnabled() {
        if (StringUtils.equals((String)"1", (String)this.form.getDirectIndirectViewEnabled())) {
            this.newPendingTransaction.setAnticipatedAmount((KualiDecimal)this.newPendingTransaction.getAnticipatedDirectAmount().add((AbstractKualiDecimal)this.newPendingTransaction.getAnticipatedIndirectAmount()));
            this.newPendingTransaction.setObligatedAmount((KualiDecimal)this.newPendingTransaction.getObligatedDirectAmount().add((AbstractKualiDecimal)this.newPendingTransaction.getObligatedIndirectAmount()));
        }
    }

    private void updateDocumentFromSession(TimeAndMoneyDocument doc) {
        if (doc.getAwardHierarchyNodes() == null || doc.getAwardHierarchyNodes().size() == 0) {
            if (GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY") != null) {
                TimeAndMoneyDocument document = (TimeAndMoneyDocument)GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY");
                doc.setAwardHierarchyItems(document.getAwardHierarchyItems());
                doc.setAwardHierarchyNodes(document.getAwardHierarchyNodes());
            } else {
                throw new RuntimeException("Can't Retrieve Time And Money Document from Session");
            }
        }
    }

    public void deletePendingTransactionItem(int deletedItemIndex) {
        List items = this.getTimeAndMoneyDocument().getPendingTransactions();
        if (deletedItemIndex >= 0 && deletedItemIndex < items.size()) {
            items.remove(deletedItemIndex);
        }
    }

    public TimeAndMoneyDocument getTimeAndMoneyDocument() {
        return this.form.getTimeAndMoneyDocument();
    }

    public Object getData() {
        return this.getNewPendingTransaction();
    }

    public void init() {
        this.newPendingTransaction = new PendingTransaction();
    }

    protected KualiRuleService getRuleService() {
        if (this.ruleService == null) {
            this.ruleService = (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
        }
        return this.ruleService;
    }

    protected void setRuleService(KualiRuleService ruleService) {
        this.ruleService = ruleService;
    }

    AddTransactionRuleEvent generateAddEvent() {
        AddTransactionRuleEvent event = new AddTransactionRuleEvent("transactionBean.newPendingTransaction", this.getTimeAndMoneyDocument(), this.getNewPendingTransaction());
        return event;
    }

    public PendingTransaction getNewPendingTransaction() {
        return this.newPendingTransaction;
    }

    public void setNewPendingTransaction(PendingTransaction newPendingTransaction) {
        this.newPendingTransaction = newPendingTransaction;
    }

    public AwardAmountTransaction getNewAwardAmountTransaction() {
        return this.newAwardAmountTransaction;
    }

    public void setNewAwardAmountTransaction(AwardAmountTransaction newAwardAmountTransaction) {
        this.newAwardAmountTransaction = newAwardAmountTransaction;
    }
}

