/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.web.struts.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistribution;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.AwardDirectFandADistributionService;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.TimeAndMoneyForm;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.history.TransactionDetail;
import org.kuali.kra.timeandmoney.service.ActivePendingTransactionsService;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyActionSummaryService;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyHistoryService;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;
import org.kuali.kra.timeandmoney.transactions.PendingTransaction;
import org.kuali.kra.timeandmoney.transactions.TransactionRuleImpl;
import org.kuali.kra.web.struts.action.KraTransactionalDocumentActionBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.DocumentAuthorizer;
import org.kuali.rice.kns.document.authorization.DocumentPresentationController;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class TimeAndMoneyAction
extends KraTransactionalDocumentActionBase {
    private static final String OBLIGATED_START_COMMENT = "Obligated Start";
    private static final String OBLIGATED_END_COMMENT = "Obligated End";
    private static final String PROJECT_END_COMMENT = "Project End";
    private static final Integer TEN = 10;
    BusinessObjectService businessObjectService;
    AwardVersionService awardVersionService;
    private ParameterService parameterService;
    TransactionRuleImpl transactionRuleImpl;
    private ActivePendingTransactionsService activePendingTransactionsService;

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        this.captureDateChangeTransactions(form);
        this.captureSingleNodeMoneyTransactions(mapping, form, request, response);
        forward = super.save(mapping, form, request, response);
        return forward;
    }

    private void captureSingleNodeMoneyTransactions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        AwardAmountInfoService awardAmountInfoService = (AwardAmountInfoService)KraServiceLocator.getService(AwardAmountInfoService.class);
        ArrayList moneyTransactionDetailItems = new ArrayList();
        this.updateAwardAmountTransactions(timeAndMoneyDocument);
        if (timeAndMoneyDocument.getAwardHierarchyNodes().size() == 1) {
            for (Map.Entry awardHierarchyNode : timeAndMoneyDocument.getAwardHierarchyNodes().entrySet()) {
                Award award = this.getAwardVersionService().getWorkingAwardVersion(((AwardHierarchyNode)awardHierarchyNode.getValue()).getAwardNumber());
                AwardAmountInfo aai = awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
                boolean refreshNeeded = this.inspectAndCaptureAmountChanges(timeAndMoneyForm, aai, award, timeAndMoneyDocument, (AwardHierarchyNode)awardHierarchyNode.getValue(), moneyTransactionDetailItems);
                this.getBusinessObjectService().save((PersistableBusinessObject)award);
                this.getBusinessObjectService().save(moneyTransactionDetailItems);
                timeAndMoneyDocument.getAward().refreshReferenceObject("awardAmountInfos");
                if (!refreshNeeded) continue;
                this.refreshView(mapping, (ActionForm)timeAndMoneyForm, request, response);
            }
        }
    }

    private boolean inspectAndCaptureAmountChanges(TimeAndMoneyForm timeAndMoneyForm, AwardAmountInfo aai, Award award, TimeAndMoneyDocument timeAndMoneyDocument, AwardHierarchyNode awardHierarchyNode, List<TransactionDetail> moneyTransactionDetailItems) {
        if (this.isDirectIndirectViewEnabled()) {
            return this.createAndValidateEnabledViewTransaction(timeAndMoneyForm, aai, award, timeAndMoneyDocument, awardHierarchyNode, moneyTransactionDetailItems);
        }
        return this.createAndValidateDisabledViewTransaction(timeAndMoneyForm, aai, award, timeAndMoneyDocument, awardHierarchyNode, moneyTransactionDetailItems);
    }

    private boolean createAndValidateEnabledViewTransaction(TimeAndMoneyForm timeAndMoneyForm, AwardAmountInfo aai, Award award, TimeAndMoneyDocument timeAndMoneyDocument, AwardHierarchyNode ahn, List<TransactionDetail> moneyTransactionDetailItems) {
        boolean result = false;
        AwardHierarchyNode awardHierarchyNode = (AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(1);
        this.transactionRuleImpl = new TransactionRuleImpl();
        PendingTransaction pendingTransaction = new PendingTransaction();
        pendingTransaction.setComments("Single Node Money Transaction");
        KualiDecimal currentObligatedDirect = aai.getObligatedTotalDirect();
        KualiDecimal currentObligatedIndirect = aai.getObligatedTotalIndirect();
        KualiDecimal currentAnticipatedDirect = aai.getAnticipatedTotalDirect();
        KualiDecimal currentAnticipatedIndirect = aai.getAnticipatedTotalIndirect();
        for (PendingTransaction penTran : timeAndMoneyDocument.getPendingTransactions()) {
            if (StringUtils.equalsIgnoreCase((String)penTran.getSourceAwardNumber(), (String)"000000-00000")) {
                currentObligatedDirect = (KualiDecimal)currentObligatedDirect.add((AbstractKualiDecimal)penTran.getObligatedDirectAmount());
                currentObligatedIndirect = (KualiDecimal)currentObligatedIndirect.add((AbstractKualiDecimal)penTran.getObligatedIndirectAmount());
                currentAnticipatedDirect = (KualiDecimal)currentAnticipatedDirect.add((AbstractKualiDecimal)penTran.getAnticipatedDirectAmount());
                currentAnticipatedIndirect = (KualiDecimal)currentAnticipatedIndirect.add((AbstractKualiDecimal)penTran.getAnticipatedIndirectAmount());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)penTran.getDestinationAwardNumber(), (String)"000000-00000")) continue;
            currentObligatedDirect = (KualiDecimal)currentObligatedDirect.subtract((AbstractKualiDecimal)penTran.getObligatedDirectAmount());
            currentObligatedIndirect = (KualiDecimal)currentObligatedIndirect.subtract((AbstractKualiDecimal)penTran.getObligatedIndirectAmount());
            currentAnticipatedDirect = (KualiDecimal)currentAnticipatedDirect.subtract((AbstractKualiDecimal)penTran.getAnticipatedDirectAmount());
            currentAnticipatedIndirect = (KualiDecimal)currentAnticipatedIndirect.subtract((AbstractKualiDecimal)penTran.getAnticipatedIndirectAmount());
        }
        if (!(awardHierarchyNode.getObligatedTotalDirect().equals((Object)currentObligatedDirect) && awardHierarchyNode.getObligatedTotalIndirect().equals((Object)currentObligatedIndirect) && awardHierarchyNode.getAnticipatedTotalDirect().equals((Object)currentAnticipatedDirect) && awardHierarchyNode.getAnticipatedTotalIndirect().equals((Object)currentAnticipatedIndirect))) {
            KualiDecimal obligatedChangeDirect = (KualiDecimal)awardHierarchyNode.getObligatedTotalDirect().subtract((AbstractKualiDecimal)currentObligatedDirect);
            KualiDecimal obligatedChangeIndirect = (KualiDecimal)awardHierarchyNode.getObligatedTotalIndirect().subtract((AbstractKualiDecimal)currentObligatedIndirect);
            KualiDecimal anticipatedChangeDirect = (KualiDecimal)awardHierarchyNode.getAnticipatedTotalDirect().subtract((AbstractKualiDecimal)currentAnticipatedDirect);
            KualiDecimal anticipatedChangeIndirect = (KualiDecimal)awardHierarchyNode.getAnticipatedTotalIndirect().subtract((AbstractKualiDecimal)currentAnticipatedIndirect);
            if (this.transactionRuleImpl.processParameterEnabledRules(awardHierarchyNode, aai, timeAndMoneyDocument)) {
                ArrayList<Award> awardItems = new ArrayList<Award>();
                awardItems.add(award);
                if (obligatedChangeDirect.isGreaterThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                    pendingTransaction.setSourceAwardNumber("000000-00000");
                    pendingTransaction.setDestinationAwardNumber(award.getAwardNumber());
                } else if (obligatedChangeDirect.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                    pendingTransaction.setSourceAwardNumber(award.getAwardNumber());
                    pendingTransaction.setDestinationAwardNumber("000000-00000");
                }
                if (obligatedChangeIndirect.isGreaterThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                    pendingTransaction.setSourceAwardNumber("000000-00000");
                    pendingTransaction.setDestinationAwardNumber(award.getAwardNumber());
                } else if (obligatedChangeIndirect.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                    pendingTransaction.setSourceAwardNumber(award.getAwardNumber());
                    pendingTransaction.setDestinationAwardNumber("000000-00000");
                }
                if (anticipatedChangeDirect.isGreaterThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                    pendingTransaction.setSourceAwardNumber("000000-00000");
                    pendingTransaction.setDestinationAwardNumber(award.getAwardNumber());
                } else if (anticipatedChangeDirect.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                    pendingTransaction.setSourceAwardNumber(award.getAwardNumber());
                    pendingTransaction.setDestinationAwardNumber("000000-00000");
                }
                if (anticipatedChangeIndirect.isGreaterThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                    pendingTransaction.setSourceAwardNumber("000000-00000");
                    pendingTransaction.setDestinationAwardNumber(award.getAwardNumber());
                } else if (anticipatedChangeIndirect.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                    pendingTransaction.setSourceAwardNumber(award.getAwardNumber());
                    pendingTransaction.setDestinationAwardNumber("000000-00000");
                }
                pendingTransaction.setObligatedDirectAmount((KualiDecimal)obligatedChangeDirect.abs());
                pendingTransaction.setObligatedIndirectAmount((KualiDecimal)obligatedChangeIndirect.abs());
                pendingTransaction.setAnticipatedDirectAmount((KualiDecimal)anticipatedChangeDirect.abs());
                pendingTransaction.setAnticipatedIndirectAmount((KualiDecimal)anticipatedChangeIndirect.abs());
                pendingTransaction.setObligatedAmount((KualiDecimal)((KualiDecimal)obligatedChangeDirect.add((AbstractKualiDecimal)obligatedChangeIndirect)).abs());
                pendingTransaction.setAnticipatedAmount((KualiDecimal)((KualiDecimal)anticipatedChangeDirect.add((AbstractKualiDecimal)anticipatedChangeIndirect)).abs());
                pendingTransaction.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
                pendingTransaction.setProcessedFlag(Boolean.valueOf(false));
                pendingTransaction.setSingleNodeTransaction(true);
                pendingTransaction.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
                timeAndMoneyDocument.getPendingTransactions().add(pendingTransaction);
                for (PendingTransaction penTran : timeAndMoneyDocument.getPendingTransactions()) {
                    penTran.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
                }
                this.getBusinessObjectService().save(timeAndMoneyDocument.getPendingTransactions());
                timeAndMoneyForm.setToPendingView();
                result = true;
            } else {
                ahn.setAmountObligatedToDate((KualiDecimal)aai.getAmountObligatedToDate().add(obligatedChangeDirect.add((AbstractKualiDecimal)obligatedChangeIndirect)));
                ahn.setObligatedTotalDirect(awardHierarchyNode.getObligatedTotalDirect());
                ahn.setObligatedTotalIndirect(awardHierarchyNode.getObligatedTotalIndirect());
                ahn.setObliDistributableAmount(awardHierarchyNode.getObliDistributableAmount());
                ahn.setAnticipatedTotalAmount((KualiDecimal)aai.getAnticipatedTotalAmount().add(anticipatedChangeDirect.add((AbstractKualiDecimal)anticipatedChangeIndirect)));
                ahn.setAnticipatedTotalDirect(awardHierarchyNode.getAnticipatedTotalDirect());
                ahn.setAnticipatedTotalIndirect(awardHierarchyNode.getAnticipatedTotalIndirect());
                ahn.setAntDistributableAmount(awardHierarchyNode.getAntDistributableAmount());
            }
        }
        return result;
    }

    private boolean createAndValidateDisabledViewTransaction(TimeAndMoneyForm timeAndMoneyForm, AwardAmountInfo aai, Award award, TimeAndMoneyDocument timeAndMoneyDocument, AwardHierarchyNode ahn, List<TransactionDetail> moneyTransactionDetailItems) {
        boolean result = false;
        AwardHierarchyNode awardHierarchyNode = (AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(1);
        this.transactionRuleImpl = new TransactionRuleImpl();
        PendingTransaction pendingTransaction = new PendingTransaction();
        pendingTransaction.setComments("Single Node Money Transaction");
        pendingTransaction.setSingleNodeTransaction(true);
        KualiDecimal currentObligated = aai.getAmountObligatedToDate();
        KualiDecimal currentAnticipated = aai.getAnticipatedTotalAmount();
        for (PendingTransaction penTran : timeAndMoneyDocument.getPendingTransactions()) {
            if (StringUtils.equalsIgnoreCase((String)penTran.getSourceAwardNumber(), (String)"000000-00000")) {
                currentObligated = (KualiDecimal)currentObligated.add((AbstractKualiDecimal)penTran.getObligatedAmount());
                currentAnticipated = (KualiDecimal)currentAnticipated.add((AbstractKualiDecimal)penTran.getAnticipatedAmount());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)penTran.getDestinationAwardNumber(), (String)"000000-00000")) continue;
            currentObligated = (KualiDecimal)currentObligated.subtract((AbstractKualiDecimal)penTran.getObligatedAmount());
            currentAnticipated = (KualiDecimal)currentAnticipated.subtract((AbstractKualiDecimal)penTran.getAnticipatedAmount());
        }
        if (!awardHierarchyNode.getAmountObligatedToDate().equals((Object)currentObligated) || !awardHierarchyNode.getAnticipatedTotalAmount().equals((Object)currentAnticipated)) {
            KualiDecimal obligatedChange = (KualiDecimal)awardHierarchyNode.getAmountObligatedToDate().subtract((AbstractKualiDecimal)currentObligated);
            KualiDecimal anticipatedChange = (KualiDecimal)awardHierarchyNode.getAnticipatedTotalAmount().subtract((AbstractKualiDecimal)currentAnticipated);
            if (this.transactionRuleImpl.processParameterDisabledRules(awardHierarchyNode, aai, timeAndMoneyDocument)) {
                ArrayList<Award> awardItems = new ArrayList<Award>();
                awardItems.add(award);
                if (obligatedChange.isGreaterThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                    pendingTransaction.setSourceAwardNumber("000000-00000");
                    pendingTransaction.setDestinationAwardNumber(award.getAwardNumber());
                } else if (obligatedChange.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                    pendingTransaction.setSourceAwardNumber(award.getAwardNumber());
                    pendingTransaction.setDestinationAwardNumber("000000-00000");
                }
                if (anticipatedChange.isGreaterThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                    pendingTransaction.setSourceAwardNumber("000000-00000");
                    pendingTransaction.setDestinationAwardNumber(award.getAwardNumber());
                } else if (anticipatedChange.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                    pendingTransaction.setSourceAwardNumber(award.getAwardNumber());
                    pendingTransaction.setDestinationAwardNumber("000000-00000");
                }
                pendingTransaction.setObligatedAmount((KualiDecimal)obligatedChange.abs());
                pendingTransaction.setAnticipatedAmount((KualiDecimal)anticipatedChange.abs());
                pendingTransaction.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
                pendingTransaction.setProcessedFlag(Boolean.valueOf(false));
                timeAndMoneyDocument.getPendingTransactions().add(pendingTransaction);
                for (PendingTransaction penTran : timeAndMoneyDocument.getPendingTransactions()) {
                    penTran.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
                }
                this.getBusinessObjectService().save(timeAndMoneyDocument.getPendingTransactions());
                timeAndMoneyForm.setToPendingView();
                result = true;
            } else {
                ahn.setAmountObligatedToDate(awardHierarchyNode.getAmountObligatedToDate());
                ahn.setObliDistributableAmount(awardHierarchyNode.getObliDistributableAmount());
                ahn.setAnticipatedTotalAmount(awardHierarchyNode.getAnticipatedTotalAmount());
                ahn.setAntDistributableAmount(awardHierarchyNode.getAntDistributableAmount());
            }
        }
        return result;
    }

    private void captureDateChangeTransactions(ActionForm form) throws WorkflowException {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        AwardAmountInfoService awardAmountInfoService = (AwardAmountInfoService)KraServiceLocator.getService(AwardAmountInfoService.class);
        ArrayList awardAmountInfoObjects = new ArrayList();
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        boolean isNoCostExtension = ((AwardAmountTransaction)timeAndMoneyDocument.getAwardAmountTransactions().get(0)).getTransactionTypeCode() == null ? false : ((AwardAmountTransaction)timeAndMoneyDocument.getAwardAmountTransactions().get(0)).getTransactionTypeCode().equals(TEN);
        ArrayList dateChangeTransactionDetailItems = new ArrayList();
        this.updateDocumentFromSession(timeAndMoneyDocument);
        this.updateAwardAmountTransactions(timeAndMoneyDocument);
        for (Map.Entry awardHierarchyNode : timeAndMoneyDocument.getAwardHierarchyNodes().entrySet()) {
            AwardDocument awardDocument;
            Award award = this.getAwardVersionService().getWorkingAwardVersion(((AwardHierarchyNode)awardHierarchyNode.getValue()).getAwardNumber());
            int index = this.findAwardHierarchyNodeIndex(awardHierarchyNode);
            AwardAmountInfo aai = awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
            boolean needToSaveAward = false;
            needToSaveAward |= this.inspectAndCaptureCurrentFundEffectiveDateChanges(timeAndMoneyForm, Boolean.valueOf(isNoCostExtension), aai, Integer.valueOf(index), award, timeAndMoneyDocument, awardHierarchyNode, dateChangeTransactionDetailItems);
            aai = awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
            needToSaveAward |= this.inspectAndCaptureObligationExpirationDateChanges(timeAndMoneyForm, Boolean.valueOf(isNoCostExtension), aai, Integer.valueOf(index), award, timeAndMoneyDocument, awardHierarchyNode, dateChangeTransactionDetailItems);
            aai = awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
            needToSaveAward |= this.inspectAndCaptureFinalExpirationDateChanges(timeAndMoneyForm, Boolean.valueOf(isNoCostExtension), aai, Integer.valueOf(index), award, timeAndMoneyDocument, awardHierarchyNode, dateChangeTransactionDetailItems);
            if (award.getAwardNumber().equals(timeAndMoneyDocument.getAward().getAwardNumber()) && this.mustSetFandADistributions((awardDocument = (AwardDocument)documentService.getByDocumentHeaderId(award.getAwardDocument().getDocumentNumber())).getAward().getAwardDirectFandADistributions(), timeAndMoneyDocument.getAward().getAwardDirectFandADistributions())) {
                awardDocument.getAward().setAwardDirectFandADistributions(timeAndMoneyDocument.getAward().getAwardDirectFandADistributions());
                documentService.saveDocument((Document)awardDocument);
                needToSaveAward = true;
            }
            if (!needToSaveAward) continue;
            this.getBusinessObjectService().save((PersistableBusinessObject)award);
        }
        this.getBusinessObjectService().save(awardAmountInfoObjects);
        this.getBusinessObjectService().save(timeAndMoneyDocument.getAwardAmountTransactions());
        this.getBusinessObjectService().save(dateChangeTransactionDetailItems);
        timeAndMoneyDocument.getAward().refreshReferenceObject("awardAmountInfos");
    }

    protected boolean inspectAndCaptureCurrentFundEffectiveDateChanges(TimeAndMoneyForm timeAndMoneyForm, Boolean isNoCostExtension, AwardAmountInfo aai, Integer index, Award award, TimeAndMoneyDocument timeAndMoneyDocument, Map.Entry<String, AwardHierarchyNode> awardHierarchyNode, List<TransactionDetail> dateChangeTransactionDetailItems) {
        boolean needToSave = false;
        if (((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).isPopulatedFromClient() && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate() != null && !((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate().equals(aai.getCurrentFundEffectiveDate())) {
            if (isNoCostExtension.booleanValue() && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate().before(aai.getCurrentFundEffectiveDate())) {
                AwardAmountInfo tempAai = this.getNewAwardAmountInfoForDateChangeTransaction(aai, award, timeAndMoneyDocument.getDocumentNumber());
                needToSave = true;
                aai = tempAai;
                aai.setCurrentFundEffectiveDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate());
                awardHierarchyNode.getValue().setCurrentFundEffectiveDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate());
                award.getAwardAmountInfos().add(aai);
                this.addTransactionDetails(aai.getAwardNumber(), aai.getAwardNumber(), aai.getSequenceNumber(), timeAndMoneyDocument.getAwardNumber(), timeAndMoneyDocument.getDocumentNumber(), OBLIGATED_START_COMMENT, dateChangeTransactionDetailItems);
            } else {
                AwardAmountInfo tempAai = this.getNewAwardAmountInfoForDateChangeTransaction(aai, award, timeAndMoneyDocument.getDocumentNumber());
                needToSave = true;
                aai = tempAai;
                aai.setCurrentFundEffectiveDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate());
                awardHierarchyNode.getValue().setCurrentFundEffectiveDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate());
                award.getAwardAmountInfos().add(aai);
            }
        } else if (((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).isPopulatedFromClient() && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate() == null) {
            awardHierarchyNode.getValue().setCurrentFundEffectiveDate(null);
        }
        if (((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate() != null && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate() != null && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate().equals(aai.getCurrentFundEffectiveDate()) && !((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate().equals(awardHierarchyNode.getValue().getCurrentFundEffectiveDate())) {
            awardHierarchyNode.getValue().setCurrentFundEffectiveDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate());
        }
        return needToSave;
    }

    protected boolean inspectAndCaptureObligationExpirationDateChanges(TimeAndMoneyForm timeAndMoneyForm, Boolean isNoCostExtension, AwardAmountInfo aai, Integer index, Award award, TimeAndMoneyDocument timeAndMoneyDocument, Map.Entry<String, AwardHierarchyNode> awardHierarchyNode, List<TransactionDetail> dateChangeTransactionDetailItems) {
        boolean needToSave = false;
        if (((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).isPopulatedFromClient() && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getObligationExpirationDate() != null && !((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getObligationExpirationDate().equals(aai.getObligationExpirationDate())) {
            if (isNoCostExtension.booleanValue() && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getObligationExpirationDate().after(aai.getObligationExpirationDate())) {
                AwardAmountInfo tempAai;
                aai = tempAai = this.getNewAwardAmountInfoForDateChangeTransaction(aai, award, timeAndMoneyDocument.getDocumentNumber());
                aai.setObligationExpirationDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getObligationExpirationDate());
                awardHierarchyNode.getValue().setObligationExpirationDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getObligationExpirationDate());
                award.getAwardAmountInfos().add(aai);
                this.addTransactionDetails(aai.getAwardNumber(), aai.getAwardNumber(), aai.getSequenceNumber(), timeAndMoneyDocument.getAwardNumber(), timeAndMoneyDocument.getDocumentNumber(), OBLIGATED_END_COMMENT, dateChangeTransactionDetailItems);
            } else {
                AwardAmountInfo tempAai;
                aai = tempAai = this.getNewAwardAmountInfoForDateChangeTransaction(aai, award, timeAndMoneyDocument.getDocumentNumber());
                aai.setObligationExpirationDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getObligationExpirationDate());
                awardHierarchyNode.getValue().setObligationExpirationDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getObligationExpirationDate());
                award.getAwardAmountInfos().add(aai);
            }
            needToSave = true;
        } else if (((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).isPopulatedFromClient() && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getObligationExpirationDate() == null) {
            awardHierarchyNode.getValue().setObligationExpirationDate(null);
        }
        if (((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate() != null && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getObligationExpirationDate() != null && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getObligationExpirationDate().equals(aai.getObligationExpirationDate()) && !((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getObligationExpirationDate().equals(awardHierarchyNode.getValue().getObligationExpirationDate())) {
            awardHierarchyNode.getValue().setObligationExpirationDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getObligationExpirationDate());
        }
        return needToSave;
    }

    protected boolean inspectAndCaptureFinalExpirationDateChanges(TimeAndMoneyForm timeAndMoneyForm, Boolean isNoCostExtension, AwardAmountInfo aai, Integer index, Award award, TimeAndMoneyDocument timeAndMoneyDocument, Map.Entry<String, AwardHierarchyNode> awardHierarchyNode, List<TransactionDetail> dateChangeTransactionDetailItems) {
        boolean needToSave = false;
        if (((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).isPopulatedFromClient() && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getFinalExpirationDate() != null && !((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getFinalExpirationDate().equals(aai.getFinalExpirationDate())) {
            if (isNoCostExtension.booleanValue() && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getFinalExpirationDate().after(aai.getFinalExpirationDate())) {
                AwardAmountInfo tempAai;
                aai = tempAai = this.getNewAwardAmountInfoForDateChangeTransaction(aai, award, timeAndMoneyDocument.getDocumentNumber());
                aai.setFinalExpirationDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getFinalExpirationDate());
                awardHierarchyNode.getValue().setFinalExpirationDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getFinalExpirationDate());
                award.getAwardAmountInfos().add(aai);
                this.addTransactionDetails(aai.getAwardNumber(), aai.getAwardNumber(), aai.getSequenceNumber(), timeAndMoneyDocument.getAwardNumber(), timeAndMoneyDocument.getDocumentNumber(), PROJECT_END_COMMENT, dateChangeTransactionDetailItems);
            } else {
                AwardAmountInfo tempAai;
                aai = tempAai = this.getNewAwardAmountInfoForDateChangeTransaction(aai, award, timeAndMoneyDocument.getDocumentNumber());
                aai.setFinalExpirationDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getFinalExpirationDate());
                awardHierarchyNode.getValue().setFinalExpirationDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getFinalExpirationDate());
                award.getAwardAmountInfos().add(aai);
            }
            needToSave = true;
        } else if (((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).isPopulatedFromClient() && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getFinalExpirationDate() == null) {
            awardHierarchyNode.getValue().setFinalExpirationDate(null);
        }
        if (((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getCurrentFundEffectiveDate() != null && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getFinalExpirationDate() != null && ((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getFinalExpirationDate().equals(aai.getFinalExpirationDate()) && !((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getFinalExpirationDate().equals(awardHierarchyNode.getValue().getFinalExpirationDate())) {
            awardHierarchyNode.getValue().setFinalExpirationDate(((AwardHierarchyNode)timeAndMoneyForm.getAwardHierarchyNodeItems().get(index)).getFinalExpirationDate());
        }
        return needToSave;
    }

    private boolean mustSetFandADistributions(List<AwardDirectFandADistribution> awardFandADistributions, List<AwardDirectFandADistribution> tAndMFandADistributions) {
        boolean needToSave = false;
        for (AwardDirectFandADistribution awardDistribution : awardFandADistributions) {
            boolean found = false;
            for (AwardDirectFandADistribution tAndMDistribution : tAndMFandADistributions) {
                if (!awardDistribution.equals((Object)tAndMDistribution)) continue;
                found = true;
            }
            if (found) continue;
            needToSave = true;
        }
        return needToSave;
    }

    protected void addTransactionDetails(String sourceAwardNumber, String destinationAwardNumber, Integer sequenceNumber, String currentAwardNumber, String documentNumber, String commentsString, List<TransactionDetail> transactionDetailItems) {
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setSourceAwardNumber(sourceAwardNumber);
        transactionDetail.setSequenceNumber(sequenceNumber);
        transactionDetail.setDestinationAwardNumber(destinationAwardNumber);
        transactionDetail.setAwardNumber(currentAwardNumber);
        transactionDetail.setTransactionId(new Long(-1L));
        transactionDetail.setTimeAndMoneyDocumentNumber(documentNumber);
        transactionDetail.setComments(commentsString);
        transactionDetailItems.add(transactionDetail);
    }

    private AwardAmountInfo getNewAwardAmountInfoForDateChangeTransaction(AwardAmountInfo awardAmountInfo, Award award, String documentNumber) {
        AwardAmountInfo newAwardAmountInfo = new AwardAmountInfo();
        newAwardAmountInfo.setAwardNumber(awardAmountInfo.getAwardNumber());
        newAwardAmountInfo.setSequenceNumber(award.getSequenceNumber());
        newAwardAmountInfo.setFinalExpirationDate(awardAmountInfo.getFinalExpirationDate());
        newAwardAmountInfo.setCurrentFundEffectiveDate(awardAmountInfo.getCurrentFundEffectiveDate());
        newAwardAmountInfo.setObligationExpirationDate(awardAmountInfo.getObligationExpirationDate());
        newAwardAmountInfo.setTimeAndMoneyDocumentNumber(documentNumber);
        newAwardAmountInfo.setTransactionId(null);
        newAwardAmountInfo.setAward(award);
        newAwardAmountInfo.setObliDistributableAmount(awardAmountInfo.getObliDistributableAmount());
        newAwardAmountInfo.setAmountObligatedToDate(awardAmountInfo.getAmountObligatedToDate());
        newAwardAmountInfo.setObligatedTotalDirect(awardAmountInfo.getObligatedTotalDirect());
        newAwardAmountInfo.setObligatedTotalIndirect(awardAmountInfo.getObligatedTotalIndirect());
        newAwardAmountInfo.setAntDistributableAmount(awardAmountInfo.getAntDistributableAmount());
        newAwardAmountInfo.setAnticipatedTotalAmount(awardAmountInfo.getAnticipatedTotalAmount());
        newAwardAmountInfo.setAnticipatedTotalDirect(awardAmountInfo.getAnticipatedTotalDirect());
        newAwardAmountInfo.setAnticipatedTotalIndirect(awardAmountInfo.getAnticipatedTotalIndirect());
        newAwardAmountInfo.setObligatedChangeDirect(new KualiDecimal(0));
        newAwardAmountInfo.setObligatedChangeIndirect(new KualiDecimal(0));
        newAwardAmountInfo.setAnticipatedChangeDirect(new KualiDecimal(0));
        newAwardAmountInfo.setAnticipatedChangeIndirect(new KualiDecimal(0));
        newAwardAmountInfo.setOriginatingAwardVersion(award.getSequenceNumber());
        return newAwardAmountInfo;
    }

    private void addAwardAmountTransaction(String awardNumber, Map<String, AwardAmountTransaction> awardAmountTransactionItems, AwardAmountTransaction newAwardAmountTransaction, String documentNumber) {
        if (!awardAmountTransactionItems.containsKey(awardNumber)) {
            AwardAmountTransaction newAwardAmountTransaction1 = new AwardAmountTransaction();
            newAwardAmountTransaction1.setAwardNumber(awardNumber);
            newAwardAmountTransaction1.setDocumentNumber(documentNumber);
            newAwardAmountTransaction1.setTransactionTypeCode(newAwardAmountTransaction.getTransactionTypeCode());
            newAwardAmountTransaction1.setComments(newAwardAmountTransaction.getComments());
            newAwardAmountTransaction1.setNoticeDate(newAwardAmountTransaction.getNoticeDate());
            awardAmountTransactionItems.put(awardNumber, newAwardAmountTransaction1);
        }
    }

    private void updateAwardAmountTransactions(TimeAndMoneyDocument timeAndMoneyDocument) {
        AwardAmountTransaction aat = timeAndMoneyDocument.getNewAwardAmountTransaction();
        if (aat != null) {
            if (timeAndMoneyDocument.getAwardAmountTransactions().size() == 0 || timeAndMoneyDocument.getAwardAmountTransactions().size() == 1 && ((AwardAmountTransaction)timeAndMoneyDocument.getAwardAmountTransactions().get(0)).getTransactionTypeCode() == null) {
                aat.setAwardNumber(timeAndMoneyDocument.getAwardNumber());
                aat.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
                timeAndMoneyDocument.getAwardAmountTransactions().set(0, aat);
            } else {
                AwardAmountTransaction firstAatInList = (AwardAmountTransaction)timeAndMoneyDocument.getAwardAmountTransactions().get(0);
                for (AwardAmountTransaction awardAmountTransaction : timeAndMoneyDocument.getAwardAmountTransactions()) {
                    awardAmountTransaction.setTransactionTypeCode(firstAatInList.getTransactionTypeCode());
                    awardAmountTransaction.setNoticeDate(firstAatInList.getNoticeDate());
                    awardAmountTransaction.setComments(firstAatInList.getComments());
                }
            }
        }
    }

    private int findAwardHierarchyNodeIndex(Map.Entry<String, AwardHierarchyNode> awardHierarchyNode) {
        String i = awardHierarchyNode.getValue().getAwardNumber().replaceAll("\\d*\\-0*", "");
        int index = Integer.parseInt(i);
        return index;
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.save(mapping, form, request, response);
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        ActionForward actionForward = super.route(mapping, form, request, response);
        String routeHeaderId = timeAndMoneyForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "timeAndMoney", "TimeAndMoneyDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, actionForward, holdingPageForward, returnLocation);
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.save(mapping, form, request, response);
        ActionForward actionForward = super.blanketApprove(mapping, form, request, response);
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        String routeHeaderId = timeAndMoneyForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "timeAndMoney", "TimeAndMoneyDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, actionForward, holdingPageForward, returnLocation);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        Map awardHierarchyItems = timeAndMoneyDocument.getAwardHierarchyItems();
        for (Map.Entry awardHierarchyEntry : awardHierarchyItems.entrySet()) {
            AwardHierarchy awardHierarchy = (AwardHierarchy)awardHierarchyEntry.getValue();
            Award award = this.getAwardVersionService().getWorkingAwardVersion(awardHierarchy.getAwardNumber());
            ArrayList<AwardAmountInfo> deleteCollection = new ArrayList<AwardAmountInfo>();
            for (AwardAmountInfo awardAmountInfo : award.getAwardAmountInfos()) {
                if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null || !awardAmountInfo.getTimeAndMoneyDocumentNumber().equals(timeAndMoneyDocument.getDocumentNumber())) continue;
                deleteCollection.add(awardAmountInfo);
            }
            this.getBusinessObjectService().delete(deleteCollection);
            deleteCollection.clear();
        }
        ActionForward actionForward = super.cancel(mapping, form, request, response);
        return actionForward;
    }

    public ActionForward refreshView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument doc = timeAndMoneyForm.getTimeAndMoneyDocument();
        if (StringUtils.equalsIgnoreCase((String)timeAndMoneyForm.getCurrentOrPendingView(), (String)"1")) {
            HashMap awardAmountTransactionItems = new HashMap();
            ArrayList awardItems = new ArrayList();
            ArrayList transactionDetailItems = new ArrayList();
            this.updateDocumentFromSession(doc);
            this.getActivePendingTransactionsService().processTransactions(doc, (AwardAmountTransaction)doc.getAwardAmountTransactions().get(0), awardAmountTransactionItems, awardItems, transactionDetailItems, Boolean.valueOf(true));
            GlobalVariables.getUserSession().addObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY", (Object)doc);
        } else if (StringUtils.equalsIgnoreCase((String)timeAndMoneyForm.getCurrentOrPendingView(), (String)"0")) {
            timeAndMoneyForm.setOrder(new ArrayList());
            Award tmpAward = this.getCurrentAward(doc);
            doc.setAwardHierarchyItems(this.getAwardHierarchyService().getAwardHierarchy(doc.getRootAwardNumber(), timeAndMoneyForm.getOrder()));
            if (tmpAward != null) {
                this.getAwardHierarchyService().populateAwardHierarchyNodesForTandMDoc(doc.getAwardHierarchyItems(), doc.getAwardHierarchyNodes(), tmpAward.getAwardNumber(), tmpAward.getSequenceNumber().toString(), timeAndMoneyForm.getTimeAndMoneyDocument());
            } else {
                this.getAwardHierarchyService().populateAwardHierarchyNodesForTandMDoc(doc.getAwardHierarchyItems(), doc.getAwardHierarchyNodes(), null, null, timeAndMoneyForm.getTimeAndMoneyDocument());
            }
            GlobalVariables.getUserSession().addObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY", (Object)doc);
        }
        return mapping.findForward("basic");
    }

    private void updateDocumentFromSession(TimeAndMoneyDocument doc) {
        if (doc.getAwardHierarchyNodes() == null || doc.getAwardHierarchyNodes().size() == 0) {
            if (GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY") != null) {
                TimeAndMoneyDocument document = (TimeAndMoneyDocument)GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY");
                doc.setAwardHierarchyItems(document.getAwardHierarchyItems());
                doc.setAwardHierarchyNodes(document.getAwardHierarchyNodes());
            } else {
                throw new RuntimeException("Can't Retrieve Time And Money Document from Session");
            }
        }
    }

    private Award getCurrentAward(TimeAndMoneyDocument timeAndMoneyDocument) {
        Award tmpAward = timeAndMoneyDocument.getAward();
        if (tmpAward == null) {
            tmpAward = this.getAwardVersionService().getWorkingAwardVersion(timeAndMoneyDocument.getAwardNumber());
        }
        return tmpAward;
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        String command = timeAndMoneyForm.getCommand();
        ActionForward forward = this.handleDocument(mapping, form, request, response, timeAndMoneyForm);
        timeAndMoneyForm.initializeFormOrDocumentBasedOnCommand();
        String rootAwardNumber = timeAndMoneyForm.getTimeAndMoneyDocument().getRootAwardNumber();
        timeAndMoneyDocument.setAwardHierarchyItems(this.getAwardHierarchyService().getAwardHierarchy(rootAwardNumber, timeAndMoneyForm.getOrder()));
        timeAndMoneyDocument.setAwardNumber(rootAwardNumber);
        Award tmpAward = this.getCurrentAward(timeAndMoneyDocument);
        if (tmpAward != null) {
            this.getAwardHierarchyService().populateAwardHierarchyNodesForTandMDoc(timeAndMoneyDocument.getAwardHierarchyItems(), timeAndMoneyDocument.getAwardHierarchyNodes(), tmpAward.getAwardNumber(), tmpAward.getSequenceNumber().toString(), timeAndMoneyForm.getTimeAndMoneyDocument());
        } else {
            this.getAwardHierarchyService().populateAwardHierarchyNodesForTandMDoc(timeAndMoneyDocument.getAwardHierarchyItems(), timeAndMoneyDocument.getAwardHierarchyNodes(), null, null, timeAndMoneyForm.getTimeAndMoneyDocument());
        }
        timeAndMoneyForm.setAwardForSummaryPanelDisplay(tmpAward);
        this.getAwardHierarchyService().createNodeMapsOnFormForSummaryPanel(timeAndMoneyDocument.getAwardHierarchyNodes(), timeAndMoneyForm.getPreviousNodeMap(), timeAndMoneyForm.getNextNodeMap());
        GlobalVariables.getUserSession().addObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY", (Object)timeAndMoneyDocument);
        this.populateOtherPanels(timeAndMoneyForm.getTransactionBean().getNewAwardAmountTransaction(), timeAndMoneyForm, rootAwardNumber);
        return forward;
    }

    protected AwardHierarchyService getAwardHierarchyService() {
        return (AwardHierarchyService)KraServiceLocator.getService(AwardHierarchyService.class);
    }

    public ActionForward handleDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, TimeAndMoneyForm timeAndMoneyForm) throws Exception {
        String command = timeAndMoneyForm.getCommand();
        ActionForward forward = null;
        if ("displayActionListInlineView".equals(command)) {
            String docIdRequestParameter = request.getParameter("docId");
            Document retrievedDocument = this.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
            timeAndMoneyForm.setDocument(retrievedDocument);
            request.setAttribute("docId", (Object)docIdRequestParameter);
            ActionForward baseForward = mapping.findForward("copyProposal");
            forward = new ActionForward(this.buildForwardStringForActionListCommand(baseForward.getPath(), docIdRequestParameter));
        } else if ("timeAndMoney".equals(command)) {
            this.loadDocument((KualiDocumentFormBase)timeAndMoneyForm);
        } else {
            forward = super.docHandler(mapping, form, request, response);
        }
        if ("timeAndMoney".equals(command)) {
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    public ActionForward addTransaction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.captureDateChangeTransactions(form);
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        if (timeAndMoneyForm.getTransactionBean().addPendingTransactionItem()) {
            timeAndMoneyForm.setToPendingView();
            this.refreshView(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteTransaction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.captureDateChangeTransactions(form);
        ((TimeAndMoneyForm)form).getTransactionBean().deletePendingTransactionItem(this.getLineToDelete(request));
        this.refreshView(mapping, form, request, response);
        return mapping.findForward("basic");
    }

    public ActionForward switchAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        String goToAwardNumber = timeAndMoneyForm.getGoToAwardNumber();
        this.populateOtherPanels(timeAndMoneyForm.getTransactionBean().getNewAwardAmountTransaction(), timeAndMoneyForm, goToAwardNumber);
        return mapping.findForward("basic");
    }

    private void populateOtherPanels(AwardAmountTransaction newAwardAmountTransaction, TimeAndMoneyForm timeAndMoneyForm, String goToAwardNumber) throws LookupException, SQLException, WorkflowException {
        Award award = this.getAwardVersionService().getWorkingAwardVersion(goToAwardNumber);
        if (award == null) {
            GlobalVariables.getMessageMap().putError("goToAwardNumber", "error.timeandmoney.invalidawardnumber", new String[]{goToAwardNumber});
            return;
        }
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        timeAndMoneyDocument.setAwardNumber(award.getAwardNumber());
        timeAndMoneyDocument.setAward(award);
        TimeAndMoneyHistoryService tamhs = (TimeAndMoneyHistoryService)KraServiceLocator.getService(TimeAndMoneyHistoryService.class);
        tamhs.getTimeAndMoneyHistory(timeAndMoneyDocument.getAwardNumber(), timeAndMoneyDocument.getTimeAndMoneyHistory(), timeAndMoneyForm.getColumnSpan());
        timeAndMoneyDocument.getAwardVersionHistoryList().clear();
        tamhs.buildTimeAndMoneyHistoryObjects(award.getAwardNumber(), timeAndMoneyDocument.getAwardVersionHistoryList());
        TimeAndMoneyActionSummaryService tamass = (TimeAndMoneyActionSummaryService)KraServiceLocator.getService(TimeAndMoneyActionSummaryService.class);
        timeAndMoneyDocument.getTimeAndMoneyActionSummaryItems().clear();
        tamass.populateActionSummary(timeAndMoneyDocument.getTimeAndMoneyActionSummaryItems(), goToAwardNumber);
        timeAndMoneyDocument.setNewAwardAmountTransaction(newAwardAmountTransaction);
    }

    public boolean isNewAward(TimeAndMoneyForm timeAndMoneyForm) {
        return timeAndMoneyForm.getTimeAndMoneyDocument().getAward().getAwardDirectFandADistributions().size() == 0;
    }

    protected AwardDirectFandADistributionService getAwardDirectFandADistributionService() {
        return (AwardDirectFandADistributionService)KraServiceLocator.getService(AwardDirectFandADistributionService.class);
    }

    public AwardVersionService getAwardVersionService() {
        this.awardVersionService = (AwardVersionService)KraServiceLocator.getService(AwardVersionService.class);
        return this.awardVersionService;
    }

    protected ActivePendingTransactionsService getActivePendingTransactionsService() {
        if (this.activePendingTransactionsService == null) {
            this.activePendingTransactionsService = (ActivePendingTransactionsService)KraServiceLocator.getService(ActivePendingTransactionsService.class);
        }
        return this.activePendingTransactionsService;
    }

    public String buildForwardStringForActionListCommand(String forwardPath, String docIdRequestParameter) {
        StringBuilder sb = new StringBuilder();
        sb.append(forwardPath);
        sb.append("?");
        sb.append("docId");
        sb.append("=");
        sb.append(docIdRequestParameter);
        return sb.toString();
    }

    public ActionForward addTransaction() {
        return null;
    }

    public ActionForward deleteTransaction() {
        return null;
    }

    public ActionForward submit() {
        return null;
    }

    public ActionForward addAwardDirectFandADistribution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        this.captureDateChangeTransactions(form);
        timeAndMoneyForm.getAwardDirectFandADistributionBean().addAwardDirectFandADistribution(((TimeAndMoneyForm)form).getAwardDirectFandADistributionBean());
        return mapping.findForward("basic");
    }

    public ActionForward deleteAwardDirectFandADistribution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        this.captureDateChangeTransactions(form);
        timeAndMoneyForm.getTimeAndMoneyDocument().getAward().getAwardDirectFandADistributions().remove(this.getLineToDelete(request));
        timeAndMoneyForm.getAwardDirectFandADistributionBean().updateBudgetPeriodsAfterDelete(timeAndMoneyForm.getTimeAndMoneyDocument().getAward().getAwardDirectFandADistributions());
        return mapping.findForward("basic");
    }

    public ActionForward timeAndMoney(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward recalculateDirectFandADistributionTotals(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public BusinessObjectService getBusinessObjectService() {
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        return this.businessObjectService;
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.reload(mapping, form, request, response);
        return forward;
    }

    public ActionForward returnToAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String awardDocumentNumber;
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        if (!this.getKraWorkflowService().isInWorkflow((Document)timeAndMoneyDocument)) {
            this.save(mapping, form, request, response);
        }
        if (StringUtils.isBlank((String)(awardDocumentNumber = (String)GlobalVariables.getUserSession().retrieveObject("returnToAwardDocument-" + timeAndMoneyDocument.getDocumentNumber())))) {
            awardDocumentNumber = timeAndMoneyDocument.getAward().getAwardDocument().getDocumentNumber();
        }
        AwardDocument awardDocument = (AwardDocument)this.getDocumentService().getByDocumentHeaderId(awardDocumentNumber);
        String routeHeaderId = awardDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
        GlobalVariables.getUserSession().removeObject("returnToAwardDocument-" + timeAndMoneyDocument.getDocumentNumber());
        String forward = this.buildForwardUrl(routeHeaderId);
        return new ActionForward(forward, true);
    }

    protected KraWorkflowService getKraWorkflowService() {
        return (KraWorkflowService)KraServiceLocator.getService(KraWorkflowService.class);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public boolean isDirectIndirectViewEnabled() {
        boolean returnValue = false;
        String directIndirectEnabledValue = this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST");
        if (directIndirectEnabledValue.equals("1")) {
            returnValue = true;
        }
        return returnValue;
    }

    public ActionForward goToNextAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        HashMap<String, String> map = new HashMap<String, String>();
        String nextAwardNumber = (String)timeAndMoneyForm.getNextNodeMap().get(timeAndMoneyForm.getAwardForSummaryPanelDisplay().getAwardNumber());
        map.put("awardNumber", nextAwardNumber);
        Award nextAward = (Award)((List)this.getBusinessObjectService().findMatching(Award.class, map)).get(0);
        timeAndMoneyForm.setAwardForSummaryPanelDisplay(nextAward);
        return mapping.findForward("basic");
    }

    public ActionForward goToPreviousAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        HashMap<String, String> map = new HashMap<String, String>();
        String previousAwardNumber = (String)timeAndMoneyForm.getPreviousNodeMap().get(timeAndMoneyForm.getAwardForSummaryPanelDisplay().getAwardNumber());
        map.put("awardNumber", previousAwardNumber);
        Award previousAward = (Award)((List)this.businessObjectService.findMatching(Award.class, map)).get(0);
        timeAndMoneyForm.setAwardForSummaryPanelDisplay(previousAward);
        return mapping.findForward("basic");
    }

    public ActionForward editOrVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument doc = timeAndMoneyForm.getTimeAndMoneyDocument();
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        String rootAwardNumber = doc.getRootAwardNumber();
        Award rootAward = this.getAwardVersionService().getWorkingAwardVersion(rootAwardNumber);
        TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)documentService.getNewDocument(TimeAndMoneyDocument.class);
        timeAndMoneyDocument.getDocumentHeader().setDocumentDescription("timeandmoney document");
        timeAndMoneyDocument.setRootAwardNumber(rootAwardNumber);
        timeAndMoneyDocument.setAwardNumber(rootAward.getAwardNumber());
        timeAndMoneyDocument.setAward(rootAward);
        AwardAmountTransaction aat = new AwardAmountTransaction();
        aat.setAwardNumber("000000-00000");
        aat.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
        aat.setTransactionTypeCode(null);
        timeAndMoneyDocument.getAwardAmountTransactions().add(aat);
        documentService.saveDocument((Document)timeAndMoneyDocument);
        String routeHeaderId = timeAndMoneyDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
        String forwardString = this.buildForwardUrl(routeHeaderId);
        ActionForward forward = new ActionForward(forwardString, true);
        return forward;
    }

    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        if (formBase.isFormDocumentInitialized()) {
            Document document = formBase.getDocument();
            Person user = GlobalVariables.getUserSession().getPerson();
            DocumentPresentationController documentPresentationController = KNSServiceLocator.getDocumentHelperService().getDocumentPresentationController(document);
            DocumentAuthorizer documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(document);
            Set documentActions = documentPresentationController.getDocumentActions(document);
            documentActions = documentAuthorizer.getDocumentActions(document, user, documentActions);
            if (this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking()) {
                documentActions = this.getPessimisticLockService().getDocumentActions(document, user, documentActions);
            }
            HashSet<String> editModes = new HashSet<String>();
            if (!documentAuthorizer.canOpen(document, user)) {
                editModes.add("unviewable");
            } else if (documentActions.contains("canEdit")) {
                editModes.add("fullEntry");
            } else {
                editModes.add("viewOnly");
            }
            Map editMode = this.convertSetToMap(editModes);
            if (this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking()) {
                editMode = this.getPessimisticLockService().establishLocks(document, editMode, user);
            }
            if (editMode.containsKey("fullEntry")) {
                if (!documentActions.contains("canEditDocumentOverview")) {
                    documentActions.add("canEditDocumentOverview");
                }
            } else if (documentActions.contains("canEditDocumentOverview")) {
                documentActions.remove("canEditDocumentOverview");
            }
            if (documentActions.contains("canCopy")) {
                documentActions.remove("canCopy");
            }
            formBase.setDocumentActions(this.convertSetToMap(documentActions));
            formBase.setEditingMode(editMode);
        }
    }
}

