/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kuali.kra.logging.BufferedLogger;

public class NaturalStringComparator
implements Serializable,
Comparator<String> {
    private static final long serialVersionUID = -8005478235094346386L;
    private static final NaturalStringComparator theInstance = new NaturalStringComparator();

    public static NaturalStringComparator getInstance() {
        return theInstance;
    }

    @Override
    public int compare(String string1, String string2) {
        BufferedLogger.debug((Object[])new Object[]{"Comparing ", string1, " to ", string2});
        if (string1 == string2) {
            return 0;
        }
        if (string1 == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        if (string1.equalsIgnoreCase(string2)) {
            return string1.compareTo(string2);
        }
        if (string1.equals("")) {
            return -1;
        }
        if (string2.equals("")) {
            return 1;
        }
        char c1 = string1.charAt(0);
        char c2 = string2.charAt(0);
        if (Character.isDigit(c1) && !Character.isDigit(c2)) {
            return -1;
        }
        if (Character.isDigit(c2) && !Character.isDigit(c1)) {
            return 1;
        }
        String[] chunks1 = this.splitOnNumerics(string1);
        String[] chunks2 = this.splitOnNumerics(string2);
        int retval = chunks1.length - chunks2.length;
        for (int i = 0; i < Math.min(chunks1.length, chunks2.length); ++i) {
            int comparison;
            try {
                long number1 = Long.parseLong(chunks1[i]);
                long number2 = Long.parseLong(chunks2[i]);
                if (number1 < number2) {
                    retval = -1;
                    break;
                }
                if (number1 > number2) {
                    retval = 1;
                    break;
                }
                comparison = chunks1[i].compareTo(chunks2[i]);
                if (comparison == 0) continue;
                retval = comparison;
            }
            catch (NumberFormatException e) {
                comparison = chunks1[i].compareToIgnoreCase(chunks2[i]);
                if (comparison == 0) continue;
                retval = comparison;
            }
            break;
        }
        BufferedLogger.debug((Object[])new Object[]{string1, retval < 0 ? " < " : (retval > 0 ? " > " : " = "), string2});
        return retval;
    }

    private String[] splitOnNumerics(String strToSplit) {
        Pattern pattern = Pattern.compile("(\\D+|\\d+)");
        Matcher matcher = pattern.matcher(strToSplit);
        ArrayList<String> matchList = new ArrayList<String>();
        while (matcher.find()) {
            matchList.add(matcher.group());
        }
        return matchList.toArray(new String[matchList.size()]);
    }
}

