/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.kuali.kra.util.SensitiveFieldMatcher;
import org.kuali.kra.util.SensitiveFieldMatcherDecorator;
import org.kuali.kra.util.SensitiveFieldResourceLoader;

public class SensitiveFieldPatternMatcherDecorator
extends SensitiveFieldMatcherDecorator {
    public static final String REPEAT_NTIMES = "[\\w\\.]*";
    public static final String STAR_CONSTANT = "*";
    private List<Pattern> listOfPatterns = new ArrayList();

    public SensitiveFieldPatternMatcherDecorator(SensitiveFieldMatcher matcher) {
        super(matcher);
        this.compileToPatterns(SensitiveFieldResourceLoader.getInstance().getSensitiveFields());
    }

    private void compileToPatterns(List<String> listOfStrings) {
        for (String regex : listOfStrings) {
            if (!regex.contains(STAR_CONSTANT)) continue;
            this.listOfPatterns.add(Pattern.compile(REPEAT_NTIMES + regex.substring(0, regex.length() - 1) + REPEAT_NTIMES, 2));
        }
    }

    public boolean match(String text) {
        if (this.matcher.match(text)) {
            return true;
        }
        for (Pattern pattern : this.listOfPatterns) {
            if (!pattern.matcher(text).matches()) continue;
            return true;
        }
        return false;
    }
}

