/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.MultiCampusIdentityService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.location.api.campus.CampusContract;
import org.kuali.rice.location.impl.campus.CampusBo;

public class MultiCampusDummyLoginFilter
implements Filter {
    private String loginPath;
    private boolean showPassword = false;
    private List<CampusContract> campuses;

    public void init(FilterConfig config) throws ServletException {
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.loginPath = config.getInitParameter("loginPath");
        this.showPassword = new Boolean(config.getInitParameter("showPassword"));
        this.campuses = new ArrayList(businessObjectService.findAll(CampusBo.class));
        if (this.loginPath == null) {
            this.loginPath = "/WEB-INF/jsp/multicampus_dummy_login.jsp";
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest hsreq = (HttpServletRequest)request;
            UserSession session = null;
            if (hsreq.getSession().getAttribute("UserSession") != null) {
                session = (UserSession)hsreq.getSession().getAttribute("UserSession");
            }
            if (session == null) {
                IdentityService auth = KimApiServiceLocator.getIdentityService();
                MultiCampusIdentityService multiCampusAuth = (MultiCampusIdentityService)KraServiceLocator.getService(MultiCampusIdentityService.class);
                request.setAttribute("showPasswordField", (Object)this.showPassword);
                request.setAttribute("campuses", (Object)this.campuses);
                String user = request.getParameter("__login_user");
                String password = request.getParameter("__login_pw");
                String campusCode = request.getParameter("__login_campusCode");
                String multiCampusUser = multiCampusAuth.getMultiCampusPrincipalName(user, campusCode);
                if (user != null) {
                    Principal principal;
                    Principal principal2 = principal = this.showPassword ? auth.getPrincipalByPrincipalNameAndPassword(multiCampusUser, password) : auth.getPrincipalByPrincipalName(multiCampusUser);
                    if (principal == null) {
                        this.handleInvalidLogin(request, response);
                        return;
                    }
                    request = new /* Unavailable Anonymous Inner Class!! */;
                    hsreq.getSession().setAttribute("userCampusCode", (Object)campusCode);
                } else {
                    request.getRequestDispatcher(this.loginPath).forward(request, response);
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    private void handleInvalidLogin(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        request.setAttribute("invalidAuth", (Object)Boolean.TRUE);
        request.getRequestDispatcher(this.loginPath).forward(request, response);
    }

    public void destroy() {
    }
}

