/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.filter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.web.filter.PerformanceFilterResponse;
import org.kuali.kra.web.filter.PerformanceMeasurementFilter;

public class PerformanceMeasurementFilter
implements Filter {
    private FilterConfig filterConfig;
    private Calendar _performanceLogCalendar;

    public void destroy() {
        this.setPerformanceLogCalendar(null);
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long startTime = System.currentTimeMillis();
        PerformanceFilterResponse filterResponse = new PerformanceFilterResponse((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)filterResponse);
        try {
            this.processResponse(request, filterResponse, startTime);
        }
        catch (Throwable t) {
            Log logger = LogFactory.getLog(PerformanceMeasurementFilter.class);
            logger.error((Object)t.getMessage(), t);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.setPerformanceLogCalendar(this.getDateOnlyCalendar());
    }

    private String getPerformanceLogFileName() {
        Calendar todayCalendar = this.getDateOnlyCalendar();
        if (this.isNewFileNeeded(todayCalendar)) {
            this.setPerformanceLogCalendar(todayCalendar);
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        return "Real-time Performance Log " + dateFormatter.format(this.getPerformanceLogCalendar().getTime()) + ".xml";
    }

    private boolean isNewFileNeeded(Calendar todayCalendar) {
        return todayCalendar.get(5) != this.getPerformanceLogCalendar().get(5);
    }

    private Calendar getDateOnlyCalendar() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private synchronized Calendar getPerformanceLogCalendar() {
        return this._performanceLogCalendar;
    }

    private void logSample(HttpSample sample, String outputDirectory) {
        try {
            File file = new File(outputDirectory, this.getPerformanceLogFileName());
            if (!file.exists()) {
                this.createNewFile(file);
            }
            this.insertLine(file, sample);
        }
        catch (Exception e) {
            Log logger = LogFactory.getLog(PerformanceMeasurementFilter.class);
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void processResponse(ServletRequest request, PerformanceFilterResponse response, long startTime) {
        int elapsedTime = (int)(System.currentTimeMillis() - startTime);
        String outputDirectory = this.filterConfig.getServletContext().getInitParameter("org.kuali.kra.perftest.REPORT_DIRECTORY");
        HttpSample httpSample = new HttpSample(this, (HttpServletRequest)request, response, outputDirectory, startTime, elapsedTime);
        Thread t = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        t.start();
    }

    private synchronized void setPerformanceLogCalendar(Calendar performanceLogCalendar) {
        this._performanceLogCalendar = performanceLogCalendar;
    }

    private void createNewFile(File file) throws IOException {
        FileWriter writer = new FileWriter(file, true);
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        writer.write("<!-- Performance Log File: ");
        writer.write(file.getName());
        writer.write(" -->\n\n");
        writer.write("<httpSamples>");
        writer.write("\n</httpSamples>");
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertLine(File file, HttpSample httpSample) throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.skipBytes((int)(file.length() - (long)"\n</httpSamples>".getBytes().length));
            randomAccessFile.write("\n".getBytes());
            randomAccessFile.write(httpSample.toXML().getBytes());
            randomAccessFile.write("\n".getBytes());
            randomAccessFile.write("</httpSamples>".getBytes());
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    static /* synthetic */ void access$000(PerformanceMeasurementFilter x0, HttpSample x1, String x2) {
        x0.logSample(x1, x2);
    }
}

