/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.filter;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;
import org.kuali.kra.util.SensitiveFieldFilterUtil;

public class RequestLoggingFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(RequestLoggingFilter.class);
    private static final String[] paramsToLogInfoByDefault = new String[]{"methodToCall"};
    private static final Boolean SENSITIVE_FILEDS_FILTER = true;
    private FilterConfig config;

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response);
        chain.doFilter(request, response);
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.isInfoNotAllowed()) {
            return;
        }
        MDC.put((String)"clientIp", (Object)request.getRemoteAddr());
        LOG.info((Object)("Current User :" + request.getRemoteUser()));
        LOG.info((Object)("RequestURI : " + request.getRequestURI()));
        LOG.info((Object)this.getRequestParametersMessage(request, SENSITIVE_FILEDS_FILTER, paramsToLogInfoByDefault));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\n***************************** HEADERS **********************************\n" + this.getRequestHeadersMessage(request)));
            LOG.debug((Object)("\n***************************** PARAMETERS *******************************\n" + this.getRequestParametersMessage(request, SENSITIVE_FILEDS_FILTER, new String[0])));
            LOG.debug((Object)("\n***************************** ATTRIBUTES *******************************\n" + this.getRequestAttributesMessage(request)));
        }
    }

    private String getRequestHeadersMessage(HttpServletRequest request) {
        StringBuilder retval = new StringBuilder();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            retval.append(headerName).append(": {").toString();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                retval.append(headerValue);
                if (!headerValues.hasMoreElements()) continue;
                retval.append(",");
            }
            retval.append("}\n");
        }
        return retval.toString();
    }

    private String getRequestParametersMessage(HttpServletRequest request, Boolean sensitivefieldsfilter, String ... params) {
        StringBuilder retval = new StringBuilder();
        Enumeration parameterNames = request.getParameterNames();
        block0: while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            if (sensitivefieldsfilter.booleanValue() && SensitiveFieldFilterUtil.isFieldSensitive((String)parameterName)) continue;
            if (params.length == 0) {
                retval.append(this.getRequestParameterMessage(request, parameterName));
                retval.append("\n");
                continue;
            }
            for (String p : params) {
                if (!parameterName.contains(p)) continue;
                retval.append(this.getRequestParameterMessage(request, parameterName));
                continue block0;
            }
        }
        return retval.toString();
    }

    private String getRequestParameterMessage(HttpServletRequest request, String parameterName) {
        StringBuilder retval = new StringBuilder();
        retval.append(parameterName).append(": {").toString();
        for (String parameterValue : request.getParameterValues(parameterName)) {
            retval.append(parameterValue);
            retval.append(",");
        }
        retval.append("}");
        return retval.toString();
    }

    private String getRequestAttributesMessage(HttpServletRequest request) {
        StringBuilder retval = new StringBuilder();
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            retval.append(attributeName).append(": ").append(request.getAttribute(attributeName)).append("\n").toString();
        }
        return retval.toString();
    }

    protected boolean isInfoNotAllowed() {
        return !LOG.isInfoEnabled();
    }
}

