/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.listener;

import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionLoggingListener
implements HttpSessionListener {
    private static final Log LOG = LogFactory.getLog(SessionLoggingListener.class);

    public void sessionCreated(HttpSessionEvent se) {
        if (this.isLoggingAllowed()) {
            this.logSessionStart(se);
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        if (this.isLoggingAllowed()) {
            this.logSessionEnd(se);
        }
    }

    protected void logSessionEnd(HttpSessionEvent event) {
        long startMem = Runtime.getRuntime().freeMemory();
        long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long originalMemory = (Long)event.getSession().getAttribute("startingMemory");
        String difference = "";
        difference = originalMemory < usedMemory ? "Memory usage increased by " + (usedMemory - originalMemory) : "Memory usage decreased by " + (originalMemory - usedMemory);
        LOG.info((Object)("Session was just destroyed : " + usedMemory + " memory used. Originally created with " + originalMemory + " memory used. " + difference));
    }

    protected void logSessionStart(HttpSessionEvent event) {
        long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        event.getSession().setAttribute("startingMemory", (Object)usedMemory);
        LOG.info((Object)("Session was just created : " + usedMemory + " memory used"));
    }

    protected boolean isLoggingAllowed() {
        return LOG.isInfoEnabled();
    }
}

