/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.struts.action;

import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.form.Auditable;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentAuditEvent;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;

public final class AuditActionHelper {
    private final KualiRuleService ruleService;

    public AuditActionHelper() {
        this((KualiRuleService)KraServiceLocator.getService(KualiRuleService.class));
    }

    AuditActionHelper(KualiRuleService ruleService) {
        if (ruleService == null) {
            throw new NullPointerException("the ruleService is null");
        }
        this.ruleService = ruleService;
    }

    public <T extends KualiDocumentFormBase> ActionForward setAuditMode(ActionMapping mapping, T form, boolean audit) {
        if (mapping == null) {
            throw new NullPointerException("the mapping is null");
        }
        if (form == null) {
            throw new NullPointerException("the form is null");
        }
        ((Auditable)form).setAuditActivated(audit);
        return mapping.findForward("basic");
    }

    public <T extends KualiDocumentFormBase> boolean auditConditionally(T form) {
        return this.auditDocumentFromForm(form, false);
    }

    public <T extends KualiDocumentFormBase> boolean auditUnconditionally(T form) {
        return this.auditDocumentFromForm(form, true);
    }

    public boolean auditUnconditionally(Document document) {
        if (document == null) {
            throw new NullPointerException("the document is null");
        }
        return this.ruleService.applyRules((KualiDocumentEvent)new DocumentAuditEvent(document));
    }

    private <T extends KualiDocumentFormBase> boolean auditDocumentFromForm(T form, boolean alwaysApplyAudit) {
        if (form == null) {
            throw new NullPointerException("the form is null");
        }
        if (((Auditable)form).isAuditActivated() || alwaysApplyAudit) {
            return this.auditUnconditionally(form.getDocument());
        }
        return true;
    }

    public <T extends KualiDocumentFormBase> ValidationState isValidSubmission(T form, boolean unconditionally) {
        ValidationState result = ValidationState.OK;
        boolean auditPassed = unconditionally ? this.auditUnconditionally(form) : this.auditConditionally(form);
        if (!auditPassed) {
            result = ValidationState.WARNING;
            Iterator iter = KNSGlobalVariables.getAuditErrorMap().keySet().iterator();
            while (iter.hasNext()) {
                AuditCluster auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(iter.next());
                if (StringUtils.equalsIgnoreCase((String)auditCluster.getCategory(), (String)"Warnings")) continue;
                result = ValidationState.ERROR;
                break;
            }
        }
        return result;
    }
}

