/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.struts.action;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.web.struts.form.CommitteeForm;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.committee.bo.IacucCommittee;
import org.kuali.kra.iacuc.committee.document.CommonCommitteeDocument;
import org.kuali.kra.iacuc.committee.web.struts.form.IacucCommitteeForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.service.ResearchDocumentService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.subaward.SubAwardForm;
import org.kuali.kra.timeandmoney.TimeAndMoneyForm;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.kra.web.struts.authorization.WebAuthorizationService;
import org.kuali.kra.web.struts.form.CustomDataDocumentForm;
import org.kuali.kra.web.struts.form.KraTransactionalDocumentFormBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.util.MessageList;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.action.KualiTransactionalDocumentActionBase;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.exception.UnknownDocumentIdException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class KraTransactionalDocumentActionBase
extends KualiTransactionalDocumentActionBase {
    private static final Log LOG = LogFactory.getLog(KraTransactionalDocumentActionBase.class);
    private static final String DEFAULT_TAB = "Versions";
    private static final String ALTERNATE_OPEN_TAB = "Parameters";
    private static final String ONE_ADHOC_REQUIRED_ERROR_KEY = "error.adhoc.oneAdHocRequired";
    private static final String DOCUMENT_RELOAD_QUESTION = "DocReload";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageList messageList;
        KraTransactionalDocumentFormBase kcForm = (KraTransactionalDocumentFormBase)form;
        String commandParam = request.getParameter("command");
        if (StringUtils.isNotBlank((String)commandParam) && commandParam.equals("displayDocSearchView") && StringUtils.isNotBlank((String)request.getParameter("viewDocument")) && request.getParameter("viewDocument").equals("true")) {
            kcForm.setViewOnly(true);
            ((ResearchDocumentBase)kcForm.getDocument()).setViewOnly(kcForm.isViewOnly());
        }
        if ((messageList = (MessageList)GlobalVariables.getUserSession().retrieveObject("holdingPageMessages")) != null) {
            KNSGlobalVariables.getMessageList().addAll((Collection)messageList);
            GlobalVariables.getUserSession().removeObject("holdingPageMessages");
        }
        ActionForward returnForward = mapping.findForward("basic");
        returnForward = super.execute(mapping, form, request, response);
        return returnForward;
    }

    protected ActionForward dispatchMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String methodName) throws Exception {
        ActionForward actionForward = null;
        actionForward = !this.isTaskAuthorized(methodName, form, request) ? this.processAuthorizationViolation(methodName, mapping, form, request, response) : super.dispatchMethod(mapping, form, request, response, methodName);
        return actionForward;
    }

    public ActionForward headerTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (form instanceof KraTransactionalDocumentFormBase) {
            ((KraTransactionalDocumentFormBase)form).setNavigateTo(this.getHeaderTabNavigateTo(request));
        }
        ((KualiForm)form).setTabStates(new HashMap());
        return super.headerTab(mapping, form, request, response);
    }

    public ActionForward confirm(StrutsConfirmation question, String yesMethodName, String noMethodName) throws Exception {
        question.setCaller(((KualiForm)question.getForm()).getMethodToCall());
        BufferedLogger.debug((Object[])new Object[]{"Caller is ", question.getCaller()});
        BufferedLogger.debug((Object[])new Object[]{"Setting caller from stacktrace ", Arrays.asList(new Throwable().getStackTrace())});
        BufferedLogger.debug((Object[])new Object[]{"Current action is ", this.getClass()});
        if (question.hasQuestionInstAttributeName()) {
            String buttonClicked = question.getRequest().getParameter("buttonClicked");
            if ("0".equals(buttonClicked) && StringUtils.isNotBlank((String)yesMethodName)) {
                return this.dispatchMethod(question.getMapping(), question.getForm(), question.getRequest(), question.getResponse(), yesMethodName);
            }
            if (StringUtils.isNotBlank((String)noMethodName)) {
                return this.dispatchMethod(question.getMapping(), question.getForm(), question.getRequest(), question.getResponse(), noMethodName);
            }
        } else {
            return this.performQuestionWithoutInput(question, "");
        }
        return question.getMapping().findForward("basic");
    }

    protected StrutsConfirmation buildParameterizedConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId, String configurationId, String ... params) throws Exception {
        StrutsConfirmation retval = new StrutsConfirmation();
        retval.setMapping(mapping);
        retval.setForm(form);
        retval.setRequest(request);
        retval.setResponse(response);
        retval.setQuestionId(questionId);
        retval.setQuestionType("confirmationQuestion");
        ConfigurationService kualiConfiguration = KRADServiceLocator.getKualiConfigurationService();
        String questionText = kualiConfiguration.getPropertyValueAsString(configurationId);
        for (int i = 0; i < params.length; ++i) {
            questionText = StringUtils.replace((String)questionText, (String)("{" + i + "}"), (String)params[i]);
        }
        retval.setQuestionText(questionText);
        return retval;
    }

    protected ActionForward performQuestionWithoutInput(StrutsConfirmation question, String context) throws Exception {
        return this.performQuestionWithoutInput(question.getMapping(), question.getForm(), question.getRequest(), question.getResponse(), question.getQuestionId(), question.getQuestionText(), question.getQuestionType(), question.getCaller(), context);
    }

    protected String buildForwardUrl(String routeHeaderId) {
        ResearchDocumentService researchDocumentService = (ResearchDocumentService)KraServiceLocator.getService(ResearchDocumentService.class);
        String forward = researchDocumentService.getDocHandlerUrl(routeHeaderId);
        forward = (forward = forward.replaceFirst(DEFAULT_TAB, ALTERNATE_OPEN_TAB)).indexOf("?") == -1 ? forward + "?" : forward + "&";
        forward = forward + "docId=" + routeHeaderId;
        forward = forward + "&command=displayDocSearchView";
        if (GlobalVariables.getUserSession().isBackdoorInUse()) {
            forward = forward + "&backdoorId=" + GlobalVariables.getUserSession().getPrincipalName();
        }
        return forward;
    }

    protected String buildActionUrl(String routeHeaderId, String actionTabName, String documentTypeName) {
        String returnLocation = this.buildForwardUrl(routeHeaderId);
        returnLocation = returnLocation.replaceFirst("displayDocSearchView", actionTabName);
        returnLocation = returnLocation + "&docTypeName=" + documentTypeName;
        returnLocation = returnLocation + "&viewDocument=false";
        return returnLocation;
    }

    private boolean isTaskAuthorized(String methodName, ActionForm form, HttpServletRequest request) {
        WebAuthorizationService webAuthorizationService = (WebAuthorizationService)KraServiceLocator.getService(WebAuthorizationService.class);
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        ((KraTransactionalDocumentFormBase)form).setActionName(this.getClass().getSimpleName());
        boolean isAuthorized = webAuthorizationService.isAuthorized(userId, this.getClass(), methodName, form, request);
        if (!isAuthorized) {
            BufferedLogger.error((Object[])new Object[]{"User not authorized to perform ", methodName, " for document: ", ((KualiDocumentFormBase)form).getDocument().getClass().getName()});
        }
        return isAuthorized;
    }

    protected boolean isAuthorized(Task task) {
        String currentUser = GlobalVariables.getUserSession().getPrincipalId();
        TaskAuthorizationService authorizationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        boolean isAuthorized = authorizationService.isAuthorized(currentUser, task);
        if (!isAuthorized) {
            LOG.error((Object)("User not authorized to perform " + task.getTaskName()));
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.putErrorWithoutFullErrorPath("taskAuthorization", "error.authorization.violation", new String[0]);
        }
        return isAuthorized;
    }

    public ActionForward processAuthorizationViolation(String taskName, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.putErrorWithoutFullErrorPath("taskAuthorization", "error.authorization.violation", new String[0]);
        return mapping.findForward("basic");
    }

    protected void setupPessimisticLockMessages(Document document, HttpServletRequest request) {
        ArrayList<String> lockMessages = new ArrayList<String>();
        HashMap<String, PessimisticLock> generatedLocks = new HashMap<String, PessimisticLock>();
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (lock.isOwnedByUser(GlobalVariables.getUserSession().getPerson()) || StringUtils.startsWith((String)lock.getLockDescriptor(), (String)"null-") || generatedLocks.containsKey(lock.getDocumentNumber())) continue;
            lockMessages.add(this.generatePessimisticLockMessage(lock));
            generatedLocks.put(lock.getDocumentNumber(), lock);
        }
        request.setAttribute("DocumentPessimisticLockMessages", lockMessages);
    }

    protected String generatePessimisticLockMessage(PessimisticLock lock) {
        String descriptor = lock.getLockDescriptor() != null ? lock.getLockDescriptor() : "";
        String message = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("locked.document.message");
        descriptor = this.getDocumentType(descriptor);
        message = message.replace("{DOCUMENT_TYPE}", descriptor);
        message = message.replace("{LOCKED_BY}", lock.getOwnedByUser().getPrincipalName());
        message = message.replace("{TIMESTAMP}", RiceConstants.getDefaultTimeFormat().format(lock.getGeneratedTimestamp()));
        message = message.replace("{DATESTAMP}", RiceConstants.getDefaultDateFormat().format(lock.getGeneratedTimestamp()));
        return message;
    }

    private String getDocumentType(String descriptor) {
        String[] resultArray;
        String result = "document";
        if (StringUtils.isNotEmpty((String)descriptor) && (resultArray = descriptor.split("-")).length > 2) {
            if (resultArray.length > 3 && StringUtils.equalsIgnoreCase((String)resultArray[2], (String)"award")) {
                result = "Award";
            } else if (StringUtils.equalsIgnoreCase((String)result, (String)"coidisclosure")) {
                result = "Disclosure";
            } else if (StringUtils.equalsIgnoreCase((String)result, (String)"subaward")) {
                result = "Subaward";
            } else if (StringUtils.equalsIgnoreCase((String)result, (String)"protocol")) {
                result = "Protocol";
            } else if (StringUtils.equalsIgnoreCase((String)result, (String)"iacuc_protocol")) {
                result = "IACUC Protocol";
            } else if (StringUtils.equalsIgnoreCase((String)result, (String)"negotiation")) {
                result = "Negotiation";
            } else if (StringUtils.equalsIgnoreCase((String)result, (String)"proposal development")) {
                result = "Proposal";
            }
        }
        return result;
    }

    private List<PessimisticLock> findMatchingLocksWithGivenDescriptor(String lockDescriptor) {
        BusinessObjectService boService = KRADServiceLocator.getBusinessObjectService();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("lockDescriptor", lockDescriptor);
        List matchingLocks = (List)boService.findMatching(PessimisticLock.class, fieldValues);
        return matchingLocks;
    }

    protected void releaseLocks(Document document, String methodToCall) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        GlobalVariables.getUserSession().removeObject("ACTIVE_LOCK_REGION");
        PessimisticLockService lockService = KRADServiceLocatorWeb.getPessimisticLockService();
        Person loggedInUser = GlobalVariables.getUserSession().getPerson();
        String budgetLockDescriptor = null;
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (!StringUtils.isNotEmpty((String)lock.getLockDescriptor()) || !lock.getLockDescriptor().contains("BUDGET")) continue;
            budgetLockDescriptor = lock.getLockDescriptor();
            break;
        }
        if (document.getLockClearningMethodNames().contains(methodToCall) || StringUtils.isEmpty((String)activeLockRegion)) {
            lockService.releaseAllLocksForUser(document.getPessimisticLocks(), loggedInUser);
            if (StringUtils.isNotEmpty((String)activeLockRegion) && activeLockRegion.contains("BUDGET")) {
                List otherBudgetLocks = this.findMatchingLocksWithGivenDescriptor(budgetLockDescriptor);
                lockService.releaseAllLocksForUser(otherBudgetLocks, loggedInUser, budgetLockDescriptor);
            }
        }
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (!StringUtils.isNotEmpty((String)lock.getLockDescriptor()) || !StringUtils.isNotEmpty((String)activeLockRegion) || lock.getLockDescriptor().contains(activeLockRegion)) continue;
            List otherLocks = this.findMatchingLocksWithGivenDescriptor(lock.getLockDescriptor());
            lockService.releaseAllLocksForUser(otherLocks, loggedInUser, lock.getLockDescriptor());
        }
    }

    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        if (formBase.isFormDocumentInitialized()) {
            KraTransactionalDocumentFormBase kcFormBase = (KraTransactionalDocumentFormBase)formBase;
            ResearchDocumentBase document = (ResearchDocumentBase)formBase.getDocument();
            Person user = GlobalVariables.getUserSession().getPerson();
            KcTransactionalDocumentAuthorizerBase documentAuthorizer = (KcTransactionalDocumentAuthorizerBase)this.getDocumentHelperService().getDocumentAuthorizer((Document)document);
            Set<String> editModes = new HashSet<String>();
            KraTransactionalDocumentFormBase kraFormBase = (KraTransactionalDocumentFormBase)formBase;
            kraFormBase.setupLockRegions();
            String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
            if (!documentAuthorizer.canOpen((Document)document, user)) {
                editModes.add("unviewable");
            } else {
                document.setViewOnly(kcFormBase.isViewOnly());
                if (this.requiresLock((Document)document) && documentAuthorizer.canEdit((Document)document, user)) {
                    editModes.add("fullEntry");
                    Map editMode = this.convertSetToMap(editModes);
                    document.refreshPessimisticLocks();
                    HashSet<String> handledLockDescriptors = new HashSet<String>();
                    for (PessimisticLock lock : document.getPessimisticLocks()) {
                        if (!StringUtils.isNotEmpty((String)lock.getLockDescriptor()) || !StringUtils.isNotEmpty((String)activeLockRegion) || lock.getLockDescriptor().contains(activeLockRegion) || handledLockDescriptors.contains(lock.getLockDescriptor())) continue;
                        this.getPessimisticLockService().releaseAllLocksForUser(document.getPessimisticLocks(), user, lock.getLockDescriptor());
                        handledLockDescriptors.add(lock.getLockDescriptor());
                    }
                    editMode = this.getPessimisticLockService().establishLocks((Document)document, editMode, user);
                    document.refreshPessimisticLocks();
                    if (editMode.containsKey("viewOnly")) {
                        document.setViewOnly(true);
                        if (document instanceof BudgetDocument) {
                            BudgetDocument budgetDoc = (BudgetDocument)document;
                            budgetDoc.getParentDocument().setViewOnly(true);
                        }
                    }
                }
                editModes = documentAuthorizer.getEditModes((Document)document, user, null);
                Set documentActions = documentAuthorizer.getDocumentActions((Document)document, user, null);
                formBase.setDocumentActions(this.convertSetToMap(documentActions));
            }
            formBase.setEditingMode(this.convertSetToMap(editModes));
        }
    }

    private boolean requiresLock(Document document) {
        return this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking();
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase docForm = (KualiDocumentFormBase)form;
        this.preDocumentSave(docForm);
        String originalStatus = this.getDocumentStatus(docForm.getDocument());
        ActionForward actionForward = form instanceof CommitteeForm || form instanceof IacucCommitteeForm ? this.saveCommitteeDocument(mapping, form, request, response) : super.save(mapping, form, request, response);
        if (this.isInitialSave(originalStatus)) {
            this.initialDocumentSave(docForm);
        }
        this.postDocumentSave(docForm);
        return actionForward;
    }

    private ActionForward saveCommitteeDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.refreshAdHocRoutingWorkgroupLookups(request, kualiDocumentFormBase);
        Document document = kualiDocumentFormBase.getDocument();
        this.getKraDocumentService().saveDocument(document);
        KNSGlobalVariables.getMessageList().add("message.saved", new String[0]);
        kualiDocumentFormBase.setAnnotation("");
        return mapping.findForward("basic");
    }

    protected void preDocumentSave(KualiDocumentFormBase form) throws Exception {
    }

    protected void postDocumentSave(KualiDocumentFormBase form) throws Exception {
    }

    protected void initialDocumentSave(KualiDocumentFormBase form) throws Exception {
    }

    private String getDocumentStatus(Document doc) {
        return doc.getDocumentHeader().getWorkflowDocument().getStatus().getLabel();
    }

    private boolean isInitialSave(String status) {
        return GlobalVariables.getMessageMap().hasNoErrors() && StringUtils.equals((String)"INITIATED", (String)status);
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        KualiDocumentFormBase docForm = (KualiDocumentFormBase)form;
        if (this.canSave((ActionForm)docForm)) {
            Object question = this.getQuestion(request);
            if (question == null) {
                this.saveUnconvertedValuesToSession(request, docForm);
                forward = this.performQuestionWithoutInput(mapping, form, request, response, "DocSaveBeforeClose", this.getKualiConfigurationService().getPropertyValueAsString("document.question.saveBeforeClose.text"), "kcConfirmationQuestion", "close", "");
            } else {
                String buttonClicked = request.getParameter("buttonClicked");
                Map unconvertedValues = this.restoreUnconvertedValuesFromSession(request, docForm);
                if ("DocSaveBeforeClose".equals(question) && "0".equals(buttonClicked)) {
                    if (MapUtils.isNotEmpty((Map)unconvertedValues)) {
                        for (Map.Entry entry : unconvertedValues.entrySet()) {
                            docForm.populateForProperty((String)entry.getKey(), entry.getValue(), unconvertedValues);
                        }
                    }
                    forward = this.saveOnClose(mapping, form, request, response);
                } else {
                    forward = "DocSaveBeforeClose".equals(question) && "2".equals(buttonClicked) ? mapping.findForward("basic") : super.close(mapping, (ActionForm)docForm, request, response);
                }
            }
        } else {
            forward = this.returnToSender(request, mapping, docForm);
        }
        return forward;
    }

    private void saveUnconvertedValuesToSession(HttpServletRequest request, KualiDocumentFormBase docForm) {
        if (MapUtils.isNotEmpty((Map)docForm.getUnconvertedValues())) {
            request.getSession().setAttribute(this.getUnconvertedValuesSessionAttributeKey(docForm), new HashMap(docForm.getUnconvertedValues()));
        }
    }

    private Map<String, Object> restoreUnconvertedValuesFromSession(HttpServletRequest request, KualiDocumentFormBase docForm) {
        Map unconvertedValues = (Map)request.getSession().getAttribute(this.getUnconvertedValuesSessionAttributeKey(docForm));
        if (MapUtils.isNotEmpty((Map)unconvertedValues)) {
            request.getSession().removeAttribute(this.getUnconvertedValuesSessionAttributeKey(docForm));
            docForm.setUnconvertedValues(unconvertedValues);
        }
        return unconvertedValues;
    }

    private String getUnconvertedValuesSessionAttributeKey(KualiDocumentFormBase docForm) {
        return "preCloseUnconvertedValues." + docForm.getDocId();
    }

    protected ActionForward saveOnClose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
        if (this.isInitialSave(this.getDocumentStatus(documentForm.getDocument()))) {
            this.initialDocumentSave(documentForm);
        }
        return super.close(mapping, form, request, response);
    }

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        if (kualiDocumentFormBase instanceof CommitteeForm) {
            this.loadCommitteeDocument(kualiDocumentFormBase);
        } else if (kualiDocumentFormBase instanceof IacucCommitteeForm) {
            this.loadIacucCommitteeDocument(kualiDocumentFormBase);
        } else {
            super.loadDocument(kualiDocumentFormBase);
        }
    }

    private void loadCommitteeDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        String docId = kualiDocumentFormBase.getDocId();
        Document doc = null;
        doc = this.getDocumentService().getByDocumentHeaderId(docId);
        if (doc == null) {
            throw new UnknownDocumentIdException("Document no longer exists.  It may have been cancelled before being saved.");
        }
        WorkflowDocument workflowDocument = doc.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument != doc.getDocumentHeader().getWorkflowDocument()) {
            LOG.warn((Object)"Workflow document changed via canOpen check");
            doc.getDocumentHeader().setWorkflowDocument(workflowDocument);
        }
        kualiDocumentFormBase.setDocument(doc);
        WorkflowDocument workflowDoc = doc.getDocumentHeader().getWorkflowDocument();
        kualiDocumentFormBase.setDocTypeName(workflowDoc.getDocumentTypeName());
        String content = ((RouteHeaderService)KraServiceLocator.getService(RouteHeaderService.class)).getContent(workflowDoc.getDocumentId()).getDocumentContent();
        if (doc instanceof CommitteeDocument && !workflowDoc.getStatus().getCode().equals("F")) {
            Committee committee = (Committee)this.populateCommitteeFromXmlDocumentContents(content);
            ((CommitteeDocument)doc).getCommitteeList().add(committee);
            committee.setCommitteeDocument((CommitteeDocumentBase)((CommitteeDocument)doc));
        }
        if (!this.getDocumentHelperService().getDocumentAuthorizer(doc).canOpen(doc, GlobalVariables.getUserSession().getPerson())) {
            throw this.buildAuthorizationException("open", doc);
        }
        KRADServiceLocatorWeb.getSessionDocumentService().addDocumentToUserSession(GlobalVariables.getUserSession(), workflowDoc);
    }

    private void loadIacucCommitteeDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        String docId = kualiDocumentFormBase.getDocId();
        Document doc = null;
        doc = this.getDocumentService().getByDocumentHeaderId(docId);
        if (doc == null) {
            throw new UnknownDocumentIdException("Document no longer exists.  It may have been cancelled before being saved.");
        }
        WorkflowDocument workflowDocument = doc.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument != doc.getDocumentHeader().getWorkflowDocument()) {
            LOG.warn((Object)"Workflow document changed via canOpen check");
            doc.getDocumentHeader().setWorkflowDocument(workflowDocument);
        }
        kualiDocumentFormBase.setDocument(doc);
        WorkflowDocument workflowDoc = doc.getDocumentHeader().getWorkflowDocument();
        kualiDocumentFormBase.setDocTypeName(workflowDoc.getDocumentTypeName());
        String content = ((RouteHeaderService)KraServiceLocator.getService(RouteHeaderService.class)).getContent(workflowDoc.getDocumentId()).getDocumentContent();
        if (doc instanceof CommonCommitteeDocument && !workflowDoc.getStatus().getCode().equals("F")) {
            IacucCommittee committee = (IacucCommittee)this.populateIacucCommitteeFromXmlDocumentContents(content);
            ((CommonCommitteeDocument)doc).getCommitteeList().add(committee);
            committee.setCommitteeDocument((CommitteeDocumentBase)((CommonCommitteeDocument)doc));
        }
        if (!this.getDocumentHelperService().getDocumentAuthorizer(doc).canOpen(doc, GlobalVariables.getUserSession().getPerson())) {
            throw this.buildAuthorizationException("open", doc);
        }
        KRADServiceLocatorWeb.getSessionDocumentService().addDocumentToUserSession(GlobalVariables.getUserSession(), workflowDoc);
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        forward = form instanceof CommitteeForm ? this.routeCommittee(mapping, form, request, response) : (form instanceof IacucCommitteeForm ? this.routeIacucCommittee(mapping, form, request, response) : super.route(mapping, form, request, response));
        if (form instanceof ProposalDevelopmentForm || form instanceof InstitutionalProposalForm || form instanceof AwardForm || form instanceof IacucProtocolForm || form instanceof ProtocolForm || form instanceof CommitteeForm || form instanceof IacucCommitteeForm || form instanceof TimeAndMoneyForm || form instanceof SubAwardForm) {
            ActionForward basicForward = mapping.findForward("basic");
            if (StringUtils.equals((String)forward.getPath(), (String)basicForward.getPath())) {
                this.setupDocumentExit();
                forward = mapping.findForward("portal");
            }
        }
        return forward;
    }

    private ActionForward routeCommittee(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeForm committeeForm = (CommitteeForm)form;
        committeeForm.setDerivedValuesOnForm(request);
        ActionForward preRulesForward = this.promptBeforeValidation(mapping, form, request, response);
        if (preRulesForward != null) {
            return preRulesForward;
        }
        CommitteeDocument committeeDocument = (CommitteeDocument)committeeForm.getCommitteeDocument();
        this.getKraDocumentService().routeDocument((Document)committeeDocument, committeeForm.getAnnotation(), this.combineAdHocRecipients((KualiDocumentFormBase)committeeForm));
        KNSGlobalVariables.getMessageList().add("message.route.successful", new String[0]);
        committeeForm.setAnnotation("");
        return this.createSuccessfulSubmitRedirect("Committee", ((Committee)committeeDocument.getCommittee()).getCommitteeId(), request, mapping, (KualiDocumentFormBase)committeeForm);
    }

    private ActionForward routeIacucCommittee(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucCommitteeForm committeeForm = (IacucCommitteeForm)form;
        committeeForm.setDerivedValuesOnForm(request);
        ActionForward preRulesForward = this.promptBeforeValidation(mapping, form, request, response);
        if (preRulesForward != null) {
            return preRulesForward;
        }
        CommonCommitteeDocument committeeDocument = (CommonCommitteeDocument)committeeForm.getCommitteeDocument();
        this.getKraDocumentService().routeDocument((Document)committeeDocument, committeeForm.getAnnotation(), this.combineAdHocRecipients((KualiDocumentFormBase)committeeForm));
        KNSGlobalVariables.getMessageList().add("message.route.successful", new String[0]);
        committeeForm.setAnnotation("");
        return this.createSuccessfulSubmitRedirect("IacucCommittee", ((IacucCommittee)committeeDocument.getCommittee()).getCommitteeId(), request, mapping, (KualiDocumentFormBase)committeeForm);
    }

    protected ActionForward createSuccessfulSubmitRedirect(String submissionType, String refId, HttpServletRequest request, ActionMapping mapping, KualiDocumentFormBase form) {
        ActionForward forward = this.returnToSender(request, mapping, form);
        Properties parameters = new Properties();
        parameters.put("successfulSubmission", Boolean.TRUE.toString());
        parameters.put("submissionType", submissionType);
        parameters.put("refId", refId);
        ActionRedirect redirect = new ActionRedirect((ForwardConfig)forward);
        for (Map.Entry<Object, Object> parameter : parameters.entrySet()) {
            redirect.addParameter(parameter.getKey().toString(), parameter.getValue());
        }
        return redirect;
    }

    private PersistableBusinessObject populateCommitteeFromXmlDocumentContents(String xmlDocumentContents) {
        PersistableBusinessObject bo = null;
        if (!StringUtils.isEmpty((String)xmlDocumentContents)) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                org.w3c.dom.Document xmlDocument = builder.parse(new InputSource(new StringReader(xmlDocumentContents)));
                bo = this.getBusinessObjectFromXML(xmlDocumentContents, Committee.class.getName());
            }
            catch (ParserConfigurationException e) {
                LOG.error((Object)"Error while parsing document contents", (Throwable)e);
                throw new RuntimeException("Could not load document contents from xml", e);
            }
            catch (SAXException e) {
                LOG.error((Object)"Error while parsing document contents", (Throwable)e);
                throw new RuntimeException("Could not load document contents from xml", e);
            }
            catch (IOException e) {
                LOG.error((Object)"Error while parsing document contents", (Throwable)e);
                throw new RuntimeException("Could not load document contents from xml", e);
            }
        }
        return bo;
    }

    private PersistableBusinessObject populateIacucCommitteeFromXmlDocumentContents(String xmlDocumentContents) {
        PersistableBusinessObject bo = null;
        if (!StringUtils.isEmpty((String)xmlDocumentContents)) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                org.w3c.dom.Document xmlDocument = builder.parse(new InputSource(new StringReader(xmlDocumentContents)));
                bo = this.getBusinessObjectFromXML(xmlDocumentContents, IacucCommittee.class.getName());
            }
            catch (ParserConfigurationException e) {
                LOG.error((Object)"Error while parsing document contents", (Throwable)e);
                throw new RuntimeException("Could not load document contents from xml", e);
            }
            catch (SAXException e) {
                LOG.error((Object)"Error while parsing document contents", (Throwable)e);
                throw new RuntimeException("Could not load document contents from xml", e);
            }
            catch (IOException e) {
                LOG.error((Object)"Error while parsing document contents", (Throwable)e);
                throw new RuntimeException("Could not load document contents from xml", e);
            }
        }
        return bo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void streamToResponse(AttachmentDataSource attachmentDataSource, HttpServletResponse response) throws Exception {
        byte[] xbts = attachmentDataSource.getContent();
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(xbts.length);
            baos.write(xbts);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)attachmentDataSource.getContentType(), (ByteArrayOutputStream)baos, (String)attachmentDataSource.getFileName());
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
            }
            catch (IOException ioEx) {}
        }
    }

    private PersistableBusinessObject getBusinessObjectFromXML(String xmlDocumentContents, String objectTagName) {
        String objXml = StringUtils.substringBetween((String)xmlDocumentContents, (String)("<" + objectTagName + ">"), (String)("</" + objectTagName + ">"));
        objXml = "<" + objectTagName + ">" + objXml + "</" + objectTagName + ">";
        if (objXml.contains("itemDesctiption")) {
            objXml = objXml.replaceAll("itemDesctiption", "itemDescription");
        }
        PersistableBusinessObject businessObject = (PersistableBusinessObject)KRADServiceLocator.getXmlObjectSerializerService().fromXml(objXml);
        return businessObject;
    }

    private DocumentService getKraDocumentService() {
        return (DocumentService)KraServiceLocator.getService((String)"kraDocumentService");
    }

    protected ActionForward returnToSender(HttpServletRequest request, ActionMapping mapping, KualiDocumentFormBase form) {
        KraTransactionalDocumentFormBase kraForm;
        ActionForward superForward = super.returnToSender(request, mapping, form);
        if (form instanceof KraTransactionalDocumentFormBase && (kraForm = (KraTransactionalDocumentFormBase)form).isMedusaOpenedDoc()) {
            return mapping.findForward("closePage");
        }
        if (form.isReturnToActionList()) {
            GlobalVariables.getUserSession().addObject("forceHoldingForActionList", (Object)true);
            return this.routeActionListToHoldingPage(mapping, superForward);
        }
        return superForward;
    }

    private ActionForward routeActionListToHoldingPage(ActionMapping mapping, ActionForward actionForward) {
        String returnLocation = actionForward.getPath();
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, basicForward, holdingPageForward, returnLocation);
    }

    protected ActionForward routeToHoldingPage(ActionForward forward, ActionForward returnForward, ActionForward holdingPageForward, String returnLocation) {
        return this.routeToHoldingPage(Collections.singletonList(forward), returnForward, holdingPageForward, returnLocation);
    }

    protected ActionForward routeToHoldingPage(List<ActionForward> forwards, ActionForward returnForward, ActionForward holdingPageForward, String returnLocation) {
        boolean knownForward = false;
        for (ActionForward forward : forwards) {
            if (!StringUtils.equals((String)forward.getPath(), (String)returnForward.getPath())) continue;
            knownForward = true;
        }
        if (!knownForward) {
            return returnForward;
        }
        GlobalVariables.getUserSession().addObject("holdingPageMessages", (Object)KNSGlobalVariables.getMessageList());
        GlobalVariables.getUserSession().addObject("holdingPageReturnLocation", (Object)returnLocation);
        return holdingPageForward;
    }

    public ActionForward sendAdHocRequests(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KraTransactionalDocumentFormBase dform = (KraTransactionalDocumentFormBase)form;
        Document document = dform.getDocument();
        if (dform.getAdHocRoutePersons().size() > 0 || dform.getAdHocRouteWorkgroups().size() > 0) {
            document.prepareForSave();
            return super.sendAdHocRequests(mapping, (ActionForm)dform, request, response);
        }
        GlobalVariables.getMessageMap().putError("newAdHocRoutePerson.id", ONE_ADHOC_REQUIRED_ERROR_KEY, new String[0]);
        return mapping.findForward("basic");
    }

    protected static String getValidHeaderString(String s) {
        return MimeUtility.quote((String)s, (String)"()<>@,;:\\\"\t []/?=");
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase docForm = (KualiDocumentFormBase)form;
        ActionForward forward = mapping.findForward("basic");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        if (this.canSave((ActionForm)docForm)) {
            Object question = this.getQuestion(request);
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, DOCUMENT_RELOAD_QUESTION, this.getKualiConfigurationService().getPropertyValueAsString("warning.document.reload.confirmation"), "confirmationQuestion", methodToCall, "");
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if (DOCUMENT_RELOAD_QUESTION.equals(question) && "0".equals(buttonClicked)) {
                forward = super.reload(mapping, (ActionForm)docForm, request, response);
            }
        } else {
            forward = super.reload(mapping, (ActionForm)docForm, request, response);
        }
        return forward;
    }

    public ActionForward reloadWithoutWarning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.reload(mapping, form, request, response);
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.docHandler(mapping, form, request, response);
        if (form instanceof CustomDataDocumentForm) {
            ((CustomDataDocumentForm)form).getCustomDataHelper().prepareCustomData();
        }
        return forward;
    }

    public ActionForward recall(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.recall(mapping, form, request, response);
        ActionForward basicForward = mapping.findForward("basic");
        if (StringUtils.equals((String)basicForward.getPath(), (String)forward.getPath())) {
            return mapping.findForward("portal");
        }
        return forward;
    }
}

