/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.ResearchAreaCurrentReferencerHolderBase;
import org.kuali.kra.service.ResearchAreasServiceBase;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.web.struts.form.ResearchAreasFormBase;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ResearchAreasActionBase
extends KualiAction {
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("portal");
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("portal");
    }

    private void setResearchAreas(ActionForm form) {
        block24: {
            ResearchAreasFormBase researchAreaForm = (ResearchAreasFormBase)form;
            ResearchAreasServiceBase researchAreaService = this.getResearchAreasService();
            if (StringUtils.isNotBlank((String)researchAreaForm.getAddRA()) && researchAreaForm.getAddRA().equals("Y")) {
                if (researchAreaService.isResearchAreaExist(researchAreaForm.getResearchAreaCode(), researchAreaForm.getDeletedRas())) {
                    researchAreaForm.setResearchAreas("<h3>true</h3>");
                } else {
                    researchAreaForm.setResearchAreas("<h3>false</h3>");
                }
            } else if (StringUtils.isNotBlank((String)researchAreaForm.getAddRA()) && researchAreaForm.getAddRA().equals("S")) {
                try {
                    researchAreaService.saveResearchAreas(researchAreaForm.getSqlScripts());
                    String error = (String)GlobalVariables.getUserSession().retrieveObject("raError");
                    if (StringUtils.isNotBlank((String)error)) {
                        researchAreaForm.setResearchAreas("<h3>" + error + "</h3>");
                        GlobalVariables.getUserSession().addObject("raError", (Object)null);
                        break block24;
                    }
                    researchAreaForm.setResearchAreas("<h3>Success</h3>");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (StringUtils.isNotBlank((String)researchAreaForm.getAddRA()) && researchAreaForm.getAddRA().equals("A")) {
                researchAreaForm.setResearchAreas(researchAreaService.getSubResearchAreasForTreeView(researchAreaForm.getResearchAreaCode(), true));
            } else if (StringUtils.isNotBlank((String)researchAreaForm.getAddRA()) && researchAreaForm.getAddRA().equals("I")) {
                try {
                    String researchAreaCode = researchAreaForm.getResearchAreaCode();
                    ResearchAreaCurrentReferencerHolderBase referenceHolder = researchAreaService.getAnyCurrentReferencerForResearchAreaOrDescendant(researchAreaCode);
                    if (referenceHolder != ResearchAreaCurrentReferencerHolderBase.NO_REFERENCER) {
                        researchAreaForm.setResearchAreas("<h3>" + referenceHolder.getMessage() + "</h3>");
                        GlobalVariables.getUserSession().addObject("raError", (Object)null);
                        break block24;
                    }
                    researchAreaService.deactivateResearchAreaAndDescendants(researchAreaCode);
                    String error = (String)GlobalVariables.getUserSession().retrieveObject("raError");
                    if (StringUtils.isNotBlank((String)error)) {
                        researchAreaForm.setResearchAreas("<h3>" + error + "</h3>");
                        GlobalVariables.getUserSession().addObject("raError", (Object)null);
                        break block24;
                    }
                    researchAreaForm.setResearchAreas("<h3>Success</h3>");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (StringUtils.isNotBlank((String)researchAreaForm.getAddRA()) && researchAreaForm.getAddRA().equals("D")) {
                try {
                    if (researchAreaService.checkResearchAreaAndDescendantsNotReferenced(researchAreaForm.getResearchAreaCode())) {
                        researchAreaService.deleteResearchAreaAndDescendants(researchAreaForm.getResearchAreaCode());
                        String error = (String)GlobalVariables.getUserSession().retrieveObject("raError");
                        if (StringUtils.isNotBlank((String)error)) {
                            researchAreaForm.setResearchAreas("<h3>" + error + "</h3>");
                            GlobalVariables.getUserSession().addObject("raError", (Object)null);
                        } else {
                            researchAreaForm.setResearchAreas("<h3>Success</h3>");
                        }
                        break block24;
                    }
                    researchAreaForm.setResearchAreas("<h3>Research area or descendants are (were) being referenced in a current (past) version of committee, committee member or protocol</h3>");
                    GlobalVariables.getUserSession().addObject("raError", (Object)null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                researchAreaForm.setResearchAreas(researchAreaService.getSubResearchAreasForTreeView(researchAreaForm.getResearchAreaCode(), false));
            }
        }
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResearchAreasFormBase researchAreaForm = (ResearchAreasFormBase)form;
        ActionForward forward = super.execute(mapping, form, request, response);
        this.setResearchAreas(form);
        this.canMaintainResearchArea(researchAreaForm);
        return forward;
    }

    private void canMaintainResearchArea(ResearchAreasFormBase researchAreaForm) {
        ApplicationTask task = new ApplicationTask(this.getResearchAreasTask());
        researchAreaForm.setAuthorizedToMaintainResearchAreas(this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task));
    }

    private String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected abstract ResearchAreasServiceBase getResearchAreasService();

    protected abstract String getResearchAreasTask();
}

