/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.struts.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.SponsorHierarchy;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.SponsorHierarchyRule;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.UnitAuthorizationService;
import org.kuali.kra.web.struts.form.SponsorHierarchyForm;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class SponsorHierarchyAction
extends KualiAction {
    private static final String MAINT = "maint";
    private static final String NEW = "new";
    private static final String LOOKUP = "lookup";
    private static final String HIERARCHY_NAME = "hierarchyName";
    private static final String SELECTED_HIERARCHY_NAME = "selectedHierarchyName";
    private UnitAuthorizationService unitAuthorizationService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Modify Sponsor Hierarchy")) {
            SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
            ActionForward forward = super.execute(mapping, form, request, response);
            if (StringUtils.isNotBlank((String)request.getParameter("mapKey"))) {
                ((List)sponsorHierarchyForm.getNewSponsors().get(0)).clear();
            }
            sponsorHierarchyForm.setTopSponsorHierarchies(((SponsorService)KraServiceLocator.getService(SponsorService.class)).getTopSponsorHierarchy());
            sponsorHierarchyForm.setHierarchyNameList(((SponsorService)KraServiceLocator.getService(SponsorService.class)).getTopSponsorHierarchyList());
            return forward;
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Open Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward copy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Add Sponsor Hierarchy")) {
            SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
            sponsorHierarchyForm.setHierarchyName(sponsorHierarchyForm.getSelectedSponsorHierarchy());
            return mapping.findForward("copy");
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Copy Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward deleteSponsorHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Delete Sponsor Hierarchy")) {
            ((SponsorService)KraServiceLocator.getService(SponsorService.class)).deleteSponsorHierarchy((SponsorHierarchyForm)form);
            ((SponsorHierarchyForm)form).setHierarchyNameList(((SponsorService)KraServiceLocator.getService(SponsorService.class)).getTopSponsorHierarchyList());
            ((SponsorHierarchyForm)form).setMessage("Sponsor Hierarchy was deleted successfully");
            return mapping.findForward("basic");
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Delete Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward copySponsorHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Add Sponsor Hierarchy")) {
            boolean rulePassed = new SponsorHierarchyRule().newHierarchyNameRequired((SponsorHierarchyForm)form);
            if (rulePassed) {
                ((SponsorService)KraServiceLocator.getService(SponsorService.class)).copySponsorHierarchy((SponsorHierarchyForm)form);
                ((SponsorHierarchyForm)form).setTopSponsorHierarchies(((SponsorService)KraServiceLocator.getService(SponsorService.class)).getTopSponsorHierarchy());
                ((SponsorHierarchyForm)form).setMessage("Sponsor Hierarchy was copied successfully");
            }
            return mapping.findForward("basic");
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Copy Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward cancelSponsorHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward forward = new ActionForward("/portal.do??methodToCall=refresh&selectedTab=portalMaintenanceBody");
        ((SponsorService)KraServiceLocator.getService(SponsorService.class)).clearCurrentActions();
        forward.setRedirect(true);
        return forward;
    }

    public ActionForward cancelSponsorHierarchyMaint(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
        sponsorHierarchyForm.setSponsorCodeList("");
        sponsorHierarchyForm.setNewHierarchyName("");
        sponsorHierarchyForm.setSelectedSponsorHierarchy("");
        ((SponsorService)KraServiceLocator.getService(SponsorService.class)).clearCurrentActions();
        GlobalVariables.getUserSession().removeObject(SELECTED_HIERARCHY_NAME);
        GlobalVariables.getUserSession().removeObject(HIERARCHY_NAME);
        GlobalVariables.getUserSession().removeObject(sponsorHierarchyForm.getTimestamp());
        return mapping.findForward("basic");
    }

    public ActionForward saveSponsorHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Modify Sponsor Hierarchy")) {
            ((SponsorService)KraServiceLocator.getService(SponsorService.class)).executeActions();
            SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
            sponsorHierarchyForm.setActionSelected(MAINT);
            sponsorHierarchyForm.setSponsorCodeList(((SponsorService)KraServiceLocator.getService(SponsorService.class)).loadToSponsorHierachyMt(sponsorHierarchyForm.getSelectedSponsorHierarchy()));
            GlobalVariables.getUserSession().removeObject(SELECTED_HIERARCHY_NAME);
            GlobalVariables.getUserSession().removeObject(sponsorHierarchyForm.getTimestamp());
            GlobalVariables.getUserSession().removeObject("sponsorCodes");
            sponsorHierarchyForm.setTimestamp(((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).getCurrentTimestamp().toString());
            return mapping.findForward(MAINT);
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Save Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward newSponsorHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Add Sponsor Hierarchy")) {
            boolean rulePassed = new SponsorHierarchyRule().newHierarchyNameRequired((SponsorHierarchyForm)form);
            if (rulePassed) {
                ((SponsorHierarchyForm)form).setNewSponsorHierarchy(new SponsorHierarchy());
                SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
                sponsorHierarchyForm.setHierarchyName(sponsorHierarchyForm.getNewHierarchyName());
                sponsorHierarchyForm.setSponsorCodeList("");
                sponsorHierarchyForm.setTimestamp(((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).getCurrentTimestamp().toString());
                ((SponsorHierarchyForm)form).setActionSelected(NEW);
                ((SponsorService)KraServiceLocator.getService(SponsorService.class)).clearCurrentActions();
                GlobalVariables.getUserSession().addObject(SELECTED_HIERARCHY_NAME, (Object)sponsorHierarchyForm.getSelectedSponsorHierarchy());
                GlobalVariables.getUserSession().addObject(HIERARCHY_NAME, (Object)sponsorHierarchyForm.getHierarchyName());
                return mapping.findForward(MAINT);
            }
            return mapping.findForward("basic");
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Add Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward maintSponsorHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Modify Sponsor Hierarchy")) {
            ((SponsorHierarchyForm)form).setActionSelected(MAINT);
            SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
            sponsorHierarchyForm.setHierarchyName(sponsorHierarchyForm.getSelectedSponsorHierarchy());
            sponsorHierarchyForm.setSponsorCodeList(((SponsorService)KraServiceLocator.getService(SponsorService.class)).loadToSponsorHierachyMt(sponsorHierarchyForm.getSelectedSponsorHierarchy()));
            GlobalVariables.getUserSession().removeObject(SELECTED_HIERARCHY_NAME);
            GlobalVariables.getUserSession().addObject(HIERARCHY_NAME, (Object)sponsorHierarchyForm.getHierarchyName());
            ((SponsorService)KraServiceLocator.getService(SponsorService.class)).clearCurrentActions();
            sponsorHierarchyForm.setTimestamp(((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).getCurrentTimestamp().toString());
            return mapping.findForward(MAINT);
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Modify Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward deleteSponsorHierarchyGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
        int selectedSponsorHierarchy = this.getLineToDelete(request);
        SponsorHierarchy sh = (SponsorHierarchy)sponsorHierarchyForm.getSponsorHierarchyList().get(selectedSponsorHierarchy);
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Delete Sponsor Hierarchy")) {
            sponsorHierarchyForm.getSponsorHierarchyList().remove(selectedSponsorHierarchy);
            sponsorHierarchyForm.getNewSponsors().remove(this.getLineToDelete(request));
            return mapping.findForward(NEW);
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Delete Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
        String sponsors = "";
        if (sponsorHierarchyForm.getLookupResultsBOClassName() != null && sponsorHierarchyForm.getLookupResultsSequenceNumber() != null) {
            String lookupResultsSequenceNumber = sponsorHierarchyForm.getLookupResultsSequenceNumber();
            Class<?> lookupResultsBOClass = Class.forName(sponsorHierarchyForm.getLookupResultsBOClassName());
            LookupResultsService lookupService = (LookupResultsService)KraServiceLocator.getService(LookupResultsService.class);
            String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
            Collection rawValues = lookupService.retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, principalId);
            int idx = 0;
            String idxString = StringUtils.substringBetween((String)sponsorHierarchyForm.getLookedUpCollectionName(), (String)"[", (String)"]");
            if (StringUtils.isNotBlank((String)idxString)) {
                idx = Integer.parseInt(idxString);
            }
            ArrayList sponsorCodes = new ArrayList();
            sponsorHierarchyForm.getNewSponsors().set(0, new ArrayList());
            sponsorHierarchyForm.setSelectedSponsors("");
            for (Sponsor sponsor : rawValues) {
                if (sponsorCodes.contains(sponsor.getSponsorCode())) continue;
                ((List)sponsorHierarchyForm.getNewSponsors().get(idx)).add(sponsor);
                if (StringUtils.isBlank((String)sponsors)) {
                    sponsors = sponsor.getSponsorCode() + ":" + sponsor.getSponsorName();
                    continue;
                }
                sponsors = sponsors + ";1;" + sponsor.getSponsorCode() + ":" + sponsor.getSponsorName();
            }
            sponsorHierarchyForm.setLookupResultsSequenceNumber(null);
        }
        if (StringUtils.isNotBlank((String)sponsorHierarchyForm.getActionSelected()) && (sponsorHierarchyForm.getActionSelected().equals(MAINT) || sponsorHierarchyForm.getActionSelected().equals(NEW)) || StringUtils.isNotBlank((String)sponsors)) {
            sponsorHierarchyForm.setSelectedSponsors(sponsors);
            return mapping.findForward(LOOKUP);
        }
        return mapping.findForward(NEW);
    }

    public UnitAuthorizationService getUnitAuthorizationService() {
        if (this.unitAuthorizationService == null) {
            this.unitAuthorizationService = (UnitAuthorizationService)KraServiceLocator.getService(UnitAuthorizationService.class);
        }
        return this.unitAuthorizationService;
    }
}

