/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.struts.authorization.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.web.struts.authorization.WebAuthorizationService;
import org.kuali.kra.web.struts.authorization.WebAuthorizer;
import org.kuali.kra.web.struts.authorization.WebTaskFactory;

public class WebAuthorizationServiceImpl
implements WebAuthorizationService {
    private Set<String> webAuthorizerNames = new HashSet();
    private List<WebAuthorizer> webAuthorizers = new ArrayList();
    private TaskAuthorizationService taskAuthorizationService;

    public boolean isAuthorized(String userId, Class actionClass, String methodName, ActionForm form, HttpServletRequest request) {
        boolean isAuthorized = true;
        if (actionClass != null) {
            String classname = actionClass.getCanonicalName();
            WebAuthorizer webAuthorizer = this.getWebAuthorizer(classname);
            if (webAuthorizer == null) {
                isAuthorized = this.isAuthorized(userId, actionClass.getSuperclass(), methodName, form, request);
            } else {
                WebTaskFactory taskFactory = webAuthorizer.getTaskFactory(methodName);
                if (taskFactory == null) {
                    isAuthorized = this.isAuthorized(userId, actionClass.getSuperclass(), methodName, form, request);
                } else if (this.getTaskAuthorizationService() != null) {
                    Task task = taskFactory.createTask(form, request);
                    isAuthorized = this.getTaskAuthorizationService().isAuthorized(userId, task);
                }
            }
        }
        return isAuthorized;
    }

    protected WebAuthorizer getWebAuthorizer(String classname) {
        for (WebAuthorizer webAuthorizer : this.getWebAuthorizers()) {
            if (!StringUtils.equals((String)webAuthorizer.getClassname(), (String)classname)) continue;
            return webAuthorizer;
        }
        return null;
    }

    public List<WebAuthorizer> getWebAuthorizers() {
        if (this.webAuthorizers.isEmpty()) {
            for (String webAuthorizerName : this.webAuthorizerNames) {
                this.webAuthorizers.add(KraServiceLocator.getService((String)webAuthorizerName));
            }
        }
        return this.webAuthorizers;
    }

    public void setWebAuthorizers(List<WebAuthorizer> webAuthorizers) {
        this.webAuthorizers = webAuthorizers;
    }

    public Set<String> getWebAuthorizerNames() {
        return this.webAuthorizerNames;
    }

    public void setWebAuthorizerNames(Set<String> webAuthorizerNames) {
        this.webAuthorizerNames = webAuthorizerNames;
    }

    public TaskAuthorizationService getTaskAuthorizationService() {
        return this.taskAuthorizationService;
    }

    public void setTaskAuthorizationService(TaskAuthorizationService taskAuthorizationService) {
        this.taskAuthorizationService = taskAuthorizationService;
    }
}

