/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.struts.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.PersonEditableField;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.questionnaire.MultiQuestionableFormInterface;
import org.kuali.kra.questionnaire.QuestionableFormInterface;
import org.kuali.kra.rules.SoftError;
import org.kuali.rice.kns.web.struts.form.KualiTransactionalDocumentFormBase;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class KraTransactionalDocumentFormBase
extends KualiTransactionalDocumentFormBase {
    private static final long serialVersionUID = 1161569719154606103L;
    protected String actionName;
    protected String navigateTo;
    private boolean viewOnly;
    private boolean popupViewOnly;
    private boolean medusaOpenedDoc;
    private Map<String, Boolean> personEditableFields;
    private List<String> unitRulesMessages = new ArrayList();

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getNavigateTo() {
        return this.navigateTo;
    }

    public void setNavigateTo(String navigateTo) {
        this.navigateTo = navigateTo;
    }

    public void populate(HttpServletRequest request) {
        String validateParameter;
        super.populate(request);
        String methodToCallAttribute = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.contains((String)methodToCallAttribute, (String)"validate") && StringUtils.equals((String)"0", (String)(validateParameter = StringUtils.substringBetween((String)methodToCallAttribute, (String)".validate", (String)".")))) {
            GlobalVariables.getMessageMap().clearErrorMessages();
        }
    }

    public Map<String, Collection<SoftError>> getSoftErrors() {
        return (Map)GlobalVariables.getUserSession().retrieveObject("SOFT_ERRORS_KEY");
    }

    public void setupLockRegions() {
        String lockRegion = this.getLockRegion();
        GlobalVariables.getUserSession().addObject("ACTIVE_LOCK_REGION", (Object)lockRegion);
        boolean activeLockRegionChangedInd = this.hasActiveLockRegionChanged(this.getDocument(), lockRegion);
        GlobalVariables.getUserSession().addObject("ACTIVE_LOCK_REGION_CHANGED", (Object)activeLockRegionChangedInd);
    }

    private boolean hasActiveLockRegionChanged(Document document, String activeLockRegion) {
        if (StringUtils.isNotEmpty((String)activeLockRegion)) {
            for (PessimisticLock lock : document.getPessimisticLocks()) {
                if (lock.getLockDescriptor() == null || lock.getLockDescriptor().contains(activeLockRegion) || !lock.getOwnedByUser().getPrincipalId().equals(GlobalVariables.getUserSession().getPrincipalId())) continue;
                return true;
            }
        } else if (document.getPessimisticLocks().size() > 0) {
            return true;
        }
        return false;
    }

    protected boolean hasModifyProposalPermission(Map editMode) {
        if (editMode != null && editMode.containsKey("modifyProposal")) {
            String modifyProposalPermission = (String)editMode.get("modifyProposal");
            return ObjectUtils.isNotNull((Object)modifyProposalPermission) && "TRUE".equals(modifyProposalPermission);
        }
        return false;
    }

    protected boolean hasModifyBudgetPermission(Map editMode) {
        String modifyBudgetPermission = "";
        boolean hasModifyBudgetPermission = false;
        if (editMode != null && editMode.containsKey("modifyBudgets")) {
            modifyBudgetPermission = (String)editMode.get("modifyBudgets");
            boolean bl = hasModifyBudgetPermission = ObjectUtils.isNotNull((Object)modifyBudgetPermission) && "TRUE".equals(modifyBudgetPermission);
        }
        if (!hasModifyBudgetPermission && editMode != null && editMode.containsKey("addBudget")) {
            modifyBudgetPermission = (String)editMode.get("addBudget");
            hasModifyBudgetPermission = ObjectUtils.isNotNull((Object)modifyBudgetPermission) && "TRUE".equals(modifyBudgetPermission);
        }
        return hasModifyBudgetPermission;
    }

    protected boolean hasModifyCompletedBudgetPermission(Map editMode) {
        if (editMode != null && editMode.containsKey("modifyCompletedBudgets")) {
            String modifyBudgetPermission = (String)editMode.get("modifyCompletedBudgets");
            editMode.remove("modifyCompletedBudgets");
            return ObjectUtils.isNotNull((Object)modifyBudgetPermission) && "TRUE".equals(modifyBudgetPermission);
        }
        return false;
    }

    protected boolean hasModifyNarrativesPermission(Map editMode) {
        if (editMode != null && editMode.containsKey("addNarratives")) {
            String modifyNarrativesPermission = (String)editMode.get("addNarratives");
            return ObjectUtils.isNotNull((Object)modifyNarrativesPermission) && "TRUE".equals(modifyNarrativesPermission);
        }
        return false;
    }

    public String getHeaderDispatch() {
        return this.getDocumentActions().containsKey("canSave") ? "save" : "reload";
    }

    protected abstract String getLockRegion();

    protected abstract void setSaveDocumentControl(Map var1);

    public final boolean isViewOnly() {
        return this.viewOnly;
    }

    public final void setViewOnly(boolean viewOnly) {
        this.viewOnly = viewOnly;
    }

    public final boolean isPopupViewOnly() {
        return this.popupViewOnly;
    }

    public final void setPopupViewOnly(boolean popupViewOnly) {
        this.popupViewOnly = popupViewOnly;
    }

    public void setDocument(Document document) {
        super.setDocument(document);
        ((ResearchDocumentBase)document).setViewOnly(this.isViewOnly());
    }

    protected abstract String getDefaultDocumentTypeName();

    public boolean isMedusaOpenedDoc() {
        return this.medusaOpenedDoc;
    }

    public void setMedusaOpenedDoc(boolean medusaOpenedDoc) {
        this.medusaOpenedDoc = medusaOpenedDoc;
    }

    protected void addExtraButton(String property, String source, String altText) {
        ExtraButton newButton = new ExtraButton();
        newButton.setExtraButtonProperty(property);
        newButton.setExtraButtonSource(source);
        newButton.setExtraButtonAltText(altText);
        this.extraButtons.add(newButton);
    }

    public Map<String, Boolean> getPersonEditableFields() {
        if (this.personEditableFields == null) {
            this.populatePersonEditableFields();
        }
        return this.personEditableFields;
    }

    public void setPersonEditableFields(Map<String, Boolean> personEditableFields) {
        this.personEditableFields = personEditableFields;
    }

    public void populatePersonEditableFields() {
        BufferedLogger.debug((Object[])new Object[]{"Adding PersonEditableFields"});
        this.setPersonEditableFields(new HashMap());
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleCode", this.getModuleCode());
        Collection fields = this.getBusinessObjectService().findMatching(PersonEditableField.class, fieldValues);
        for (PersonEditableField field : fields) {
            BufferedLogger.debug((Object[])new Object[]{"found field " + field.getFieldName()});
            this.getPersonEditableFields().put(field.getFieldName(), field.isActive());
        }
    }

    private BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    public String getModuleCode() {
        return "0";
    }

    protected void populateFalseCheckboxes(HttpServletRequest request) {
        String[] checkboxesToResetFields;
        Map parameterMap = request.getParameterMap();
        String checkBoxToResetFieldParam = "checkboxToReset";
        if (parameterMap.get("checkboxToReset") != null && (checkboxesToResetFields = request.getParameterValues("checkboxToReset")) != null && checkboxesToResetFields.length > 0) {
            for (int i = 0; i < checkboxesToResetFields.length; ++i) {
                String propertyName = checkboxesToResetFields[i];
                if (!StringUtils.isBlank((String)propertyName) && parameterMap.get(propertyName) == null) {
                    if (this instanceof QuestionableFormInterface && (StringUtils.startsWithIgnoreCase((String)propertyName, (String)((QuestionableFormInterface)this).getQuestionnaireFieldStarter()) && StringUtils.containsIgnoreCase((String)propertyName, (String)((QuestionableFormInterface)this).getQuestionnaireFieldMiddle()) && StringUtils.endsWithIgnoreCase((String)propertyName, (String)((QuestionableFormInterface)this).getQuestionnaireFieldEnd()) || propertyName.matches(((QuestionableFormInterface)this).getQuestionnaireExpression()))) {
                        this.populateForProperty(propertyName, null, parameterMap);
                        continue;
                    }
                    if (this instanceof MultiQuestionableFormInterface) {
                        this.processMultiQuestionCheckBox(propertyName, parameterMap, (MultiQuestionableFormInterface)this);
                        continue;
                    }
                    this.populateForProperty(propertyName, (Object)"No", parameterMap);
                    continue;
                }
                if (StringUtils.isBlank((String)propertyName) || parameterMap.get(propertyName) == null || ((String[])parameterMap.get(propertyName)).length < 1 || !((String[])parameterMap.get(propertyName))[0].equalsIgnoreCase("on")) continue;
                this.populateForProperty(propertyName, (Object)"Yes", parameterMap);
            }
        }
    }

    protected void processMultiQuestionCheckBox(String propertyName, Map<String, String[]> parameterMap, MultiQuestionableFormInterface form) {
        boolean checkBoxFound = false;
        int j = 0;
        for (String starter : form.getQuestionnaireFieldStarters()) {
            if (!checkBoxFound && StringUtils.startsWithIgnoreCase((String)propertyName, (String)starter) && StringUtils.containsIgnoreCase((String)propertyName, (String)form.getQuestionnaireFieldEnds()[j]) && StringUtils.endsWithIgnoreCase((String)propertyName, (String)form.getQuestionnaireFieldEnds()[j])) {
                this.populateForProperty(propertyName, null, parameterMap);
                checkBoxFound = true;
                break;
            }
            ++j;
        }
        if (!checkBoxFound) {
            this.populateForProperty(propertyName, (Object)"No", parameterMap);
        }
    }

    public List<String> getUnitRulesMessages() {
        return this.unitRulesMessages;
    }

    public void setUnitRulesMessages(List<String> unitRulesMessages) {
        this.unitRulesMessages = unitRulesMessages;
    }

    public boolean isUnitRulesErrorsExist() {
        return this.getUnitRulesErrors().size() > 0;
    }

    public boolean isUnitRulesWarningsExist() {
        return this.getUnitRulesWarnings().size() > 0;
    }

    public List<String> getUnitRulesErrors() {
        return this.getUnitRulesMessages("E");
    }

    public List<String> getUnitRulesWarnings() {
        return this.getUnitRulesMessages("W");
    }

    public void clearUnitRulesMessages() {
        this.unitRulesMessages = Collections.emptyList();
    }

    protected List<String> getUnitRulesMessages(String messageType) {
        ArrayList<String> messages = new ArrayList<String>();
        for (String message : this.unitRulesMessages) {
            if (!StringUtils.substringBefore((String)message, (String)":").equals(messageType)) continue;
            messages.add(StringUtils.substringAfter((String)message, (String)":"));
        }
        return messages;
    }
}

