/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolOnlineReviewDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private ProtocolOnlineReviewService protocolOnlineReviewService;
    private BusinessObjectService businessObjectService;
    private RoleService roleManagementService;
    protected List<String> requiredAttributes = new ArrayList();

    public ProtocolOnlineReviewDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("protocol");
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        String qualificationSubmissionId = qualification.get("submissionId");
        String qualificationReviewId = qualification.get("protocolOnlineReviewId");
        String protocolLeadUnitNumber = qualification.get("protocolLeadUnitNumber");
        if (NumberUtils.isNumber((String)qualificationSubmissionId) && NumberUtils.isNumber((String)qualificationReviewId)) {
            Long submissionId = Long.parseLong(qualificationSubmissionId);
            Long reviewId = Long.parseLong(qualificationReviewId);
            for (ProtocolOnlineReviewBase pReview : this.getProtocolOnlineReviewService().getProtocolReviews(submissionId)) {
                if (pReview.getProtocolReviewer().getNonEmployeeFlag() || !reviewId.equals(pReview.getProtocolOnlineReviewId())) continue;
                pReview.refresh();
                members.add(RoleMembership.Builder.create(null, null, (String)pReview.getProtocolReviewer().getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
            List adminMembers = this.getIRBAdmins(protocolLeadUnitNumber);
            for (RoleMembership member : adminMembers) {
                members.add(RoleMembership.Builder.create(null, null, (String)member.getMemberId(), (MemberType)member.getType(), null).build());
            }
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        String protocolNumber = qualification.get("protocol");
        List reviews = this.getProtocolOnlineReviewService().getProtocolReviews(protocolNumber);
        for (ProtocolOnlineReviewBase review : reviews) {
            if (review.getProtocolReviewer().getNonEmployeeFlag() || !StringUtils.equals((String)review.getProtocolReviewer().getPersonId(), (String)principalId)) continue;
            return true;
        }
        return false;
    }

    public void setProtocolOnlineReviewService(ProtocolOnlineReviewService protocolOnlineReviewService) {
        this.protocolOnlineReviewService = protocolOnlineReviewService;
    }

    public ProtocolOnlineReviewService getProtocolOnlineReviewService() {
        return this.protocolOnlineReviewService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public List<String> getQualifiersForExactMatch() {
        ArrayList<String> quals = new ArrayList<String>();
        quals.add("protocol");
        quals.add("protocolOnlineReview");
        return quals;
    }

    private List<RoleMembership> getIRBAdmins(String leadUnitNumber) {
        ArrayList<String> roleIds = new ArrayList<String>();
        String roleId = this.getRoleService().getRoleIdByNamespaceCodeAndName("KC-UNT", "IRB Administrator");
        roleIds.add(roleId);
        HashMap<String, String> attrSet = new HashMap<String, String>();
        attrSet.put("unitNumber", leadUnitNumber);
        return this.getRoleService().getRoleMembers(roleIds, attrSet);
    }

    private RoleService getRoleService() {
        return this.roleManagementService;
    }

    public void setRoleManagementService(RoleService roleManagementService) {
        this.roleManagementService = roleManagementService;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

