<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="'PDF'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="even-page-master" margin-left="0.2in" margin-right="0.2in" page-height="11in" page-width="8.5in">
				<fo:region-body margin-top="0.5in" margin-bottom="0.5in"/>
				<fo:region-before region-name="even-page-header" extent="0.5in"/>
				<fo:region-after extent="0.5in"/>
			</fo:simple-page-master>
			<fo:simple-page-master master-name="odd-page-master" margin-left="0.2in" margin-right="0.2in" page-height="11in" page-width="8.5in">
				<fo:region-body margin-top="0.5in" margin-bottom="0.5in"/>
				<fo:region-before region-name="odd-page-header" extent="0.5in"/>
				<fo:region-after extent="0.5in"/>
			</fo:simple-page-master>
			<fo:page-sequence-master master-name="default-page">
				<fo:repeatable-page-master-alternatives>
					<fo:conditional-page-master-reference master-reference="odd-page-master" odd-or-even="odd"/>
					<fo:conditional-page-master-reference master-reference="even-page-master" odd-or-even="even"/>
				</fo:repeatable-page-master-alternatives>
			</fo:page-sequence-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerodd"/>
				<xsl:call-template name="headereven"/>
				<xsl:call-template name="footerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell margin="0" padding="0" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
													<fo:table-column column-width="80%"/>
													<fo:table-column column-width="20%"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell border-top-width="2pt" padding-bottom="0" padding-top="0" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline font-size="11pt" font-weight="bold">
																		<xsl:text>SUBCONTRACTING REPORT FOR INDIVIDUAL CONTRACTS</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-top-width="2pt" padding-bottom="1pt" padding-top="1pt" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>OMB No.: </xsl:text>
																			</fo:inline>
																			<fo:inline font-weight="bold">
																				<xsl:text>9000-0006</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:text>Expires:&#160;&#160;&#160; 11/30/2007</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-bottom-style="none" padding-bottom="0" number-columns-spanned="2" border="solid 1pt gray" padding="2pt" text-align="left" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>Public reporting burden for this collection of information is estimated to average 55.34 hours per response, including the time for
reviewing instructions, searching existing data sources, gathering and maintaining the data needed, and completing and reviewing
the collection of information. Send comments regarding this burden estimate or any other aspect of this collection of information,
including suggestions for reducing this burden, to the FAR Secretariat (VIR), Regulatory and Federal Assistance Division, GSA, Washington, DC
20405.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border-bottom-style="none" border-top-style="none" padding="0" padding-bottom="0" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
													<fo:table-column column-width="30%"/>
													<fo:table-column column-width="15%"/>
													<fo:table-column column-width="10%"/>
													<fo:table-column column-width="30%"/>
													<fo:table-column column-width="15%"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell border-top-style="none" padding-top="1pt" number-columns-spanned="3" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>1. CORPORATION, COMPANY OR SUBDIVISION COVERED</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-bottom-width="0" border-top-style="none" padding-bottom="0" padding-top="1pt" number-columns-spanned="2" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>3. DATE SUBMITTED</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-bottom="0" padding-top="0" number-columns-spanned="3" border="solid 1pt gray" padding="2pt" text-align="left" display-align="center">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>a. COMPANY NAME</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="CompanyInfo">
																			<xsl:for-each select="NameAndAddressType">
																				<xsl:for-each select="Name">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-top-style="none" font-weight="bold" number-columns-spanned="2" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="DateSubmitted">
																			<fo:inline font-weight="bold">
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-bottom="0" padding-top="0" number-columns-spanned="3" number-rows-spanned="2" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline padding-top="0">
																				<xsl:text>b. STREET ADDRESS</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="CompanyInfo">
																			<xsl:for-each select="NameAndAddressType">
																				<xsl:for-each select="StreetAddress">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-top="5pt" number-columns-spanned="2" border="solid 1pt gray" padding="2pt" text-align="center" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>4. REPORTING PERIOD FROM INCEPTION OF CONTRACT THRU:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell number-rows-spanned="2" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="ReportingPeriod">
																			<xsl:for-each select="isMarchReport">
																				<xsl:choose>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='1'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160; MAR 31 </xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="ReportingPeriod">
																			<xsl:for-each select="isSeptReport">
																				<fo:inline>
																					<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																				</fo:inline>
																				<xsl:choose>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='1'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160; SEPT&#160; 30</xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-bottom="0" padding-top="0" number-rows-spanned="2" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>YEAR&#160; </xsl:text>
																	</fo:inline>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="FiscalYearReportStart">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block font-weight="bold">
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline font-weight="bold">
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-bottom="0" padding-top="0" number-rows-spanned="2" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>c. CITY</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="CompanyInfo">
																			<xsl:for-each select="NameAndAddressType">
																				<xsl:for-each select="City">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-bottom="0" padding-top="0" number-rows-spanned="2" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>d. STATE</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="CompanyInfo">
																			<xsl:for-each select="NameAndAddressType">
																				<xsl:for-each select="State">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-bottom="0" padding-top="0" number-rows-spanned="2" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>e. ZIP CODE</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="CompanyInfo">
																			<xsl:for-each select="NameAndAddressType">
																				<xsl:for-each select="ZipCode">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-bottom="0" padding-top="1pt" number-columns-spanned="2" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>5. TYPE OF REPORT</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-bottom="0" padding-top="0" number-columns-spanned="3" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>2. CONTRACTOR IDENTIFICATION NUMBER</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="ContractorIDNumber">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block font-weight="bold">
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline font-weight="bold">
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-bottom="0" padding-top="0" number-columns-spanned="2" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="ReportingPeriod">
																			<xsl:for-each select="ReportType">
																				<xsl:choose>
																					<xsl:when test="string(.)='REG'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='1'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>&#160; REGULAR&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																	</fo:inline>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="ReportingPeriod">
																			<xsl:for-each select="ReportType">
																				<xsl:choose>
																					<xsl:when test="string(.)='FIN'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='1'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>&#160; FINAL&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																	</fo:inline>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="ReportingPeriod">
																			<xsl:for-each select="ReportType">
																				<xsl:choose>
																					<xsl:when test="string(.)='REV'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='1'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>&#160; REVISED</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-bottom-style="none" border-style="none" height="0" margin="0" padding="0" border="solid 1pt gray" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell border-bottom-style="none" border-style="none" height="0" margin="0" padding="0" border="solid 1pt gray" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell border-bottom-style="none" border-style="none" height="0" margin="0" padding="0" border="solid 1pt gray" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell border-bottom-style="none" border-style="none" height="0" margin="0" padding="0" border="solid 1pt gray" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell border-bottom-style="none" border-style="none" height="0" margin="0" padding="0" border="solid 1pt gray" display-align="center">
																<fo:block/>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border-bottom-style="none" border-top-style="none" padding="0" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
													<fo:table-column column-width="25%"/>
													<fo:table-column column-width="40%"/>
													<fo:table-column column-width="35%"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell border-top-style="none" padding-top="0" number-columns-spanned="3" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>6. ADMINISTERING ACTIVITY (Please check applicable box)</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="AdministeringActivity">
																				<xsl:choose>
																					<xsl:when test="string(.)='ARMY'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='1'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>ARMY</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="AdministeringActivity">
																				<xsl:choose>
																					<xsl:when test="string(.)='GSA'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='1'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>GSA</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="AdministeringActivity">
																				<xsl:choose>
																					<xsl:when test="string(.)='NASA'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='1'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>NASA</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="AdministeringActivity">
																				<xsl:choose>
																					<xsl:when test="string(.)='NAVY'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='1'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>NAVY</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="AdministeringActivity">
																				<xsl:choose>
																					<xsl:when test="string(.)='DOE'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='1'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>DOE</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-rows-spanned="2" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<xsl:for-each select="SubcontractReports">
																				<xsl:for-each select="SubcontractReportPage">
																					<xsl:for-each select="AdministeringActivity">
																						<xsl:choose>
																							<xsl:when test="string(.)='OTHER'">
																								<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																									<xsl:text>&#x2714;</xsl:text>
																								</fo:inline>
																							</xsl:when>
																							<xsl:when test="string(.)='true'">
																								<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																									<xsl:text>&#x2714;</xsl:text>
																								</fo:inline>
																							</xsl:when>
																							<xsl:when test="string(.)='1'">
																								<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																									<xsl:text>&#x2714;</xsl:text>
																								</fo:inline>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline border="solid 1pt black">
																									<fo:leader leader-length="10pt" leader-pattern="space"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																			<fo:inline>
																				<xsl:text>OTHER FEDERAL AGENCY (Specify)</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="Sponsor">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="AdministeringActivity">
																				<xsl:choose>
																					<xsl:when test="string(.)='AIR FORCE'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='1'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>AIR FORCE </xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="AdministeringActivity">
																				<xsl:choose>
																					<xsl:when test="string(.)='DEFENSE LOGISTICS AGENCY'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='1'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>DEFENSE CONTRACT MANAGEMENT AGENCY</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border-bottom-style="none" border-top-style="none" padding="0" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
													<fo:table-column column-width="30%"/>
													<fo:table-column column-width="28%"/>
													<fo:table-column column-width="22%"/>
													<fo:table-column column-width="10%"/>
													<fo:table-column column-width="10%"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell border-top-style="none" padding-top="0" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>7. REPORT SUBMITTED AS (Check one)</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-top-style="none" padding-top="0" number-columns-spanned="4" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>8. AGENCY OR CONTRACTOR AWARDING CONTRACT</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-bottom="0" padding-top="0" number-rows-spanned="2" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<xsl:for-each select="SubcontractReports">
																				<xsl:for-each select="ContractorType">
																					<xsl:for-each select="isPrime">
																						<xsl:choose>
																							<xsl:when test="string(.)='true'">
																								<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																									<xsl:text>&#x2714;</xsl:text>
																								</fo:inline>
																							</xsl:when>
																							<xsl:when test="string(.)='1'">
																								<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																									<xsl:text>&#x2714;</xsl:text>
																								</fo:inline>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline border="solid 1pt black">
																									<fo:leader leader-length="10pt" leader-pattern="space"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																						<fo:inline>
																							<xsl:text>&#160; </xsl:text>
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																			<fo:inline>
																				<xsl:text>PRIME CONTRACTOR</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="ContractorType">
																			<xsl:for-each select="isSub">
																				<xsl:choose>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='1'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160; </xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>SUBCONTRACTOR</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-bottom="0" padding-top="0" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>PRIME CONTRACT NUMBER</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="ContractorType">
																			<xsl:for-each select="PrimeContractNumber">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-bottom="0" padding-top="0" number-columns-spanned="3" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>a. AGENCY&apos;S OR CONTRACTOR&apos;S NAME</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="AwardingAgencyName">
																				<xsl:for-each select="NameAndAddressType">
																					<xsl:for-each select="Name">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block font-weight="bold">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-weight="bold">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>SUBCONTRACT NUMBER</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-bottom="0" padding-top="0" number-columns-spanned="3" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>b. STREET ADDRESS</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="AwardingAgencyName">
																				<xsl:for-each select="NameAndAddressType">
																					<xsl:for-each select="StreetAddress">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block font-weight="bold">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-weight="bold">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-bottom="0" padding-top="0" number-columns-spanned="2" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>9. DOLLARS AND PERCENTAGES IN THE FOLLOWING BLOCKS: </xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="IncludeIndirectCosts">
																			<xsl:choose>
																				<xsl:when test="string(.)='true'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="string(.)='1'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline border="solid 1pt black">
																						<fo:leader leader-length="10pt" leader-pattern="space"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																			<fo:inline>
																				<xsl:text>&#160; </xsl:text>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>DO INCLUDE INDIRECT COSTS&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																	</fo:inline>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="IncludeIndirectCosts">
																			<xsl:choose>
																				<xsl:when test="string(.)='false'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="string(.)='1'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline border="solid 1pt black">
																						<fo:leader leader-length="10pt" leader-pattern="space"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																			<fo:inline>
																				<xsl:text>&#160; </xsl:text>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																	<fo:inline>
																		<xsl:text>DO NOT INCLUDE INDIRECT COSTS</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-bottom="0" padding-top="0" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>c. CITY </xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="AwardingAgencyName">
																				<xsl:for-each select="NameAndAddressType">
																					<xsl:for-each select="City">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block font-weight="bold">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-weight="bold">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-bottom="0" padding-top="0" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>d. STATE </xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="AwardingAgencyName">
																				<xsl:for-each select="NameAndAddressType">
																					<xsl:for-each select="State">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block font-weight="bold">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-weight="bold">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-bottom="0" padding-top="0" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>e. ZIP CODE</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="AwardingAgencyName">
																				<xsl:for-each select="NameAndAddressType">
																					<xsl:for-each select="ZipCode">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block font-weight="bold">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-weight="bold">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-style="none" height="0" padding="0" border="solid 1pt gray" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell border-style="none" height="0" padding="0" border="solid 1pt gray" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell border-style="none" height="0" padding="0" border="solid 1pt gray" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell border-style="none" height="0" padding="0" border="solid 1pt gray" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell border-style="none" height="0" padding="0" border="solid 1pt gray" display-align="center">
																<fo:block/>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border-bottom-style="none" border-top-style="none" padding="0" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
													<fo:table-column column-width="18%"/>
													<fo:table-column column-width="9.5%"/>
													<fo:table-column column-width="18%"/>
													<fo:table-column column-width="9.5%"/>
													<fo:table-column column-width="18%"/>
													<fo:table-column column-width="9.5%"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell border-top-style="none" number-columns-spanned="6" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>SUBCONTRACT AWARDS</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell number-columns-spanned="2" number-rows-spanned="2" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>TYPE</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>CURRENT GOAL</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>ACTUAL CUMULATIVE</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>WHOLE DOLLARS</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>PERCENT</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>WHOLE DOLLARS</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>PERCENT</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-right-style="none" padding-right="0" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>10a.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-left-style="none" padding-left="0" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>SMALL BUSINESS CONCERNS (Include SDB, WOSB,
HBCU/MI, HUBZone SB, and VOSB (Including
Service-Disabled VOSB)) (Dollar Amount and Percent
of 10c)</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalAmount">
																					<xsl:if test="../TypeOfVendor = &apos;SMALL BUSINESS&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalPercent">
																					<xsl:if test="../TypeOfVendor = &apos;SMALL BUSINESS&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualAmount">
																					<xsl:if test="../TypeOfVendor =&apos;SMALL BUSINESS&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualPercent">
																					<xsl:if test="../TypeOfVendor =&apos;SMALL BUSINESS&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-right-style="none" padding-right="0" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>10b.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-left-style="none" padding-left="0" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>LARGE BUSINESS CONCERNS (Dollar Amount and
Percent of 10c.)
</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalAmount">
																					<xsl:if test="../TypeOfVendor = &apos;LARGE BUSINESS&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="gray" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualAmount">
																					<xsl:if test="../TypeOfVendor =&apos;LARGE BUSINESS&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualPercent">
																					<xsl:if test="../TypeOfVendor =&apos;LARGE BUSINESS&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-right-style="none" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>10c.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-left-style="none" padding-left="0" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>TOTAL (Sum of 10a and 10b.)</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:if test="SubcontractReports/SubcontractReportPage/VendorType/GoalAmount[ ../TypeOfVendor =&apos;SMALL BUSINESS&apos;] !=0 and  
SubcontractReports/SubcontractReportPage/VendorType/GoalAmount[../TypeOfVendor =&apos;LARGE BUSINESS&apos;]  != 0">
																		<fo:inline>
																			<xsl:text>$</xsl:text>
																		</fo:inline>
																		<fo:inline>
																			<xsl:value-of select="format-number(number(SubcontractReports/SubcontractReportPage/VendorType/GoalAmount[ ../TypeOfVendor =&apos;SMALL BUSINESS&apos;] +  
SubcontractReports/SubcontractReportPage/VendorType/GoalAmount[../TypeOfVendor =&apos;LARGE BUSINESS&apos;]), '#,###,###,##0.00')"/>
																		</fo:inline>
																	</xsl:if>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>100.00%</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:if test="SubcontractReports/SubcontractReportPage/VendorType/ActualAmount[ ../TypeOfVendor =&apos;SMALL BUSINESS&apos;] !=0 and 
SubcontractReports/SubcontractReportPage/VendorType/ActualAmount[../TypeOfVendor =&apos;LARGE BUSINESS&apos;] != 0">
																		<fo:inline>
																			<xsl:text>$</xsl:text>
																		</fo:inline>
																		<fo:inline>
																			<xsl:value-of select="format-number(number(SubcontractReports/SubcontractReportPage/VendorType/ActualAmount[ ../TypeOfVendor =&apos;SMALL BUSINESS&apos;] +  
SubcontractReports/SubcontractReportPage/VendorType/ActualAmount[../TypeOfVendor =&apos;LARGE BUSINESS&apos;]), '#,###,###,##0.00')"/>
																		</fo:inline>
																	</xsl:if>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>100.00%</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-right-style="none" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>11.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-left-style="none" padding-left="0" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>SMALL DISADVANTAGED BUSINESS (SDB) CONCERNS
 (Dollar Amount and Percent of 10c.)
</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalAmount">
																					<xsl:if test="../TypeOfVendor =&apos;DISADVANTAGED BUSINESS&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalPercent">
																					<xsl:if test="../TypeOfVendor = &apos;DISADVANTAGED BUSINESS&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualAmount">
																					<xsl:if test="../TypeOfVendor =&apos;DISADVANTAGED BUSINESS&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualPercent">
																					<xsl:if test="../TypeOfVendor =&apos;DISADVANTAGED BUSINESS&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-right-style="none" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>12.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-left-style="none" padding-left="0" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>WOMEN-OWNED SMALL BUSINESS (WOSB) CONCERNS
(Dollar Amount and Percent of 10c.)
</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalAmount">
																					<xsl:if test="../TypeOfVendor = &apos;WOMAN OWNED&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalPercent">
																					<xsl:if test="../TypeOfVendor =  &apos;WOMAN OWNED&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualAmount">
																					<xsl:if test="../TypeOfVendor = &apos;WOMAN OWNED&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualPercent">
																					<xsl:if test="../TypeOfVendor = &apos;WOMAN OWNED&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-right-style="none" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>13.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-left-style="none" padding-left="0" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>HISTORICALLY BLACK COLLEGES AND UNIVERSITIES
(HBCU) AND MINORITY INSTITUTIONS (MI) (If applicable)
(Dollar Amount and Percent of 10c.)
</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalAmount">
																					<xsl:if test="../TypeOfVendor = &apos;HBCU&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalPercent">
																					<xsl:if test="../TypeOfVendor = &apos;HBCU&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualAmount">
																					<xsl:if test="../TypeOfVendor =&apos;HBCU&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualPercent">
																					<xsl:if test="../TypeOfVendor =&apos;HBCU&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-right-style="none" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>14.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-left-style="none" padding-left="0" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>HUBZone SMALL BUSINESS (HUBZone SB) CONCERNS
(Dollar Amount and Percent of 10c.
</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalAmount">
																					<xsl:if test="../TypeOfVendor = &apos;HUB&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalPercent">
																					<xsl:if test="../TypeOfVendor = &apos;HUB&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualAmount">
																					<xsl:if test="../TypeOfVendor =&apos;HUB&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualPercent">
																					<xsl:if test="../TypeOfVendor =&apos;HUB&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-right-style="none" border="solid 1pt gray" padding="2pt" height="5" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>15.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-left-style="none" padding-left="0" border="solid 1pt gray" padding="2pt" height="5" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>VETERAN-OWNED SMALL BUSINESS CONCERNS

(Dollar Amount and Percent of 10c.)
</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" height="5" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalAmount">
																					<xsl:if test="../TypeOfVendor = &apos;VET&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" height="5" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalPercent">
																					<xsl:if test="../TypeOfVendor = &apos;VET&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" height="5" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualAmount">
																					<xsl:if test="../TypeOfVendor =&apos;VET&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" height="5" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualPercent">
																					<xsl:if test="../TypeOfVendor =&apos;VET&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-right-style="none" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>16.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-left-style="none" padding-left="0" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>SERVICE-DISABLED VETERAN-OWNED SMALL
BUSINESS CONCERNS (Dollar Amount and Percent
of10c.)</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalAmount">
																					<xsl:if test="../TypeOfVendor = &apos;SDVO&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="GoalPercent">
																					<xsl:if test="../TypeOfVendor = &apos;SDVO&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualAmount">
																					<xsl:if test="../TypeOfVendor =&apos;SDVO&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="VendorType">
																				<xsl:for-each select="ActualPercent">
																					<xsl:if test="../TypeOfVendor =&apos;SDVO&apos;">
																						<xsl:if test=". != 0">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																							</fo:inline>
																							<fo:inline>
																								<xsl:text>%</xsl:text>
																							</fo:inline>
																						</xsl:if>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-right-style="none" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>17.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-left-style="none" padding-left="0" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>ALASKA NATIVE CORPORATIONS (ANCs) AND INDIAN TRIBES THAT HAVE NOT BEEN CERTIFIED BY THE SMALL BUSINESS ADMINISTRATION AS SMALL DISADVANTAGED BUSINESSES (Dollar Amount)</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="gray" border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell background-color="gray" border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell background-color="gray" border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block/>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-right-style="none" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>18.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-left-style="none" padding-left="0" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>
ALASKA NATIVE CORPORATIONS (ANCs) AND INDIAN TRIBES THAT ARE NOT SMALL BUSINESSES (Dollar Amount)</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="gray" border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell background-color="gray" border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell background-color="gray" border="solid 1pt gray" padding="2pt" text-align="right" display-align="center">
																<fo:block/>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-bottom-style="none" border-bottom-width="0" border-left-style="none" border-left-width="0" border-right-style="none" border-right-width="0" border-style="none" border-width="0" padding-bottom="1pt" padding-top="2pt" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:block break-after="page">
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-bottom-style="none" border-bottom-width="0" border-left-style="none" border-left-width="0" border-right-style="none" border-right-width="0" border-style="none" padding-bottom="1pt" padding-left="0" padding-top="2pt" number-columns-spanned="5" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block/>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-right-style="none" padding-bottom="1pt" padding-top="2pt" border="solid 1pt gray" padding="2pt" height="525" display-align="before">
																<fo:block>
																	<fo:inline>
																		<xsl:text>19.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-left-style="none" padding-bottom="1pt" padding-left="0" padding-top="2pt" number-columns-spanned="5" border="solid 1pt gray" padding="2pt" height="525" display-align="before">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>REMARKS</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<fo:inline>
																		<xsl:text>&#160; </xsl:text>
																	</fo:inline>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="SubcontractReportPage">
																			<xsl:for-each select="Remarks">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-bottom-width="2pt" padding-bottom="0" padding-top="0" number-columns-spanned="3" number-rows-spanned="2" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block border-bottom-width="2pt" padding-bottom="0" margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>20a.NAME OF INDIVIDUAL ADMINISTERING SUBCONTRACTING PLAN</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="AdministeringOfficial">
																			<xsl:for-each select="Name">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-bottom="1pt" padding-top="1pt" number-columns-spanned="3" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>20b. TELEPHONE NUMBER</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-bottom-width="2pt" padding-bottom="0" padding-top="0" border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block border-bottom-width="2pt" padding-bottom="0" margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>AREA CODE</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="AdministeringOfficial">
																			<xsl:for-each select="PhoneAreaCode">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-bottom-width="2pt" padding-bottom="0" padding-top="0" number-columns-spanned="2" border="solid 1pt gray" padding="2pt" display-align="before">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block border-bottom-width="2pt" padding-bottom="0" margin="0pt">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>NUMBER</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:block>
																	<xsl:for-each select="SubcontractReports">
																		<xsl:for-each select="AdministeringOfficial">
																			<xsl:for-each select="PhoneNumber">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerodd">
		<fo:static-content flow-name="odd-page-header">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block>
										<fo:block text-align="center">
											<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
										</fo:block>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="headereven">
		<fo:static-content flow-name="even-page-header">
			<fo:block/>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="footerall">
		<fo:static-content flow-name="xsl-region-after">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-family="Verdana" font-size="7pt" line-height="5pt" padding="0" text-align="left" display-align="before">
									<fo:block>
										<fo:block>
											<fo:leader leader-pattern="space"/>
										</fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block line-height="5pt" margin="0pt">
											<fo:block>
												<fo:inline>
													<xsl:text>AUTHORIZED FOR LOCAL REPRODUCTION</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:block>
										<fo:inline>
											<xsl:text>Previous edition is not usable</xsl:text>
										</fo:inline>
										<fo:inline>
											<xsl:text>&#160;</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Verdana" font-size="7pt" line-height="5pt" padding="0" text-align="right" display-align="center">
									<fo:block>
										<fo:block>
											<fo:leader leader-pattern="space"/>
										</fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block line-height="5pt" margin="0pt">
											<fo:block>
												<fo:inline font-size="9pt" font-weight="bold">
													<xsl:text>STANDARD FORM 294 </xsl:text>
												</fo:inline>
												<fo:inline>
													<xsl:text>(REV. 9/2007)&#160; </xsl:text>
												</fo:inline>
											</fo:block>
										</fo:block>
										<fo:inline>
											<xsl:text>Prescribed by GSA-FAR (48 CFR) 53.219(a)&#160; </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
