<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="'PDF'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="8.5in" page-width="11in" margin-left="1.65in" margin-right="0.79in">
				<fo:region-body margin-top="1.5in" margin-bottom="1.2in"/>
				<fo:region-before extent="1.5in"/>
				<fo:region-after extent="1.2in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<xsl:call-template name="footerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:block/>
						<xsl:for-each select="$XML">
							<fo:block/>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block text-align="center" margin="0pt">
								<fo:block>
									<xsl:for-each select="n1:Protocol">
										<xsl:for-each select="n1:SchoolInfo">
											<xsl:for-each select="n1:SchoolName">
												<xsl:variable name="value-of-template">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template),'&#x2029;')">
														<fo:block font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:copy-of select="$value-of-template"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:copy-of select="$value-of-template"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</fo:block>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block text-align="center" margin="0pt">
								<fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Protocol Summary</xsl:text>
									</fo:inline>
								</fo:block>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:block/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="20%"/>
								<fo:table-column column-width="80%"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row font-family="Arial" font-size="10pt">
										<fo:table-cell font-weight="bold" padding="2pt" text-align="left" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Protocol Number:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:ProtocolMasterData">
														<xsl:for-each select="n1:ProtocolNumber">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row font-family="Arial" font-size="10pt">
										<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Sequence Number:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:ProtocolMasterData">
														<xsl:for-each select="n1:SequenceNumber">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row font-family="Arial" font-size="10pt">
										<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Status:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:ProtocolMasterData">
														<xsl:for-each select="n1:ProtocolStatusDesc">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row font-family="Arial" font-size="10pt">
										<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Expiration Date:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:ProtocolMasterData">
														<xsl:for-each select="n1:ExpirationDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
															</fo:inline>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row font-family="Arial" font-size="10pt">
										<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Last Approval Date:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:ProtocolMasterData">
														<xsl:for-each select="n1:ApprovalDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
															</fo:inline>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row font-family="Arial" font-size="10pt">
										<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Investigator:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:ProtocolMasterData">
														<xsl:for-each select="n1:PrincipleInvestigatorName">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:ProtocolDetailsRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:block/>
								<xsl:for-each select="n1:Protocol">
									<xsl:for-each select="n1:ProtocolMasterData">
										<fo:block/>
										<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
											<xsl:text>Protocol Details </xsl:text>
										</fo:inline>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="20%"/>
											<fo:table-column column-width="80%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Protocol Type:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="9pt" font-weight="normal" margin-left="-10pt" padding="2pt" text-align="left" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>&#160;&#160;&#160; </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:ProtocolTypeDesc">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Project Type:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="9pt" font-weight="normal" margin-left="-10pt" padding="2pt" text-align="left" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>&#160;&#160;&#160; </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:ProjectTypeDesc">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Description:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="9pt" font-weight="normal" margin-left="-10pt" padding="2pt" text-align="left" display-align="center">
														<fo:block>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:ProtocolDescription">
																		<fo:inline>
																			<xsl:text>&#160;&#160;&#160; </xsl:text>
																		</fo:inline>
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Application Date:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="9pt" font-weight="normal" margin-left="-10pt" padding="2pt" text-align="left" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>&#160;&#160;&#160; </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:ApplicationDate">
																<fo:inline>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Reference Num 1:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="9pt" font-weight="normal" margin-left="-10pt" padding="2pt" text-align="left" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>&#160;&#160;&#160; </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:RefNumber1">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Reference Num 2:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="9pt" font-weight="normal" margin-left="-10pt" padding="2pt" text-align="left" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>&#160;&#160;&#160; </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:RefNumber2">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Lay Statement 1:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="2pt" text-align="left" display-align="center">
														<fo:block>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:LayStatement1">
																		<fo:inline>
																			<xsl:text>&#160;</xsl:text>
																		</fo:inline>
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Lay Statement 2:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="2pt" text-align="left" display-align="center">
														<fo:block>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:LayStatement2">
																		<fo:inline>
																			<xsl:text>&#160;</xsl:text>
																		</fo:inline>
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Title:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="2pt" text-align="left" display-align="before">
														<fo:block>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:ProtocolTitle">
																		<fo:inline>
																			<xsl:text>&#160;</xsl:text>
																		</fo:inline>
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:OrganizationRequired  = 1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:Organization  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Organizations</xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:Organization">
										<fo:table font-family="Arial" font-size="9pt" font-weight="normal" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="50%"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
													<fo:table-cell font-family="Arial" font-weight="bold" border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Type</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-weight="bold" border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Organization</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-weight="bold" border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Address</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:Organization">
														<fo:table-row font-family="Arial" font-size="9pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:OrgTypeDesc">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:OrgName">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:Address">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																	<fo:block/>
																	<fo:inline font-weight="bold">
																		<xsl:text>Animal Welfare Assurance #:</xsl:text>
																	</fo:inline>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																	<xsl:for-each select="n1:AnimalWelfareAssurance">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:InvestigatorsRequired  = 1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:Investigator  )  &gt;0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Investigators</xsl:text>
									</fo:inline>
									<fo:inline font-family="Arial" font-size="10pt">
										<xsl:text>&#160;</xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:Investigator">
										<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="45%"/>
											<fo:table-column column-width="15%"/>
											<fo:table-column column-width="15%"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Person Name</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Units</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Affiliate</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Training Flag</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:Investigator">
														<fo:table-row font-family="Arial" font-size="9pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																			<xsl:if test="../../n1:PIFlag = &apos;true&apos;">
																				<fo:inline>
																					<xsl:text>(PI)</xsl:text>
																				</fo:inline>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<xsl:if test="n1:Unit">
																		<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
																			<fo:table-column column-width="20%"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-header start-indent="0pt">
																				<fo:table-row>
																					<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																						<fo:block/>
																					</fo:table-cell>
																				</fo:table-row>
																			</fo:table-header>
																			<fo:table-body start-indent="0pt">
																				<xsl:for-each select="n1:Unit">
																					<fo:table-row>
																						<fo:table-cell padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="n1:UnitNumber">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="n1:UnitName">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																									<xsl:if test="../n1:LeadUnitFlag = &apos;true&apos;">
																										<fo:inline>
																											<xsl:text>(LU)</xsl:text>
																										</fo:inline>
																									</xsl:if>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</xsl:for-each>
																			</fo:table-body>
																		</fo:table>
																	</xsl:if>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:AffiliationDesc">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:TrainingFlag">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:KeyPersonsRequired  = 1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:KeyStudyPerson  )  &gt;0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Study Personnel</xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:KeyStudyPerson">
										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="25%"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
																<xsl:text>PersonName</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
																<xsl:text>Title</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Affiliation</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Training</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:KeyStudyPerson">
														<fo:table-row font-family="Arial" font-size="9pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:Role">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:Affiliation">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:TrainingFlag">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:CorrespondentsRequired  = 1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:Correspondent  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Correspondents </xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:Correspondent">
										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="50%"/>
											<fo:table-column column-width="50%"/>											
											<fo:table-header start-indent="0pt">
												<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Person</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Comments</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:Correspondent">
														<fo:table-row font-family="Arial" font-size="9pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																		<fo:block>
																			<xsl:for-each select="n1:Comments">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:block>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:ResearchAreasRequired  = 1">
								<xsl:if test="count(  n1:Protocol/n1:ResearchArea  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Areas of Research </xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:ResearchArea">
										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Code</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
																<xsl:text>Description</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:ResearchArea">
														<fo:table-row font-family="Arial" font-size="9pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:ResearchAreaCode">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																		<fo:block>
																			<xsl:for-each select="n1:ResearchAreaDescription">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:block>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:FundingSourcesRequired  = 1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:FundingSource  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Funding Source</xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:FundingSource">
										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="50%"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Type</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Number/Code</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Name/Title</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:FundingSource">
														<fo:table-row font-family="Arial" font-size="9pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:TypeOfFundingSource">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:FundingSource">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																		<fo:block>
																			<xsl:for-each select="n1:FundingSourceName">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:block>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:SpeciesGroupRequired = 1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:Species  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Species / Groups</xsl:text>
									</fo:inline>
									<fo:block/>
									<xsl:for-each select="n1:Protocol">
										<xsl:for-each select="n1:Species">
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
												<fo:table-column column-width="21%"/>
												<fo:table-column column-width="proportional-column-width(1)"/>
												<fo:table-body start-indent="0pt">
													<fo:table-row>
														<fo:table-cell font-weight="bold" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Group:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:SpeciesGroup">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-weight="bold" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Species:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:SpeciesDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-weight="bold" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Species Strain:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:Strain">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-weight="bold" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Pain Category:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:PainCategoryDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-weight="bold" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>USDA Covered Type:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:IsUsdaCovered">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-weight="bold" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Count Type :</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:CountTypeDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-weight="bold" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Count:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:SpeciesCount">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
												<fo:block></fo:block>
											</fo:inline-container>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<fo:block>
							   <xsl:if test="count(n1:Protocol/n1:Species)  &gt; 0">
								<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:ExceptionsRequired = 1">
									<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
												<fo:table-column column-width="5%"/>
												<fo:table-column column-width="proportional-column-width(1)"/>
												<fo:table-body start-indent="0pt">
													<fo:table-row font-weight="bold">
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:if test="count(n1:Protocol/n1:Species/n1:Exception)  &gt; 0">
																	<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
																		<xsl:text>Exceptions</xsl:text>
																	</fo:inline>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<xsl:if test="n1:Protocol/n1:Species/n1:Exception">
																	<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="25%"/>
																		<fo:table-column column-width="75%"/>
																		<fo:table-header start-indent="0pt">
																			<fo:table-row font-weight="bold">
																				<fo:table-cell font-weight="bold" border="solid 1pt gray" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Exception Category</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Description</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-header>
																		<fo:table-body start-indent="0pt">
																			<xsl:for-each select="n1:Protocol/n1:Species[1]/n1:Exception">
																				<fo:table-row>
																					<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<xsl:for-each select="n1:ExceptionCategoryDesc">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<xsl:for-each select="n1:Description">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</xsl:for-each>
																		</fo:table-body>
																	</fo:table>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</xsl:if>
								</xsl:if>
							</fo:block>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:ProceduresRequired  =1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
									<xsl:text>Procedures</xsl:text>
								</fo:inline>
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:StudyGroup  )  &gt; 0">
									<fo:block/>
									<xsl:for-each select="n1:Protocol">
										<xsl:for-each select="n1:StudyGroup">
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
												<fo:table-column column-width="20%"/>
												<fo:table-column column-width="85%"/>
												<fo:table-body start-indent="0pt">
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Group:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:SpeciesGroup">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Species:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:SpeciesDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Procedure Category:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:ProcedureCategoryDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Procedure:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:ProcedureDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Pain Category:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:PainCategoryDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Count :</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" text-align="left" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:Count">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
												<fo:table-column column-width="5%"/>
												<fo:table-column column-width="100%"/>
												<fo:table-column column-width="2%"/>
												<fo:table-body start-indent="0pt">
													<fo:table-row font-family="Arial" font-size="12pt" font-weight="bold">
														<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
															<fo:block>
																<xsl:if test="count(  n1:Location  )  &gt; 0">
																	<fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
																		<xsl:text>Locations </xsl:text>
																	</fo:inline>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<xsl:if test="n1:Location">
																	<fo:table table-layout="fixed" width="95%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="25%"/>
																		<fo:table-column column-width="25%"/>
																		<fo:table-column column-width="20%"/>
																		<fo:table-column column-width="30%"/>
																		<fo:table-header start-indent="0pt">
																			<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
																				<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Location Type</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Location Name</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Room</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Description</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-header>
																		<fo:table-body start-indent="0pt">
																			<xsl:for-each select="n1:Location">
																				<fo:table-row font-family="Arial" font-size="9pt">
																					<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<xsl:for-each select="n1:LocationTypeDesc">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<xsl:for-each select="n1:LocationName">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<fo:inline-container>
																								<fo:block>
																									<xsl:text>&#x2029;</xsl:text>
																								</fo:block>
																							</fo:inline-container>
																							<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																								<fo:block>
																									<xsl:for-each select="n1:LocationRoom">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates/>
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</fo:block>
																							</fo:block>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<fo:inline-container>
																								<fo:block>
																									<xsl:text>&#x2029;</xsl:text>
																								</fo:block>
																							</fo:inline-container>
																							<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																								<fo:block>
																									<xsl:for-each select="n1:Description">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates/>
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</fo:block>
																							</fo:block>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</xsl:for-each>
																		</fo:table-body>
																	</fo:table>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row font-family="Arial" font-size="12pt" font-weight="bold">
														<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
															<fo:block>
																<xsl:if test="count(  n1:PersonResponsible  )  &gt; 0">
																	<fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
																		<xsl:text>Persons Responsible</xsl:text>
																	</fo:inline>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row font-family="Arial" font-size="12pt" font-weight="bold">
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<xsl:if test="n1:PersonResponsible">
																	<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="47.5%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="85%"/>
																		<fo:table-column column-width="15%"/>
																		<fo:table-header start-indent="0pt">
																			<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
																				<fo:table-cell font-weight="normal" border="solid 1pt gray" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Investigators/Study Personnel</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell font-weight="normal" border="solid 1pt gray" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Trained</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-header>
																		<fo:table-body start-indent="0pt">
																			<xsl:for-each select="n1:PersonResponsible">
																				<fo:table-row>
																					<fo:table-cell font-weight="normal" border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<xsl:for-each select="n1:InvestigatorKeyPerson">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell font-weight="normal" border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<xsl:for-each select="n1:PersonTrainedFlag">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</xsl:for-each>
																		</fo:table-body>
																	</fo:table>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row font-family="Arial" font-size="12pt" font-weight="bold">
														<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
															<fo:block>
																<xsl:if test="count(  n1:CustomData  ) &gt;0">
																	<fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
																		<xsl:text>Others</xsl:text>
																	</fo:inline>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<xsl:if test="n1:CustomData">
																	<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
																		<fo:table-column column-width="40%"/>
																		<fo:table-column column-width="60%"/>
																		<fo:table-body start-indent="0pt">
																			<xsl:for-each select="n1:CustomData">
																				<fo:table-row>
																					<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="n1:ColumnName">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																								<fo:inline>
																									<xsl:text>:</xsl:text>
																								</fo:inline>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="n1:ColumnValue">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</xsl:for-each>
																		</fo:table-body>
																	</fo:table>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block margin="0pt">
												<fo:block/>
											</fo:block>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:if>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="20%"/>
									<fo:table-column column-width="proportional-column-width(1)"/>
									<fo:table-body start-indent="0pt">
										<fo:table-row>
											<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:text>Overview and Timeline:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block>
													<xsl:for-each select="n1:Protocol">
														<xsl:for-each select="n1:ProtocolMasterData">
															<xsl:for-each select="n1:OverviewTimeline">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:PrinciplesRequired =1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:Principles  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Three R's</xsl:text>
									</fo:inline>
									<fo:block/>
									<xsl:for-each select="n1:Protocol">
										<xsl:for-each select="n1:Principles">
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
												<fo:table-column column-width="20%"/>
												<fo:table-column column-width="80%"/>
												<fo:table-body start-indent="0pt">
													<fo:table-row font-family="Arial" font-size="9pt" font-weight="normal">
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Principles of Reduction:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:ReductionPrinciple">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Principles of Refinement: </xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:RefinementPrinciple">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Principles of Replacement: </xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:ReplacementPrinciple">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:AlternativeSearchesRequired =1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:AlternateDbSearch  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Alternative Searches</xsl:text>
									</fo:inline>
									<fo:block/>
									<xsl:for-each select="n1:Protocol">
										<xsl:for-each select="n1:AlternateDbSearch">
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
												<fo:table-column column-width="20%"/>
												<fo:table-column column-width="proportional-column-width(1)"/>
												<fo:table-body start-indent="0pt">
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Search Date:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:SearchDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																	</fo:inline>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Database Searched:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="n1:DatabasDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Years Searched: </xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" display-align="center">
															<fo:block>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																	<fo:block>
																		<xsl:for-each select="n1:YearsSearched">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:block>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Keywords Searched:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" display-align="center">
															<fo:block>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																	<fo:block>
																		<xsl:for-each select="n1:KeywordsSearched">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:block>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Comments:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" display-align="center">
															<fo:block>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																	<fo:block>
																		<xsl:for-each select="n1:Comments">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:block>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block margin="0pt">
												<fo:block/>
											</fo:block>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:ActionsRequired  =1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:Actions  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Actions</xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:Actions">
										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Description</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Comments</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Action Date</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:Actions">
														<fo:table-row font-family="Arial" font-size="9pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:ActionTypeDesc">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																		<fo:block>
																			<xsl:for-each select="n1:Comments">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:block>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:ActionDate">
																		<fo:inline>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																		</fo:inline>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:DocumentsRequired  = 1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:Documents  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>New/Changed Attachments</xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:Documents">
										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Description</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Last Updated</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Updated By</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:Documents">
														<fo:table-row font-family="Arial" font-size="9pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:DocumentTypeDesc">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:UpdateTimestamp">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:UpdateUser">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:SpecialReviewRequired =1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:SpecialReview  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Special Review </xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:SpecialReview">
										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
													<fo:table-cell border="solid 1pt gray" padding="0" height="18" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Special Review</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" height="18" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Approval</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" height="18" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Protocol No</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" height="18" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Application Date</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" height="18" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Approval Date</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" height="18" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Comments</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:SpecialReview">
														<fo:table-row font-family="Arial" font-size="9pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:SpecialReviewTypeDesc">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:SpecialReviewApprovalTypeDesc">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:SpecialReviewProtocolNumber">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:SpecialReviewApplicationDate">
																		<fo:inline>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																		</fo:inline>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:SpecialReviewApprovalDate">
																		<fo:inline>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																		</fo:inline>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																		<fo:block>
																			<xsl:for-each select="n1:SpecialReviewComments">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:block>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:NotesRequired = 1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:Notes  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Protocol Notes</xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:Notes">
										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Comment</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>By</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Time </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:Notes">
														<fo:table-row font-family="Arial" font-size="9pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																		<fo:block>
																			<xsl:for-each select="n1:Comments">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:block>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:UpdateUser">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:UpdateTimestamp">
																		<fo:inline>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																		</fo:inline>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
								<fo:inline font-family="Arial" font-size="10pt">
									<xsl:text>&#160;</xsl:text>
								</fo:inline>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:UserRolesRequired =1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:UserRoles  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Roles</xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:UserRoles">
										<fo:table table-layout="fixed" width="100%" border-spacing="0">
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row>
													<fo:table-cell number-columns-spanned="4" padding="0" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:UserRoles">
														<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
															<fo:table-cell number-columns-spanned="4" padding="0" display-align="center">
																<fo:block>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block margin="0pt">
																		<fo:block/>
																	</fo:block>
																	<xsl:choose>
																		<xsl:when test="string-length(  n1:UserRoles  )  = 0"/>
																		<xsl:otherwise>
																			<xsl:for-each select="n1:RoleName">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<xsl:if test="n1:UserRoles">
																		<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-header start-indent="0pt">
																				<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
																					<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<fo:inline>
																								<xsl:text>User Id</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<fo:inline>
																								<xsl:text>Unit Name</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<fo:inline>
																								<xsl:text>User Name</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</fo:table-header>
																			<fo:table-body start-indent="0pt">
																				<xsl:for-each select="n1:UserRoles">
																					<fo:table-row font-family="Arial" font-size="9pt" font-weight="normal">
																						<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																							<fo:block>
																								<xsl:for-each select="n1:UserId">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																							<fo:block>
																								<xsl:for-each select="n1:UnitName">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																							<fo:block>
																								<xsl:for-each select="n1:UserName">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</xsl:for-each>
																			</fo:table-body>
																		</fo:table>
																	</xsl:if>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:ReferencesRequired  =1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:References  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Reference List </xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:References">
										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Reference Type</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Reference Number</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Application Date</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Approval Date</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Comments</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:References">
														<fo:table-row font-family="Arial" font-size="9pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:ReferenceTypeDesc">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:ReferenceNumber">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:ApplicationDate">
																		<fo:inline>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																		</fo:inline>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:ApprovalDate">
																		<fo:inline>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																		</fo:inline>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																		<fo:block>
																			<xsl:for-each select="n1:Comments">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:block>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:AmendRenewSRequired =1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:AmenRenewal  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Amendment/Renewal</xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:AmenRenewal">
										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="30%"/>
											<fo:table-column column-width="6%"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Type</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Version</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Status</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Created Date</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Summary</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:AmenRenewal">
														<fo:table-row font-family="Arial" font-size="9pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:AmendmentType">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:Version">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:ProtocolStatusDesc">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:DateCreated">
																		<fo:inline>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																		</fo:inline>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:Summary">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:AmendRenewModulesRequired  = 1">
								<fo:block/>
								<xsl:if test="count(  n1:Protocol/n1:AmendRenewSummary  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Amendment/Renewal Summary</xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:AmendRenewSummary">
										<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row font-weight="bold">
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Summary</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Editable Modules</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:AmendRenewSummary">
														<fo:table-row>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																		<fo:block>
																			<xsl:for-each select="n1:Summary">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:block>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:ProtocolModules">
																		<xsl:for-each select="n1:ProtocolModuleDesc">
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:list-block provisional-distance-between-starts="7mm" provisional-label-separation="2mm">
																				<fo:list-item>
																					<fo:list-item-label end-indent="label-end()" text-align="right">
																						<fo:block/>
																					</fo:list-item-label>
																					<fo:list-item-body start-indent="body-start()">
																						<fo:block/>
																					</fo:list-item-body>
																				</fo:list-item>
																			</fo:list-block>
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="n1:Protocol/n1:PrintRequirement/n1:OtherDataRequired  = 1">
								<xsl:if test="count(  n1:Protocol/n1:OthersData  )  &gt; 0">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block padding-top="10pt" margin="0pt">
										<fo:block>
											<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
												<xsl:text>&#160;</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Others </xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Protocol/n1:OthersData">
										<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="40%"/>
											<fo:table-column column-width="60%"/>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="n1:Protocol">
													<xsl:for-each select="n1:OthersData">
														<fo:table-row>
															<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:ColumnName">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																		<fo:inline>
																			<xsl:text>:</xsl:text>
																		</fo:inline>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="n1:ColumnValue">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
						</xsl:for-each>
						<fo:block/>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="15%"/>
						<fo:table-column column-width="30%"/>
						<fo:table-column column-width="40%"/>
						<fo:table-column column-width="15%"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" padding-bottom="0" number-columns-spanned="4" height="18" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" padding-bottom="0" number-columns-spanned="4" height="18" display-align="center">
									<fo:block>
										<xsl:for-each select="n1:Protocol">
											<xsl:for-each select="n1:SchoolInfo">
												<xsl:for-each select="n1:Acronym">
													<xsl:variable name="value-of-template">
														<xsl:apply-templates/>
													</xsl:variable>
													<xsl:choose>
														<xsl:when test="contains(string($value-of-template),'&#x2029;')">
															<fo:block>
																<xsl:copy-of select="$value-of-template"/>
															</fo:block>
														</xsl:when>
														<xsl:otherwise>
															<fo:inline>
																<xsl:copy-of select="$value-of-template"/>
															</fo:inline>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding-bottom="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<fo:inline font-family="Arial" font-size="9pt" font-weight="bold">
											<xsl:text> Protocol Number: </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Arial" padding-bottom="0" padding-left="0" padding-top="1pt" padding="2pt" text-align="left" display-align="after">
									<fo:block>
										<xsl:for-each select="n1:Protocol">
											<xsl:for-each select="n1:ProtocolMasterData">
												<xsl:for-each select="n1:ProtocolNumber">
													<xsl:variable name="value-of-template">
														<xsl:apply-templates/>
													</xsl:variable>
													<xsl:choose>
														<xsl:when test="contains(string($value-of-template),'&#x2029;')">
															<fo:block>
																<xsl:copy-of select="$value-of-template"/>
															</fo:block>
														</xsl:when>
														<xsl:otherwise>
															<fo:inline>
																<xsl:copy-of select="$value-of-template"/>
															</fo:inline>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-size="9pt" font-weight="bold" padding-bottom="0" padding-right="5pt" padding="2pt" text-align="right" display-align="before">
									<fo:block>
										<fo:inline font-family="Arial" font-size="9pt" font-weight="bold">
											<xsl:text>Expiration Date: </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-size="9pt" padding-bottom="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<xsl:for-each select="n1:Protocol">
											<xsl:for-each select="n1:ProtocolMasterData">
												<xsl:for-each select="n1:ExpirationDate">
													<fo:inline>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
														<xsl:text>/</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
														<xsl:text>/</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
													</fo:inline>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-weight="bold" padding-top="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<fo:inline font-family="Arial" font-size="9pt" font-weight="bold">
											<xsl:text>Investigator:</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Arial" padding-left="0" padding-top="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<xsl:for-each select="n1:Protocol">
											<xsl:for-each select="n1:ProtocolMasterData">
												<xsl:for-each select="n1:PrincipleInvestigatorName">
													<xsl:variable name="value-of-template">
														<xsl:apply-templates/>
													</xsl:variable>
													<xsl:choose>
														<xsl:when test="contains(string($value-of-template),'&#x2029;')">
															<fo:block>
																<xsl:copy-of select="$value-of-template"/>
															</fo:block>
														</xsl:when>
														<xsl:otherwise>
															<fo:inline>
																<xsl:copy-of select="$value-of-template"/>
															</fo:inline>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-weight="bold" padding-right="6pt" padding-top="0" padding="2pt" text-align="right" display-align="before">
									<fo:block>
										<fo:inline font-family="Arial" font-size="9pt" font-weight="bold">
											<xsl:text>Last Approval Date:</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-size="9pt" padding-top="0" padding="2pt" display-align="after">
									<fo:block>
										<xsl:for-each select="n1:Protocol">
											<xsl:for-each select="n1:ProtocolMasterData">
												<xsl:for-each select="n1:ApprovalDate">
													<fo:inline>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
														<xsl:text>/</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
														<xsl:text>/</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
													</fo:inline>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-family="Verdana" font-size="9pt" padding="0" padding-top="0" number-columns-spanned="4" text-align="left" display-align="before">
									<fo:block>
										<fo:block text-align="center">
											<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
										</fo:block>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="footerall">
		<fo:static-content flow-name="xsl-region-after">
			<fo:block>
				<fo:inline-container>
					<fo:block>
						<xsl:text>&#x2029;</xsl:text>
					</fo:block>
				</fo:inline-container>
				<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-column column-width="150"/>
					<fo:table-body start-indent="0pt">
						<fo:table-row>
							<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
								<fo:block/>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
								<fo:block>
									<fo:block text-align="center">
										<fo:leader top="-37pt" leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
									</fo:block>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell font-size="10pt" padding="0" text-align="left" display-align="center">
								<fo:block/>
							</fo:table-cell>
							<fo:table-cell font-family="Arial" font-size="9pt" padding="0" text-align="right" display-align="center">
								<fo:block>
									<fo:inline font-family="Arial" font-size="9pt" font-weight="bold">
										<xsl:text>Page: </xsl:text>
									</fo:inline>
									<fo:page-number font-weight="bold"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
