<%--
 Copyright 2005-2013 The Kuali Foundation

 Licensed under the Educational Community License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.osedu.org/licenses/ECL-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
--%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>

<%@ attribute name="innerTabParent" description="Inner Tab Parent Name" required="true" %>
<%@ attribute name="budgetPeriod" description="Budget Period" required="true" %>
<%@ attribute name="budgetLineItemNumber" description="Budget Line Item Number" required="true" %>
<%@ attribute name="budgetCategoryTypeCode" description="Budget Category Type Codes" required="true" %>
<%@ attribute name="budgetLineItemSequenceNumber" description="Budget Line Item Sequence For Display" required="true" %>
<%@ attribute name="budgetExpensePanelReadOnly" description="Budget Expense Panel Read Only" required="true" %>

<c:set var="budgetPeriodBO" value="${KualiForm.document.budget.budgetPeriods[budgetPeriod - 1]}"/>
<c:set var="budgetLineItem" value="${budgetPeriodBO.budgetLineItems[budgetLineItemNumber]}"/>
<c:set var="budgetLineItemAttributes" value="${DataDictionary.BudgetLineItem.attributes}" />
<c:set var="awardBudgetLineItemAttributes" value="${DataDictionary.AwardBudgetLineItemExt.attributes}" />
<c:set var="action" value="budgetExpensesAction" />
<c:set var="textAreaFieldNameLineItemDescription" value="document.budget.budgetPeriods[${budgetPeriod - 1}].budgetLineItems[${budgetLineItemNumber}].lineItemDescription" />
<bean:define id="proposalBudgetFlag" name="KualiForm" property="document.proposalBudgetFlag"/>
<c:choose>
	<c:when test="${proposalBudgetFlag}" >
		<c:set var="lineItemCostAttribute" value="${budgetLineItemAttributes}" />
	</c:when>
	<c:otherwise>
		<c:set var="lineItemCostAttribute" value="${awardBudgetLineItemAttributes}" />
	</c:otherwise>
</c:choose>

<c:set var="budgetExpensePanelReadOnly" value="${budgetExpensePanelReadOnly || budgetLineItem.subAwardLineItem}" />

<c:set var="budgetExpensePanelReadOnlyIfBudgetVersionIsFinal" value="${budgetExpensePanelReadOnly}" />
<c:if test="${budgetCategoryTypeCode == 'P' and fn:length(budgetLineItem.budgetPersonnelDetailsList) > 0}" >
	<c:set var="budgetExpensePanelReadOnly" value="true" />
</c:if>

<jsp:useBean id="paramMap" class="java.util.HashMap"/>
<c:set target="${paramMap}" property="budgetCategoryTypeCode" value="${budgetCategoryTypeCode}" />

<c:choose>
	<c:when test="${empty KualiForm.viewBudgetView || KualiForm.viewBudgetView == 0}" >
		<c:set var="rowSpanCount" value="2" />	
	</c:when>
	<c:otherwise>
		<c:set var="rowSpanCount" value="1" />
	</c:otherwise>
</c:choose>
<tr>
    <th width="6%" rowspan="${rowSpanCount}" class="darkInfoline">
		<c:out value="${budgetLineItemSequenceNumber+1}" />
	</th>	
    <td  width="38%" valign="middle" nowrap="true" >
		<div align="center">
			<c:set var="costElementOptions" value="" />
			<c:forEach items="${krafn:getOptionList('org.kuali.kra.budget.lookup.keyvalue.CostElementValuesFinder', paramMap)}" var="option">
				<c:choose>
					<c:when test="${budgetLineItem.costElement == option.key}">
						<c:set var="costElementOptions" value="${costElementOptions}${'<option value=\"'}${option.key}${'\" selected=\"selected\">'}${option.value}${'</option>'}" />
						<c:set var="selectedCostElement" value="${option.value}" />								
					</c:when>
					<c:otherwise>
						<c:set var="costElementOptions" value="${costElementOptions}${'<option value=\"'}${option.key}${'\" >'}${option.value}${'</option>'}" />
					</c:otherwise>
				</c:choose>
			</c:forEach> 
		
			<c:if test="${empty selectedCostElement}" >
				<c:set var="selectedCostElement" value="${budgetLineItem.costElementName}" /> 
			</c:if>
						
    	   	<c:out value="${selectedCostElement}"/>
			<input type="hidden" name="document.budget.budgetCategoryTypeLineItem[${budgetLineItemNumber}]" value="${budgetCategoryTypeCode}">
			<input type="hidden" name="document.budget.budgetPeriods[${budgetPeriod - 1}].budgetLineItems[${budgetLineItemNumber}].costElement" value="${budgetLineItem.costElement}"/>
			<kul:directInquiry boClassName="org.kuali.kra.budget.core.CostElement" inquiryParameters="document.budget.budgetPeriods[${budgetPeriod - 1}].budgetLineItems[${budgetLineItemNumber}].costElement:costElement" anchor="${tabKey}"/>	
		</div>
		<div id="costElementCode.div" align="center" class="fineprint">
			<bean:write name="KualiForm" property="document.budget.budgetPeriods[${budgetPeriod - 1}].budgetLineItems[${budgetLineItemNumber}].costElement" />&nbsp;
		</div>				
	</td>
	<c:set var="textAreaFieldNameLineItemDescription" value="document.budget.budgetPeriods[${budgetPeriod - 1}].budgetLineItems[${budgetLineItemNumber}].lineItemDescription" />
	<td width="25%" valign="middle" >
		<div align=center>
       		<kul:htmlControlAttribute property="document.budget.budgetPeriod[${budgetPeriod - 1}].budgetLineItem[${budgetLineItemNumber}].lineItemDescription" attributeEntry="${budgetLineItemAttributes.lineItemDescription}" readOnly="${budgetExpensePanelReadOnlyIfBudgetVersionIsFinal}"/>
		</div>
	</td>
    <td width="6%" valign="middle" >
		<div align=center>
       		<kul:htmlControlAttribute property="document.budget.budgetPeriod[${budgetPeriod - 1}].budgetLineItem[${budgetLineItemNumber}].quantity" attributeEntry="${budgetLineItemAttributes.quantity}" styleClass="text-right" readOnly="${budgetExpensePanelReadOnly}"/>
		</div>
    </td>
    <td width="16%" valign="middle" >               	
		<div align=center>
       		<kul:htmlControlAttribute property="document.budget.budgetPeriod[${budgetPeriod - 1}].budgetLineItem[${budgetLineItemNumber}].lineItemCost" attributeEntry="${lineItemCostAttribute.lineItemCost}" styleClass="amount" readOnly="${budgetExpensePanelReadOnly}"/> 
		</div>
	</td>
	<c:if test="${!proposalBudgetFlag}">
    	<td width="16%" valign="middle" >               	
			<div align=center>
       			<kul:htmlControlAttribute property="document.budget.budgetPeriod[${budgetPeriod - 1}].budgetLineItem[${budgetLineItemNumber}].obligatedAmount" attributeEntry="${awardBudgetLineItemAttributes.obligatedAmount}" styleClass="amount" readOnly="true"/> 
			</div>
		</td>
	</c:if>
	<td width="8%" valign="middle" >&nbsp;
		<div align=center>
       		<kra:section permission="modifyBudgets">
       		<c:if test="${!budgetExpensePanelReadOnly}">
				<html:image property="methodToCall.deleteBudgetLineItem.line${budgetLineItemNumber}.anchor${currentTabIndex}"
			    	src='${ConfigProperties.kra.externalizable.images.url}tinybutton-delete1.gif' styleClass="tinybutton" />
			</c:if>
			</kra:section> 
		</div>
    </td>
</tr>
<c:if test="${budgetLineItem.displayTotalDetail }">
	<tr>
            	<th colspan="4"><div align="right">Total Amount for ${budgetLineItem.costElementName }:</div></th>
            	<td><div align="center">
					<fmt:formatNumber value="${budgetLineItem.objectTotal }" type="currency" currencySymbol="" maxFractionDigits="2" />
            	</div></td>
            	<td>&nbsp;</td>
            </tr>
</c:if>
<c:choose>
	<c:when test="${empty KualiForm.viewBudgetView || KualiForm.viewBudgetView == 0}" >     
		<tr>
	    	<td colspan="7" class="darkInfoline">
	    		<c:choose>
		    		<c:when test="${budgetLineItem.formulatedCostElementFlag}">
			        	<kra-b:budgetFormulatedCostLineItem budgetPeriod = "${budgetPeriod}" budgetPeriodBO="${budgetPeriodBO}" budgetCategoryTypeCode = "${budgetCategoryTypeCode}" 
			        		budgetLineItemNumber="${budgetLineItemNumber}" budgetLineItem="${budgetLineItem}" 
			        		innerTabParent="${innerTabParent}" budgetExpensePanelReadOnly="${budgetExpensePanelReadOnly}" budgetExpensePanelReadOnlyIfBudgetVersionIsFinal="${budgetExpensePanelReadOnlyIfBudgetVersionIsFinal}"/>
		        	</c:when>
		    		<c:otherwise>
			        	<kra-b:budgetLineItemFullView budgetPeriod = "${budgetPeriod}" budgetPeriodBO="${budgetPeriodBO}" budgetCategoryTypeCode = "${budgetCategoryTypeCode}" 
			        		budgetLineItemNumber="${budgetLineItemNumber}" budgetLineItem="${budgetLineItem}" 
			        		innerTabParent="${innerTabParent}" budgetExpensePanelReadOnly="${budgetExpensePanelReadOnly}" 
			        		budgetExpensePanelReadOnlyIfBudgetVersionIsFinal="${budgetExpensePanelReadOnlyIfBudgetVersionIsFinal}"/>
		        	</c:otherwise>
	        	</c:choose>
			</td>
	    </tr>
	</c:when>
	<c:otherwise>			 
		<input type="hidden" name="document.budget.budgetPeriods[${budgetPeriod - 1}].budgetLineItems[${budgetLineItemNumber}].budgetCategoryCode" value="${budgetLineItem.budgetCategoryCode}">
	</c:otherwise>
</c:choose>
