/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.tools.ant.tasks;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.H2Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.integration.ant.AntResourceAccessor;
import liquibase.integration.ant.BaseLiquibaseTask;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.h2.tools.Backup;
import org.h2.tools.DeleteDbFiles;
import org.kualigan.tools.ant.tasks.MigrateData;
import org.kualigan.tools.ant.tasks.RdbmsConfig;
import org.kualigan.tools.liquibase.Diff;
import org.kualigan.tools.liquibase.DiffResult;

public class GenerateChangeLog
extends BaseLiquibaseTask {
    private String source;
    private String target;
    private boolean stateSaved;

    public boolean isStateSaved() {
        return this.stateSaved;
    }

    public void setStateSaved(boolean ss) {
        this.stateSaved = ss;
    }

    public void setSource(String refid) {
        this.source = refid;
    }

    public String getSource() {
        return this.source;
    }

    public void setTarget(String refid) {
        this.target = refid;
    }

    public String getTarget() {
        return this.target;
    }

    public void execute() {
        RdbmsConfig source = (RdbmsConfig)((Object)this.getProject().getReference(this.getSource()));
        RdbmsConfig target = (RdbmsConfig)((Object)this.getProject().getReference(this.getTarget()));
        Database lbSource = null;
        Database lbTarget = null;
        DatabaseFactory factory = DatabaseFactory.getInstance();
        try {
            lbSource = factory.findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(this.openConnection("source")));
            lbSource.setDefaultSchemaName(source.getSchema());
            lbTarget = factory.findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(this.openConnection("target")));
            lbTarget.setDefaultSchemaName(target.getSchema());
            this.exportSchema(lbSource, lbTarget);
            if (this.isStateSaved()) {
                this.exportData(lbSource, lbTarget);
            }
            if (lbTarget instanceof H2Database) {
                Statement st = ((JdbcConnection)lbTarget.getConnection()).createStatement();
                st.execute("SHUTDOWN DEFRAG");
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                if (lbSource != null) {
                    lbSource.close();
                }
                if (lbTarget != null) {
                    lbTarget.close();
                }
            }
            catch (Exception e) {}
        }
        if (this.isStateSaved()) {
            this.log("Starting data load from schema " + source.getSchema());
            MigrateData migrateTask = new MigrateData();
            migrateTask.bindToOwner((Task)this);
            migrateTask.init();
            migrateTask.setSource(this.getSource());
            migrateTask.setTarget("h2");
            migrateTask.execute();
            try {
                Backup.execute((String)"work/export/data.zip", (String)"work/export", (String)"", (boolean)true);
                DeleteDbFiles.execute((String)"split:22:work/export", (String)"data", (boolean)true);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    protected void exportSchema(Database source, Database target) {
        try {
            Diff diff = new Diff(source, source.getDefaultSchemaName());
            this.exportTables(diff, target);
            this.exportSequences(diff, target);
            this.exportViews(diff, target);
            this.exportIndexes(diff, target);
            this.exportConstraints(diff, target);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void export(Diff diff, Database target, String diffTypes, String suffix) {
        diff.setDiffTypes(diffTypes);
        try {
            DiffResult results = diff.compare();
            results.printChangeLog(this.getChangeLogFile() + suffix, target);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void exportConstraints(Diff diff, Database target) {
        this.export(diff, target, "foreignKeys", "-cst.xml");
    }

    protected void exportIndexes(Diff diff, Database target) {
        this.export(diff, target, "indexes", "-idx.xml");
    }

    protected void exportViews(Diff diff, Database target) {
        this.export(diff, target, "views", "-vw.xml");
    }

    protected void exportTables(Diff diff, Database target) {
        this.export(diff, target, "tables, primaryKeys, uniqueConstraints", "-tab.xml");
    }

    protected void exportSequences(Diff diff, Database target) {
        this.export(diff, target, "sequences", "-seq.xml");
    }

    private void exportData(Database source, Database target) {
        Database h2db = null;
        RdbmsConfig h2Config = new RdbmsConfig();
        h2Config.setDriver("org.h2.Driver");
        h2Config.setUrl("jdbc:h2:split:22:work/export/data");
        h2Config.setUsername("SA");
        h2Config.setPassword("");
        h2Config.setSchema("PUBLIC");
        this.getProject().addReference("h2", (Object)h2Config);
        DatabaseFactory factory = DatabaseFactory.getInstance();
        try {
            h2db = factory.findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(this.openConnection("h2")));
            h2db.setDefaultSchemaName(h2Config.getSchema());
            this.export(new Diff(source, this.getDefaultSchemaName()), h2db, "tables", "-dat.xml");
            AntResourceAccessor antFO = new AntResourceAccessor(this.getProject(), this.classpath);
            FileSystemResourceAccessor fsFO = new FileSystemResourceAccessor();
            String changeLogFile = this.getChangeLogFile() + "-dat.xml";
            Liquibase liquibase = new Liquibase(changeLogFile, (ResourceAccessor)new CompositeResourceAccessor(new ResourceAccessor[]{antFO, fsFO}), h2db);
            this.log("Loading Schema");
            liquibase.update(this.getContexts());
            this.log("Finished Loading the Schema");
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            block11: {
                try {
                    if (h2db != null) {
                        this.log("Closing h2 database");
                        h2db.close();
                    }
                }
                catch (Exception e) {
                    if (e instanceof SQLNonTransientConnectionException) break block11;
                    e.printStackTrace();
                }
            }
        }
    }

    private void debug(String msg) {
        this.log(msg, 4);
    }

    private Connection openSource() {
        return this.openConnection(this.getSource());
    }

    private Connection openTarget() {
        return this.openConnection(this.getTarget());
    }

    private Connection openConnection(String reference) {
        RdbmsConfig config = (RdbmsConfig)((Object)this.getProject().getReference(reference));
        return this.openConnection(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection openConnection(RdbmsConfig config) {
        Connection retval = null;
        int retry_count = 0;
        int max_retry = 5;
        while (retry_count < 5) {
            try {
                this.debug("Loading schema " + config.getSchema() + " at url " + config.getUrl());
                Class.forName(config.getDriver());
                retval = DriverManager.getConnection(config.getUrl(), config.getUsername(), config.getPassword());
                retval.setAutoCommit(true);
            }
            catch (Exception e) {
                if (e.getMessage().contains("Database lock acquisition failure") || e instanceof NullPointerException) continue;
                throw new BuildException((Throwable)e);
            }
            finally {
                ++retry_count;
            }
        }
        return retval;
    }
}

