/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.tools.ant.tasks;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Task;
import org.kualigan.tools.ant.tasks.RdbmsConfig;

public class MigrateData
extends Task {
    private static final String[] carr = new String[]{"|", "\\", "-", "/"};
    private static final String RECORD_COUNT_QUERY = "select count(*) as \"COUNT\" from %s";
    private static final String SELECT_ALL_QUERY = "select * from %s";
    private static final String INSERT_STATEMENT = "insert into %s (%s) values (%s)";
    private static final String DATE_CONVERSION = "TO_DATE('%s', 'YYYYMMDDHH24MISS')";
    private static final String COUNT_FIELD = "COUNT";
    private static final String LIQUIBASE_TABLE = "DATABASECHANGELOG";
    private static final int[] QUOTED_TYPES = new int[]{1, 12, 92, -1, 91, 93};
    private static final String HSQLDB_PUBLIC = "PUBLIC";
    private static final int MAX_THREADS = 3;
    private String source;
    private String target;
    private int threadCount;

    public MigrateData() {
        boolean threadCount = true;
    }

    public void setSource(String refid) {
        this.source = refid;
    }

    public String getSource() {
        return this.source;
    }

    public void setTarget(String refid) {
        this.target = refid;
    }

    public String getTarget() {
        return this.target;
    }

    public void execute() {
        RdbmsConfig source = (RdbmsConfig)((Object)this.getProject().getReference(this.getSource()));
        RdbmsConfig target = (RdbmsConfig)((Object)this.getProject().getReference(this.getTarget()));
        this.log("Migrating data from " + source.getUrl() + " to " + target.getUrl());
        Incrementor recordCountIncrementor = new Incrementor();
        Map<String, Integer> tableData = this.getTableData(source, target, recordCountIncrementor);
        this.log("Copying " + tableData.size() + " tables");
        float recordVisitor = 0.0f;
        ProgressObserver progressObserver = new ProgressObserver(recordCountIncrementor.getValue(), 48.0f, 0.48f, "\r|%s[%s] %3d%% (%d/%d) records");
        ProgressObservable observable = new ProgressObservable();
        observable.addObserver(progressObserver);
        ThreadGroup tgroup = new ThreadGroup("Migration Threads");
        for (String tableName : tableData.keySet()) {
            this.debug("Migrating table " + tableName + " with " + tableData.get(tableName) + " records");
            HashMap columns = new HashMap();
            this.migrate(source, target, tableName, observable);
        }
        try {
            while (tgroup.activeCount() > 0) {
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            Connection targetDb = this.openConnection(target);
            if (targetDb.getMetaData().getDriverName().toLowerCase().contains("hsqldb")) {
                Statement st = targetDb.createStatement();
                st.execute("CHECKPOINT");
                st.close();
            }
            targetDb.close();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void migrate(RdbmsConfig source, RdbmsConfig target, String tableName, ProgressObservable observable) {
        Connection sourceDb = this.openConnection(source);
        Connection targetDb = this.openConnection(target);
        source.setConnection(sourceDb);
        target.setConnection(targetDb);
        Map<String, Integer> columns = this.getColumnMap(source, target, tableName);
        if (columns.size() < 1) {
            this.log("Columns are empty for " + tableName);
            return;
        }
        PreparedStatement toStatement = this.prepareStatement(targetDb, tableName, columns);
        Statement fromStatement = null;
        boolean hasClob = columns.values().contains(2005);
        int recordsLost = 0;
        try {
            fromStatement = sourceDb.createStatement();
            ResultSet results = fromStatement.executeQuery(String.format(SELECT_ALL_QUERY, tableName));
            try {
                while (results.next()) {
                    try {
                        toStatement.clearParameters();
                        int i = 1;
                        for (String columnName : columns.keySet()) {
                            Object value = results.getObject(columnName);
                            if (value != null) {
                                try {
                                    this.handleLob(toStatement, value, i);
                                }
                                catch (Exception e) {
                                    System.err.println(String.format("Error processing %s.%s %s", tableName, columnName, columns.get(columnName)));
                                    if (Clob.class.isAssignableFrom(value.getClass())) {
                                        System.err.println("Got exception trying to insert CLOB with length" + ((Clob)value).length());
                                    }
                                    e.printStackTrace();
                                }
                            } else {
                                toStatement.setObject(i, value);
                            }
                            ++i;
                        }
                        boolean retry = true;
                        int retry_count = 0;
                        while (retry) {
                            try {
                                toStatement.execute();
                                retry = false;
                            }
                            catch (SQLException sqle) {
                                retry = false;
                                if (sqle.getMessage().contains("ORA-00942")) {
                                    this.log("Couldn't find " + tableName);
                                    this.log("Tried insert statement " + this.getStatementBuffer(tableName, columns));
                                    continue;
                                }
                                if (sqle.getMessage().contains("ORA-12519")) {
                                    retry = true;
                                    this.log("Tried insert statement " + this.getStatementBuffer(tableName, columns));
                                    sqle.printStackTrace();
                                    continue;
                                }
                                if (sqle.getMessage().contains("IN or OUT")) {
                                    this.log("Column count was " + columns.keySet().size());
                                    continue;
                                }
                                if (sqle.getMessage().contains("Error reading")) {
                                    if (retry_count > 5) {
                                        this.log("Tried insert statement " + this.getStatementBuffer(tableName, columns));
                                        retry = false;
                                    }
                                    ++retry_count;
                                    continue;
                                }
                                sqle.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        ++recordsLost;
                        throw e;
                    }
                    finally {
                        observable.incrementRecord();
                    }
                }
            }
            finally {
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            Statement st;
            if (sourceDb != null) {
                try {
                    if (sourceDb.getMetaData().getDriverName().toLowerCase().contains("hsqldb")) {
                        st = sourceDb.createStatement();
                        st.execute("CHECKPOINT");
                        st.close();
                    }
                    fromStatement.close();
                    sourceDb.close();
                }
                catch (Exception e) {}
            }
            if (targetDb != null) {
                try {
                    targetDb.commit();
                    if (targetDb.getMetaData().getDriverName().toLowerCase().contains("hsql")) {
                        st = targetDb.createStatement();
                        st.execute("CHECKPOINT");
                        st.close();
                    }
                    toStatement.close();
                    targetDb.close();
                }
                catch (Exception e) {
                    this.log("Error closing database connection");
                    e.printStackTrace();
                }
            }
            this.debug("Lost " + recordsLost + " records");
            columns.clear();
        }
    }

    protected void handleLob(PreparedStatement toStatement, Object value, int i) throws SQLException {
        if (Clob.class.isAssignableFrom(value.getClass())) {
            toStatement.setAsciiStream(i, ((Clob)value).getAsciiStream(), ((Clob)value).length());
        } else if (Blob.class.isAssignableFrom(value.getClass())) {
            toStatement.setBinaryStream(i, ((Blob)value).getBinaryStream(), ((Blob)value).length());
        } else {
            toStatement.setObject(i, value);
        }
    }

    protected PreparedStatement prepareStatement(Connection conn, String tableName, Map<String, Integer> columns) {
        String statement = this.getStatementBuffer(tableName, columns);
        try {
            return conn.prepareStatement(statement);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String getStatementBuffer(String tableName, Map<String, Integer> columns) {
        String retval = null;
        StringBuilder names = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (String columnName : columns.keySet()) {
            names.append(columnName).append(",");
            values.append("?,");
        }
        names.setLength(names.length() - 1);
        values.setLength(values.length() - 1);
        retval = String.format(INSERT_STATEMENT, tableName, names, values);
        return retval;
    }

    protected boolean isValidTable(DatabaseMetaData metadata, String tableName) {
        return !tableName.startsWith("BIN$") && !tableName.toUpperCase().startsWith(LIQUIBASE_TABLE) && !this.isSequence(metadata, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSequence(DatabaseMetaData metadata, String tableName) {
        RdbmsConfig source = (RdbmsConfig)((Object)this.getProject().getReference(this.getSource()));
        try {
            boolean hasId;
            int columnCount;
            block10: {
                ResultSet rs = metadata.getColumns(null, source.getSchema(), tableName, null);
                columnCount = 0;
                hasId = false;
                try {
                    while (rs.next()) {
                        ++columnCount;
                        if (!"yes".equalsIgnoreCase(rs.getString("IS_AUTOINCREMENT"))) continue;
                        hasId = true;
                    }
                    if (rs == null) break block10;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return columnCount == 1 && hasId;
                }
                try {
                    rs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return columnCount == 1 && hasId;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Map<String, Integer> getTableData(RdbmsConfig source, RdbmsConfig target, Incrementor incrementor) {
        Connection sourceConn = this.openConnection(source);
        Connection targetConn = this.openConnection(target);
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        ArrayList<String> toRemove = new ArrayList<String>();
        this.debug("Looking up table names");
        try {
            DatabaseMetaData metadata = sourceConn.getMetaData();
            ResultSet tableResults = metadata.getTables(sourceConn.getCatalog(), source.getSchema(), null, new String[]{"TABLE"});
            while (tableResults.next()) {
                String tableName = tableResults.getString("TABLE_NAME");
                if (!this.isValidTable(metadata, tableName) || tableName.toUpperCase().startsWith(LIQUIBASE_TABLE)) continue;
                int rowCount = this.getTableRecordCount(sourceConn, tableName);
                if (rowCount < 1) {
                    // empty if block
                }
                incrementor.increment(rowCount);
                this.debug("Adding table " + tableName);
                retval.put(tableName, rowCount);
            }
            tableResults.close();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (sourceConn != null) {
                try {
                    sourceConn.close();
                    sourceConn = null;
                }
                catch (Exception e) {}
            }
        }
        try {
            for (String tableName : retval.keySet()) {
                ResultSet tableResults = targetConn.getMetaData().getTables(targetConn.getCatalog(), target.getSchema(), null, new String[]{"TABLE"});
                if (!tableResults.next()) {
                    this.log("Removing " + tableName);
                    toRemove.add(tableName);
                }
                tableResults.close();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (targetConn != null) {
                try {
                    targetConn.close();
                    targetConn = null;
                }
                catch (Exception e) {}
            }
        }
        for (String tableName : toRemove) {
            retval.remove(tableName);
        }
        return retval;
    }

    private Map<String, Integer> getColumnMap(RdbmsConfig source, RdbmsConfig target, String tableName) {
        Connection targetDb = target.getConnection();
        Connection sourceDb = source.getConnection();
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        ArrayList toRemove = new ArrayList();
        try {
            Statement state = targetDb.createStatement();
            ResultSet altResults = state.executeQuery("select * from " + tableName + " where 1 = 0");
            ResultSetMetaData metadata = altResults.getMetaData();
            for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                retval.put(metadata.getColumnName(i), metadata.getColumnType(i));
            }
            altResults.close();
            state.close();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        for (String column : retval.keySet()) {
            try {
                Statement state = targetDb.createStatement();
                ResultSet altResults = state.executeQuery("select * from " + tableName + " where 1 = 0");
                ResultSetMetaData metadata = altResults.getMetaData();
                for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                    retval.put(metadata.getColumnName(i), metadata.getColumnType(i));
                }
                altResults.close();
                state.close();
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        for (String column : toRemove) {
            retval.remove(column);
        }
        return retval;
    }

    private int getTableRecordCount(Connection conn, String tableName) {
        String query = String.format(RECORD_COUNT_QUERY, tableName);
        Statement statement = null;
        try {
            statement = conn.createStatement();
            ResultSet results = statement.executeQuery(query);
            results.next();
            int retval = results.getInt(COUNT_FIELD);
            results.close();
            int n = retval;
            return n;
        }
        catch (Exception e) {
            if (e.getMessage().contains("ORA-00942")) {
                this.log("Couldn't find " + tableName);
                this.log("Tried insert statement " + query);
            }
            this.log("Exception executing " + query);
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (Exception e) {}
        }
    }

    private void debug(String msg) {
        this.log(msg, 4);
    }

    private Connection openSource() {
        return this.openConnection(this.getSource());
    }

    private Connection openTarget() {
        return this.openConnection(this.getTarget());
    }

    private Connection openConnection(String reference) {
        RdbmsConfig config = (RdbmsConfig)((Object)this.getProject().getReference(reference));
        return this.openConnection(config);
    }

    private Connection openConnection(RdbmsConfig config) {
        Connection retval = null;
        while (retval == null) {
            try {
                this.debug("Loading schema " + config.getSchema() + " at url " + config.getUrl());
                Class.forName(config.getDriver());
                retval = DriverManager.getConnection(config.getUrl(), config.getUsername(), config.getPassword());
                retval.setAutoCommit(false);
                if (config.getDriver().indexOf("hsqldb") <= -1) continue;
                this.debug("Disabling hsqldb log");
                Statement st = retval.createStatement();
                st.execute("SET FILES LOG FALSE");
                st.close();
            }
            catch (Exception exception) {}
        }
        return retval;
    }

    private class ProgressObserver
    implements Observer {
        private float total;
        private float progress;
        private float length;
        private float ratio;
        private String template;
        private float count;
        private PrintStream out;

        public ProgressObserver(float total, float length, float ratio, String template) {
            this.total = total;
            this.template = template;
            this.ratio = ratio;
            this.length = length;
            this.count = 0.0f;
            try {
                Field field = Main.class.getDeclaredField("out");
                field.setAccessible(true);
                this.out = (PrintStream)field.get(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public synchronized void update(Observable o, Object arg) {
            int x;
            this.count += 1.0f;
            int percent = (int)(this.count / this.total * 100.0f);
            int progress = (int)(this.count / this.total * (100.0f * this.ratio));
            StringBuilder progressBuffer = new StringBuilder();
            for (x = 0; x < progress; ++x) {
                progressBuffer.append('=');
            }
            x = progress;
            while ((float)x < this.length) {
                progressBuffer.append(' ');
                ++x;
            }
            int roll = (int)(this.count / (this.total / 1000.0f));
            if (MigrateData.this.getProject().getProperty("run_from_ant") == null) {
                this.out.print(String.format(this.template, progressBuffer, carr[roll % carr.length], percent, (int)this.count, (int)this.total));
            } else if (this.count % 5000.0f == 0.0f || this.count == this.total) {
                this.out.println(String.format("(%s)%% %s of %s records", (int)(this.count / this.total * 100.0f), (int)this.count, (int)this.total));
            }
        }
    }

    private class ProgressObservable
    extends Observable {
        private ProgressObservable() {
        }

        public void incrementRecord() {
            this.setChanged();
            this.notifyObservers();
            this.clearChanged();
        }
    }

    private class Incrementor {
        private int value = 0;

        public int getValue() {
            return this.value;
        }

        public void increment() {
            ++this.value;
        }

        public void increment(int by) {
            this.value += by;
        }
    }
}

