/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.tools.ant.tasks;

import java.util.List;
import liquibase.Liquibase;
import liquibase.integration.ant.BaseLiquibaseTask;
import liquibase.util.StringUtils;
import org.apache.tools.ant.BuildException;

public class DropAllTask
extends BaseLiquibaseTask {
    private String schemas;

    public String getSchemas() {
        return this.schemas;
    }

    public void setSchemas(String schemas) {
        this.schemas = schemas;
    }

    public void execute() throws BuildException {
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibase();
            boolean retry = true;
            while (retry) {
                try {
                    if (StringUtils.trimToNull((String)this.schemas) != null) {
                        List schemas = StringUtils.splitAndTrim((String)this.schemas, (String)",");
                        liquibase.dropAll(schemas.toArray(new String[schemas.size()]));
                    } else {
                        liquibase.dropAll();
                    }
                    retry = false;
                }
                catch (Exception e2) {
                    this.log(e2.getMessage());
                    if (e2.getMessage().indexOf("ORA-02443") < 0 && e2.getCause() != null && retry) {
                        boolean bl = retry = e2.getCause().getMessage().indexOf("ORA-02443") > -1;
                    }
                    if (!retry) {
                        throw e2;
                    }
                    this.log("Got ORA-2443. Retrying...");
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }
}

