/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.tools.ant.tasks;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.kualigan.tools.ant.tasks.Include;

public class TableSet {
    private Vector<Include> includes = new Vector();
    private Set<String> tables = new HashSet<String>();
    private Connection connection;
    private String schema;

    public Include createInclude() {
        Include retval = new Include();
        this.includes.add(retval);
        return retval;
    }

    public void execute() {
        try {
            DatabaseMetaData metadata = this.getConnection().getMetaData();
            System.out.printf("Looking for tables in schema %s\n", this.getSchema());
            ResultSet rs = metadata.getTables(null, this.getSchema(), null, new String[]{"TABLE"});
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                if (!this.isTableNameValid(tableName)) continue;
                this.tables.add(tableName);
            }
        }
        catch (Exception e) {
            throw new BuildException("Exception when getting table names", (Throwable)e);
        }
    }

    private boolean isTableNameValid(String tableName) {
        boolean retval = this.includes.size() == 0;
        for (Include include : this.includes) {
            retval |= Pattern.compile(include.getRegex()).matcher(tableName).matches();
        }
        return retval;
    }

    public Set<String> getTables() {
        return this.tables;
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public final void setConnection(Connection argConnection) {
        this.connection = argConnection;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }
}

