/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.tools.liquibase;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.AddNotNullConstraintChange;
import liquibase.change.core.AddPrimaryKeyChange;
import liquibase.change.core.AddUniqueConstraintChange;
import liquibase.change.core.CreateIndexChange;
import liquibase.change.core.CreateSequenceChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.CreateViewChange;
import liquibase.change.core.DropColumnChange;
import liquibase.change.core.DropForeignKeyConstraintChange;
import liquibase.change.core.DropIndexChange;
import liquibase.change.core.DropNotNullConstraintChange;
import liquibase.change.core.DropPrimaryKeyChange;
import liquibase.change.core.DropSequenceChange;
import liquibase.change.core.DropTableChange;
import liquibase.change.core.DropUniqueConstraintChange;
import liquibase.change.core.DropViewChange;
import liquibase.change.core.InsertDataChange;
import liquibase.change.core.LoadDataChange;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.change.core.ModifyDataTypeChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.database.structure.View;
import liquibase.database.typeconversion.TypeConverter;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.diff.DiffComparison;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.ChangeLogSerializerFactory;
import liquibase.serializer.core.xml.XMLChangeLogSerializer;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.ext.DescribeSequenceStatement;
import liquibase.util.ISODateFormat;
import liquibase.util.StringUtils;
import liquibase.util.csv.CSVWriter;

public class DiffResult {
    private String idRoot = String.valueOf(new Date().getTime());
    private int changeNumber = 1;
    private DatabaseSnapshot referenceSnapshot;
    private DatabaseSnapshot targetSnapshot;
    private DiffComparison productName;
    private DiffComparison productVersion;
    private SortedSet<Table> missingTables = new TreeSet<Table>();
    private SortedSet<Table> unexpectedTables = new TreeSet<Table>();
    private SortedSet<View> missingViews = new TreeSet<View>();
    private SortedSet<View> unexpectedViews = new TreeSet<View>();
    private SortedSet<View> changedViews = new TreeSet<View>();
    private SortedSet<Column> missingColumns = new TreeSet<Column>();
    private SortedSet<Column> unexpectedColumns = new TreeSet<Column>();
    private SortedSet<Column> changedColumns = new TreeSet<Column>();
    private SortedSet<ForeignKey> missingForeignKeys = new TreeSet<ForeignKey>();
    private SortedSet<ForeignKey> unexpectedForeignKeys = new TreeSet<ForeignKey>();
    private SortedSet<Index> missingIndexes = new TreeSet<Index>();
    private SortedSet<Index> unexpectedIndexes = new TreeSet<Index>();
    private SortedSet<PrimaryKey> missingPrimaryKeys = new TreeSet<PrimaryKey>();
    private SortedSet<PrimaryKey> unexpectedPrimaryKeys = new TreeSet<PrimaryKey>();
    private SortedSet<UniqueConstraint> missingUniqueConstraints = new TreeSet<UniqueConstraint>();
    private SortedSet<UniqueConstraint> unexpectedUniqueConstraints = new TreeSet<UniqueConstraint>();
    private SortedSet<Sequence> missingSequences = new TreeSet<Sequence>();
    private SortedSet<Sequence> unexpectedSequences = new TreeSet<Sequence>();
    private boolean diffData = false;
    private String dataDir = null;
    private String changeSetContext;
    private String changeSetAuthor;
    private ChangeLogSerializerFactory serializerFactory = ChangeLogSerializerFactory.getInstance();

    public DiffResult(DatabaseSnapshot referenceDatabaseSnapshot, DatabaseSnapshot targetDatabaseSnapshot) {
        this.referenceSnapshot = referenceDatabaseSnapshot;
        if (targetDatabaseSnapshot == null) {
            targetDatabaseSnapshot = new DatabaseSnapshot(referenceDatabaseSnapshot.getDatabase(), null);
        }
        this.targetSnapshot = targetDatabaseSnapshot;
    }

    public DiffComparison getProductName() {
        return this.productName;
    }

    public void setProductName(DiffComparison productName) {
        this.productName = productName;
    }

    public DiffComparison getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(DiffComparison product) {
        this.productVersion = product;
    }

    public void addMissingTable(Table table) {
        this.missingTables.add(table);
    }

    public SortedSet<Table> getMissingTables() {
        return this.missingTables;
    }

    public void addUnexpectedTable(Table table) {
        this.unexpectedTables.add(table);
    }

    public SortedSet<Table> getUnexpectedTables() {
        return this.unexpectedTables;
    }

    public void addMissingView(View viewName) {
        this.missingViews.add(viewName);
    }

    public SortedSet<View> getMissingViews() {
        return this.missingViews;
    }

    public void addUnexpectedView(View viewName) {
        this.unexpectedViews.add(viewName);
    }

    public SortedSet<View> getUnexpectedViews() {
        return this.unexpectedViews;
    }

    public void addChangedView(View viewName) {
        this.changedViews.add(viewName);
    }

    public SortedSet<View> getChangedViews() {
        return this.changedViews;
    }

    public void addMissingColumn(Column columnName) {
        this.missingColumns.add(columnName);
    }

    public SortedSet<Column> getMissingColumns() {
        return this.missingColumns;
    }

    public void addUnexpectedColumn(Column columnName) {
        this.unexpectedColumns.add(columnName);
    }

    public SortedSet<Column> getUnexpectedColumns() {
        return this.unexpectedColumns;
    }

    public void addChangedColumn(Column columnName) {
        this.changedColumns.add(columnName);
    }

    public SortedSet<Column> getChangedColumns() {
        return this.changedColumns;
    }

    public void addMissingForeignKey(ForeignKey fkName) {
        this.missingForeignKeys.add(fkName);
    }

    public SortedSet<ForeignKey> getMissingForeignKeys() {
        return this.missingForeignKeys;
    }

    public void addUnexpectedForeignKey(ForeignKey fkName) {
        this.unexpectedForeignKeys.add(fkName);
    }

    public SortedSet<ForeignKey> getUnexpectedForeignKeys() {
        return this.unexpectedForeignKeys;
    }

    public void addMissingIndex(Index fkName) {
        this.missingIndexes.add(fkName);
    }

    public SortedSet<Index> getMissingIndexes() {
        return this.missingIndexes;
    }

    public void addUnexpectedIndex(Index fkName) {
        this.unexpectedIndexes.add(fkName);
    }

    public SortedSet<Index> getUnexpectedIndexes() {
        return this.unexpectedIndexes;
    }

    public void addMissingPrimaryKey(PrimaryKey primaryKey) {
        this.missingPrimaryKeys.add(primaryKey);
    }

    public SortedSet<PrimaryKey> getMissingPrimaryKeys() {
        return this.missingPrimaryKeys;
    }

    public void addUnexpectedPrimaryKey(PrimaryKey primaryKey) {
        this.unexpectedPrimaryKeys.add(primaryKey);
    }

    public SortedSet<PrimaryKey> getUnexpectedPrimaryKeys() {
        return this.unexpectedPrimaryKeys;
    }

    public void addMissingSequence(Sequence sequence) {
        this.missingSequences.add(sequence);
    }

    public SortedSet<Sequence> getMissingSequences() {
        return this.missingSequences;
    }

    public void addUnexpectedSequence(Sequence sequence) {
        this.unexpectedSequences.add(sequence);
    }

    public SortedSet<Sequence> getUnexpectedSequences() {
        return this.unexpectedSequences;
    }

    public void addMissingUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.missingUniqueConstraints.add(uniqueConstraint);
    }

    public SortedSet<UniqueConstraint> getMissingUniqueConstraints() {
        return this.missingUniqueConstraints;
    }

    public void addUnexpectedUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.unexpectedUniqueConstraints.add(uniqueConstraint);
    }

    public SortedSet<UniqueConstraint> getUnexpectedUniqueConstraints() {
        return this.unexpectedUniqueConstraints;
    }

    public boolean shouldDiffData() {
        return this.diffData;
    }

    public void setDiffData(boolean diffData) {
        this.diffData = diffData;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public String getChangeSetContext() {
        return this.changeSetContext;
    }

    public void setChangeSetContext(String changeSetContext) {
        this.changeSetContext = changeSetContext;
    }

    public boolean differencesFound() throws DatabaseException, IOException {
        boolean differencesInData = false;
        if (this.shouldDiffData()) {
            ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
            this.addInsertDataChanges(changeSets, this.dataDir);
            differencesInData = !changeSets.isEmpty();
        }
        return this.getMissingColumns().size() > 0 || this.getMissingForeignKeys().size() > 0 || this.getMissingIndexes().size() > 0 || this.getMissingPrimaryKeys().size() > 0 || this.getMissingSequences().size() > 0 || this.getMissingTables().size() > 0 || this.getMissingUniqueConstraints().size() > 0 || this.getMissingViews().size() > 0 || this.getUnexpectedColumns().size() > 0 || this.getUnexpectedForeignKeys().size() > 0 || this.getUnexpectedIndexes().size() > 0 || this.getUnexpectedPrimaryKeys().size() > 0 || this.getUnexpectedSequences().size() > 0 || this.getUnexpectedTables().size() > 0 || this.getUnexpectedUniqueConstraints().size() > 0 || this.getUnexpectedViews().size() > 0 || differencesInData;
    }

    public void printResult(PrintStream out) throws DatabaseException {
        out.println("Reference Database: " + this.referenceSnapshot.getDatabase());
        out.println("Target Database: " + this.targetSnapshot.getDatabase());
        this.printComparision("Product Name", this.productName, out);
        this.printComparision("Product Version", this.productVersion, out);
        this.printSetComparison("Missing Tables", this.getMissingTables(), out);
        this.printSetComparison("Unexpected Tables", this.getUnexpectedTables(), out);
        this.printSetComparison("Missing Views", this.getMissingViews(), out);
        this.printSetComparison("Unexpected Views", this.getUnexpectedViews(), out);
        this.printSetComparison("Changed Views", this.getChangedViews(), out);
        this.printSetComparison("Missing Columns", this.getMissingColumns(), out);
        this.printSetComparison("Unexpected Columns", this.getUnexpectedColumns(), out);
        this.printColumnComparison(this.getChangedColumns(), out);
        this.printSetComparison("Missing Foreign Keys", this.getMissingForeignKeys(), out);
        this.printSetComparison("Unexpected Foreign Keys", this.getUnexpectedForeignKeys(), out);
        this.printSetComparison("Missing Primary Keys", this.getMissingPrimaryKeys(), out);
        this.printSetComparison("Unexpected Primary Keys", this.getUnexpectedPrimaryKeys(), out);
        this.printSetComparison("Unexpected Unique Constraints", this.getUnexpectedUniqueConstraints(), out);
        this.printSetComparison("Missing Unique Constraints", this.getMissingUniqueConstraints(), out);
        this.printSetComparison("Missing Indexes", this.getMissingIndexes(), out);
        this.printSetComparison("Unexpected Indexes", this.getUnexpectedIndexes(), out);
        this.printSetComparison("Missing Sequences", this.getMissingSequences(), out);
        this.printSetComparison("Unexpected Sequences", this.getUnexpectedSequences(), out);
    }

    private void printSetComparison(String title, SortedSet<?> objects, PrintStream out) {
        out.print(title + ": ");
        if (objects.size() == 0) {
            out.println("NONE");
        } else {
            out.println();
            for (Object object : objects) {
                out.println("     " + object);
            }
        }
    }

    private void printColumnComparison(SortedSet<Column> changedColumns, PrintStream out) {
        out.print("Changed Columns: ");
        if (changedColumns.size() == 0) {
            out.println("NONE");
        } else {
            out.println();
            for (Column column : changedColumns) {
                out.println("     " + column);
                Column baseColumn = this.referenceSnapshot.getColumn(column.getTable().getName(), column.getName());
                if (baseColumn == null) continue;
                if (baseColumn.isDataTypeDifferent(column)) {
                    out.println("           from " + TypeConverterFactory.getInstance().findTypeConverter(this.referenceSnapshot.getDatabase()).convertToDatabaseTypeString(baseColumn, this.referenceSnapshot.getDatabase()) + " to " + TypeConverterFactory.getInstance().findTypeConverter(this.targetSnapshot.getDatabase()).convertToDatabaseTypeString(this.targetSnapshot.getColumn(column.getTable().getName(), column.getName()), this.targetSnapshot.getDatabase()));
                }
                if (!baseColumn.isNullabilityDifferent(column)) continue;
                Boolean nowNullable = this.targetSnapshot.getColumn(column.getTable().getName(), column.getName()).isNullable();
                if (nowNullable == null) {
                    nowNullable = Boolean.TRUE;
                }
                if (nowNullable.booleanValue()) {
                    out.println("           now nullable");
                    continue;
                }
                out.println("           now not null");
            }
        }
    }

    private void printComparision(String title, DiffComparison comparison, PrintStream out) {
        out.print(title + ":");
        if (comparison == null) {
            out.print("NULL");
            return;
        }
        if (comparison.areTheSame()) {
            out.println(" EQUAL");
        } else {
            out.println();
            out.println("     Reference:   '" + comparison.getReferenceVersion() + "'");
            out.println("     Target: '" + comparison.getTargetVersion() + "'");
        }
    }

    public void printChangeLog(String changeLogFile, Database targetDatabase) throws ParserConfigurationException, IOException, DatabaseException {
        ChangeLogSerializer changeLogSerializer = this.serializerFactory.getSerializer(changeLogFile);
        this.printChangeLog(changeLogFile, targetDatabase, changeLogSerializer);
    }

    public void printChangeLog(PrintStream out, Database targetDatabase) throws ParserConfigurationException, IOException, DatabaseException {
        this.printChangeLog(out, targetDatabase, (ChangeLogSerializer)new XMLChangeLogSerializer());
    }

    public void printChangeLog(String changeLogFile, Database targetDatabase, ChangeLogSerializer changeLogSerializer) throws ParserConfigurationException, IOException, DatabaseException {
        File file = new File(changeLogFile);
        if (!file.exists()) {
            LogFactory.getLogger().info(file + " does not exist, creating");
            FileOutputStream stream = new FileOutputStream(file);
            this.printChangeLog(new PrintStream(stream), targetDatabase, changeLogSerializer);
            stream.close();
        } else {
            String line;
            LogFactory.getLogger().info(file + " exists, appending");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.printChangeLog(new PrintStream(out), targetDatabase, changeLogSerializer);
            String xml = new String(out.toByteArray());
            xml = xml.replaceFirst("(?ms).*<databaseChangeLog[^>]*>", "");
            xml = xml.replaceFirst("</databaseChangeLog>", "");
            xml = xml.trim();
            if ("".equals(xml)) {
                LogFactory.getLogger().info("No changes found, nothing to do");
                return;
            }
            String lineSeparator = System.getProperty("line.separator");
            BufferedReader fileReader = new BufferedReader(new FileReader(file));
            long offset = 0L;
            while ((line = fileReader.readLine()) != null) {
                int index = line.indexOf("</databaseChangeLog>");
                if (index >= 0) {
                    offset += (long)index;
                    continue;
                }
                offset += (long)line.getBytes().length;
                offset += (long)lineSeparator.getBytes().length;
            }
            fileReader.close();
            fileReader = new BufferedReader(new FileReader(file));
            fileReader.skip(offset);
            fileReader.close();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(offset);
            randomAccessFile.writeBytes("    ");
            randomAccessFile.write(xml.getBytes());
            randomAccessFile.writeBytes(lineSeparator);
            randomAccessFile.writeBytes("</databaseChangeLog>" + lineSeparator);
            randomAccessFile.close();
        }
    }

    public void printChangeLog(PrintStream out, Database targetDatabase, ChangeLogSerializer changeLogSerializer) throws ParserConfigurationException, IOException, DatabaseException {
        ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        this.addMissingTableChanges(changeSets, targetDatabase);
        this.addMissingColumnChanges(changeSets, targetDatabase);
        this.addChangedColumnChanges(changeSets);
        this.addMissingPrimaryKeyChanges(changeSets);
        this.addUnexpectedPrimaryKeyChanges(changeSets);
        this.addUnexpectedForeignKeyChanges(changeSets);
        this.addMissingUniqueConstraintChanges(changeSets);
        this.addMissingIndexChanges(changeSets);
        this.addUnexpectedUniqueConstraintChanges(changeSets);
        if (this.diffData) {
            this.addInsertDataChanges(changeSets, this.dataDir);
        }
        this.addMissingForeignKeyChanges(changeSets);
        this.addUnexpectedIndexChanges(changeSets);
        this.addUnexpectedColumnChanges(changeSets);
        this.addMissingSequenceChanges(changeSets);
        this.addUnexpectedSequenceChanges(changeSets);
        this.addMissingViewChanges(changeSets);
        this.addUnexpectedViewChanges(changeSets);
        this.addChangedViewChanges(changeSets);
        this.addUnexpectedTableChanges(changeSets);
        changeLogSerializer.write(changeSets, (OutputStream)out);
        out.flush();
    }

    private ChangeSet generateChangeSet(Change change) {
        ChangeSet changeSet = this.generateChangeSet();
        changeSet.addChange(change);
        return changeSet;
    }

    private ChangeSet generateChangeSet() {
        return new ChangeSet(this.generateId(), this.getChangeSetAuthor(), false, false, null, this.getChangeSetContext(), null);
    }

    private String getChangeSetAuthor() {
        if (this.changeSetAuthor != null) {
            return this.changeSetAuthor;
        }
        String author = System.getProperty("user.name");
        if (StringUtils.trimToNull((String)author) == null) {
            return "diff-generated";
        }
        return author + " (generated)";
    }

    public void setChangeSetAuthor(String changeSetAuthor) {
        this.changeSetAuthor = changeSetAuthor;
    }

    public void setIdRoot(String idRoot) {
        this.idRoot = idRoot;
    }

    protected String generateId() {
        return this.idRoot + "-" + this.changeNumber++;
    }

    private void addUnexpectedIndexChanges(List<ChangeSet> changes) {
        for (Index index : this.getUnexpectedIndexes()) {
            if (index.getAssociatedWith().contains("primaryKey") || index.getAssociatedWith().contains("foreignKey") || index.getAssociatedWith().contains("uniqueConstraint")) continue;
            DropIndexChange change = new DropIndexChange();
            change.setTableName(index.getTable().getName());
            change.setSchemaName(index.getTable().getSchema());
            change.setIndexName(index.getName());
            change.setAssociatedWith(index.getAssociatedWithAsString());
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addMissingIndexChanges(List<ChangeSet> changes) {
        for (Index index : this.getMissingIndexes()) {
            CreateIndexChange change = new CreateIndexChange();
            change.setTableName(index.getTable().getName());
            change.setTablespace(index.getTablespace());
            change.setSchemaName(index.getTable().getSchema());
            change.setIndexName(index.getName());
            change.setUnique(index.isUnique());
            change.setAssociatedWith(index.getAssociatedWithAsString());
            if (index.getAssociatedWith().contains("primaryKey") || index.getAssociatedWith().contains("foreignKey") || index.getAssociatedWith().contains("uniqueConstraint")) continue;
            for (String columnName : index.getColumns()) {
                ColumnConfig column = new ColumnConfig();
                column.setName(columnName);
                change.addColumn(column);
            }
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addUnexpectedPrimaryKeyChanges(List<ChangeSet> changes) {
        for (PrimaryKey pk : this.getUnexpectedPrimaryKeys()) {
            if (this.getUnexpectedTables().contains(pk.getTable())) continue;
            DropPrimaryKeyChange change = new DropPrimaryKeyChange();
            change.setTableName(pk.getTable().getName());
            change.setSchemaName(pk.getTable().getSchema());
            change.setConstraintName(pk.getName());
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addMissingPrimaryKeyChanges(List<ChangeSet> changes) {
        for (PrimaryKey pk : this.getMissingPrimaryKeys()) {
            AddPrimaryKeyChange change = new AddPrimaryKeyChange();
            change.setTableName(pk.getTable().getName());
            change.setSchemaName(pk.getTable().getSchema());
            change.setConstraintName(pk.getName());
            change.setColumnNames(pk.getColumnNames());
            change.setTablespace(pk.getTablespace());
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addUnexpectedUniqueConstraintChanges(List<ChangeSet> changes) {
        for (UniqueConstraint uc : this.getUnexpectedUniqueConstraints()) {
            if (null == uc || null == uc.getTable()) continue;
            DropUniqueConstraintChange change = new DropUniqueConstraintChange();
            change.setTableName(uc.getTable().getName());
            change.setSchemaName(uc.getTable().getSchema());
            change.setConstraintName(uc.getName());
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addMissingUniqueConstraintChanges(List<ChangeSet> changes) {
        for (UniqueConstraint uc : this.getMissingUniqueConstraints()) {
            if (null == uc || null == uc.getTable()) continue;
            AddUniqueConstraintChange change = new AddUniqueConstraintChange();
            change.setTableName(uc.getTable().getName());
            change.setTablespace(uc.getTablespace());
            change.setSchemaName(uc.getTable().getSchema());
            change.setConstraintName(uc.getName());
            change.setColumnNames(uc.getColumnNames());
            change.setDeferrable(Boolean.valueOf(uc.isDeferrable()));
            change.setInitiallyDeferred(Boolean.valueOf(uc.isInitiallyDeferred()));
            change.setDisabled(Boolean.valueOf(uc.isDisabled()));
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addUnexpectedForeignKeyChanges(List<ChangeSet> changes) {
        for (ForeignKey fk : this.getUnexpectedForeignKeys()) {
            DropForeignKeyConstraintChange change = new DropForeignKeyConstraintChange();
            change.setConstraintName(fk.getName());
            change.setBaseTableName(fk.getForeignKeyTable().getName());
            change.setBaseTableSchemaName(fk.getForeignKeyTable().getSchema());
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addMissingForeignKeyChanges(List<ChangeSet> changes) {
        for (ForeignKey fk : this.getMissingForeignKeys()) {
            AddForeignKeyConstraintChange change = new AddForeignKeyConstraintChange();
            change.setConstraintName(fk.getName());
            change.setReferencedTableName(fk.getPrimaryKeyTable().getName());
            change.setReferencedTableSchemaName(fk.getPrimaryKeyTable().getSchema());
            change.setReferencedColumnNames(fk.getPrimaryKeyColumns());
            change.setBaseTableName(fk.getForeignKeyTable().getName());
            change.setBaseTableSchemaName(fk.getForeignKeyTable().getSchema());
            change.setBaseColumnNames(fk.getForeignKeyColumns());
            change.setDeferrable(Boolean.valueOf(fk.isDeferrable()));
            change.setInitiallyDeferred(Boolean.valueOf(fk.isInitiallyDeferred()));
            change.setOnUpdate(fk.getUpdateRule());
            change.setOnDelete(fk.getDeleteRule());
            change.setReferencesUniqueColumn(Boolean.valueOf(fk.getReferencesUniqueColumn()));
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addUnexpectedSequenceChanges(List<ChangeSet> changes) {
        for (Sequence sequence : this.getUnexpectedSequences()) {
            DropSequenceChange change = new DropSequenceChange();
            change.setSequenceName(sequence.getName());
            change.setSchemaName(sequence.getSchema());
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addMissingSequenceChanges(List<ChangeSet> changes) {
        for (Sequence sequence : this.getMissingSequences()) {
            CreateSequenceChange change = new CreateSequenceChange();
            change.setSequenceName(sequence.getName());
            change.setSchemaName(sequence.getSchema());
            try {
                DescribeSequenceStatement statement = new DescribeSequenceStatement(sequence.getName());
                BigInteger startValue = (BigInteger)ExecutorService.getInstance().getExecutor(this.referenceSnapshot.getDatabase()).queryForObject((SqlStatement)statement, BigInteger.class);
                change.setStartValue(startValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addUnexpectedColumnChanges(List<ChangeSet> changes) {
        for (Column column : this.getUnexpectedColumns()) {
            if (!this.shouldModifyColumn(column)) continue;
            DropColumnChange change = new DropColumnChange();
            change.setTableName(column.getTable().getName());
            change.setSchemaName(column.getTable().getSchema());
            change.setColumnName(column.getName());
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addMissingViewChanges(List<ChangeSet> changes) {
        for (View view : this.getMissingViews()) {
            CreateViewChange change = new CreateViewChange();
            change.setViewName(view.getName());
            change.setSchemaName(view.getSchema());
            String selectQuery = view.getDefinition();
            if (selectQuery == null) {
                selectQuery = "COULD NOT DETERMINE VIEW QUERY";
            }
            change.setSelectQuery(selectQuery);
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addChangedViewChanges(List<ChangeSet> changes) {
        for (View view : this.getChangedViews()) {
            CreateViewChange change = new CreateViewChange();
            change.setViewName(view.getName());
            change.setSchemaName(view.getSchema());
            String selectQuery = view.getDefinition();
            if (selectQuery == null) {
                selectQuery = "COULD NOT DETERMINE VIEW QUERY";
            }
            change.setSelectQuery(selectQuery);
            change.setReplaceIfExists(Boolean.valueOf(true));
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addChangedColumnChanges(List<ChangeSet> changes) {
        for (Column column : this.getChangedColumns()) {
            ModifyDataTypeChange change;
            if (!this.shouldModifyColumn(column)) continue;
            TypeConverter targetTypeConverter = TypeConverterFactory.getInstance().findTypeConverter(this.targetSnapshot.getDatabase());
            boolean foundDifference = false;
            Column referenceColumn = this.referenceSnapshot.getColumn(column.getTable().getName(), column.getName());
            if (column.isDataTypeDifferent(referenceColumn)) {
                change = new ModifyDataTypeChange();
                change.setTableName(column.getTable().getName());
                change.setSchemaName(column.getTable().getSchema());
                change.setColumnName(column.getName());
                change.setNewDataType(targetTypeConverter.convertToDatabaseTypeString(referenceColumn, this.targetSnapshot.getDatabase()));
                changes.add(this.generateChangeSet((Change)change));
                foundDifference = true;
            }
            if (column.isNullabilityDifferent(referenceColumn)) {
                if (referenceColumn.isNullable() == null || referenceColumn.isNullable().booleanValue()) {
                    change = new DropNotNullConstraintChange();
                    change.setTableName(column.getTable().getName());
                    change.setSchemaName(column.getTable().getSchema());
                    change.setColumnName(column.getName());
                    change.setColumnDataType(targetTypeConverter.convertToDatabaseTypeString(referenceColumn, this.targetSnapshot.getDatabase()));
                    changes.add(this.generateChangeSet((Change)change));
                    foundDifference = true;
                } else {
                    String defaultValueString;
                    change = new AddNotNullConstraintChange();
                    change.setTableName(column.getTable().getName());
                    change.setSchemaName(column.getTable().getSchema());
                    change.setColumnName(column.getName());
                    change.setColumnDataType(targetTypeConverter.convertToDatabaseTypeString(referenceColumn, this.targetSnapshot.getDatabase()));
                    Object defaultValue = column.getDefaultValue();
                    if (defaultValue != null && (defaultValueString = targetTypeConverter.getDataType(defaultValue).convertObjectToString(defaultValue, this.targetSnapshot.getDatabase())) != null) {
                        change.setDefaultNullValue(defaultValueString);
                    }
                    changes.add(this.generateChangeSet((Change)change));
                    foundDifference = true;
                }
            }
            if (foundDifference) continue;
            throw new RuntimeException("Unknown difference");
        }
    }

    private boolean shouldModifyColumn(Column column) {
        return column.getView() == null && !this.referenceSnapshot.getDatabase().isLiquibaseTable(column.getTable().getName());
    }

    private void addUnexpectedViewChanges(List<ChangeSet> changes) {
        for (View view : this.getUnexpectedViews()) {
            DropViewChange change = new DropViewChange();
            change.setViewName(view.getName());
            change.setSchemaName(view.getSchema());
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addMissingColumnChanges(List<ChangeSet> changes, Database database) {
        for (Column column : this.getMissingColumns()) {
            if (!this.shouldModifyColumn(column)) continue;
            AddColumnChange change = new AddColumnChange();
            change.setTableName(column.getTable().getName());
            change.setSchemaName(column.getTable().getSchema());
            ColumnConfig columnConfig = new ColumnConfig();
            columnConfig.setName(column.getName());
            String dataType = TypeConverterFactory.getInstance().findTypeConverter(database).convertToDatabaseTypeString(column, database);
            columnConfig.setType(dataType);
            Object defaultValue = column.getDefaultValue();
            if (defaultValue != null) {
                String defaultValueString = TypeConverterFactory.getInstance().findTypeConverter(database).getDataType(defaultValue).convertObjectToString(defaultValue, database);
                if (defaultValueString != null) {
                    defaultValueString = defaultValueString.replaceFirst("'", "").replaceAll("'$", "");
                }
                columnConfig.setDefaultValue(defaultValueString);
            }
            if (column.getRemarks() != null) {
                columnConfig.setRemarks(column.getRemarks());
            }
            ConstraintsConfig constraintsConfig = columnConfig.getConstraints();
            if (column.isNullable() != null && !column.isNullable().booleanValue()) {
                if (constraintsConfig == null) {
                    constraintsConfig = new ConstraintsConfig();
                }
                constraintsConfig.setNullable(Boolean.valueOf(false));
            }
            if (column.isUnique()) {
                if (constraintsConfig == null) {
                    constraintsConfig = new ConstraintsConfig();
                }
                constraintsConfig.setUnique(Boolean.valueOf(true));
            }
            if (constraintsConfig != null) {
                columnConfig.setConstraints(constraintsConfig);
            }
            change.addColumn(columnConfig);
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addMissingTableChanges(List<ChangeSet> changes, Database database) {
        for (Table missingTable : this.getMissingTables()) {
            if (this.referenceSnapshot.getDatabase().isLiquibaseTable(missingTable.getName())) continue;
            CreateTableChange change = new CreateTableChange();
            change.setTableName(missingTable.getName());
            change.setSchemaName(missingTable.getSchema());
            if (missingTable.getRemarks() != null) {
                change.setRemarks(missingTable.getRemarks());
            }
            for (Column column : missingTable.getColumns()) {
                Object defaultValue;
                ColumnConfig columnConfig = new ColumnConfig();
                columnConfig.setName(column.getName());
                columnConfig.setType(TypeConverterFactory.getInstance().findTypeConverter(database).convertToDatabaseTypeString(column, database));
                ConstraintsConfig constraintsConfig = null;
                if (column.isPrimaryKey()) {
                    PrimaryKey primaryKey = null;
                    for (PrimaryKey pk : this.getMissingPrimaryKeys()) {
                        if (!pk.getTable().getName().equalsIgnoreCase(missingTable.getName())) continue;
                        primaryKey = pk;
                    }
                    if (primaryKey == null || primaryKey.getColumnNamesAsList().size() == 1) {
                        constraintsConfig = new ConstraintsConfig();
                        constraintsConfig.setPrimaryKey(Boolean.valueOf(true));
                        constraintsConfig.setPrimaryKeyTablespace(column.getTablespace());
                        if (primaryKey != null) {
                            constraintsConfig.setPrimaryKeyName(primaryKey.getName());
                            this.getMissingPrimaryKeys().remove(primaryKey);
                        }
                    }
                }
                if (column.isAutoIncrement()) {
                    columnConfig.setAutoIncrement(Boolean.valueOf(true));
                }
                if (column.isNullable() != null && !column.isNullable().booleanValue()) {
                    if (constraintsConfig == null) {
                        constraintsConfig = new ConstraintsConfig();
                    }
                    constraintsConfig.setNullable(Boolean.valueOf(false));
                }
                if (column.isUnique()) {
                    if (constraintsConfig == null) {
                        constraintsConfig = new ConstraintsConfig();
                    }
                    constraintsConfig.setUnique(Boolean.valueOf(true));
                }
                if (constraintsConfig != null) {
                    columnConfig.setConstraints(constraintsConfig);
                }
                if ((defaultValue = column.getDefaultValue()) != null && !column.isAutoIncrement()) {
                    if (defaultValue instanceof Date) {
                        columnConfig.setDefaultValueDate((Date)defaultValue);
                    } else if (defaultValue instanceof Boolean) {
                        columnConfig.setDefaultValueBoolean((Boolean)defaultValue);
                    } else if (defaultValue instanceof Number) {
                        columnConfig.setDefaultValueNumeric((Number)defaultValue);
                    } else if (defaultValue instanceof DatabaseFunction) {
                        columnConfig.setDefaultValueComputed((DatabaseFunction)defaultValue);
                    } else {
                        columnConfig.setDefaultValue(defaultValue.toString());
                    }
                }
                if (column.getRemarks() != null) {
                    columnConfig.setRemarks(column.getRemarks());
                }
                change.addColumn(columnConfig);
            }
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addUnexpectedTableChanges(List<ChangeSet> changes) {
        for (Table unexpectedTable : this.getUnexpectedTables()) {
            DropTableChange change = new DropTableChange();
            change.setTableName(unexpectedTable.getName());
            change.setSchemaName(unexpectedTable.getSchema());
            changes.add(this.generateChangeSet((Change)change));
        }
    }

    private void addInsertDataChanges(List<ChangeSet> changeSets, String dataDir) throws DatabaseException, IOException {
        try {
            String schema = this.referenceSnapshot.getSchema();
            for (Table table : this.referenceSnapshot.getTables()) {
                ArrayList<Object> changes = new ArrayList<Object>();
                List rs = ExecutorService.getInstance().getExecutor(this.referenceSnapshot.getDatabase()).queryForList((SqlStatement)new RawSqlStatement("SELECT * FROM " + this.referenceSnapshot.getDatabase().escapeTableName(schema, table.getName())));
                if (rs.size() == 0) continue;
                ArrayList<String> columnNames = new ArrayList<String>();
                for (Column column : table.getColumns()) {
                    columnNames.add(column.getName());
                }
                if (dataDir != null) {
                    File parentDir;
                    String fileName = table.getName().toLowerCase() + ".csv";
                    if (dataDir != null) {
                        fileName = dataDir + "/" + fileName;
                    }
                    if (!(parentDir = new File(dataDir)).exists()) {
                        parentDir.mkdirs();
                    }
                    if (!parentDir.isDirectory()) {
                        throw new RuntimeException(parentDir + " is not a directory");
                    }
                    CSVWriter cSVWriter = new CSVWriter((Writer)new FileWriter(fileName));
                    String[] dataTypes = new String[columnNames.size()];
                    String[] line = new String[columnNames.size()];
                    for (int i = 0; i < columnNames.size(); ++i) {
                        line[i] = (String)columnNames.get(i);
                    }
                    cSVWriter.writeNext(line);
                    for (Map row : rs) {
                        line = new String[columnNames.size()];
                        for (int i = 0; i < columnNames.size(); ++i) {
                            Object value = row.get(((String)columnNames.get(i)).toUpperCase());
                            if (dataTypes[i] == null && value != null) {
                                dataTypes[i] = value instanceof Number ? "NUMERIC" : (value instanceof Boolean ? "BOOLEAN" : (value instanceof Date ? "DATE" : "STRING"));
                            }
                            line[i] = value == null ? "NULL" : (value instanceof Date ? new ISODateFormat().format((Date)value) : value.toString());
                        }
                        cSVWriter.writeNext(line);
                    }
                    cSVWriter.flush();
                    cSVWriter.close();
                    LoadDataChange change = new LoadDataChange();
                    change.setFile(fileName);
                    change.setEncoding("UTF-8");
                    change.setSchemaName(schema);
                    change.setTableName(table.getName());
                    for (int i = 0; i < columnNames.size(); ++i) {
                        String colName = (String)columnNames.get(i);
                        LoadDataColumnConfig columnConfig = new LoadDataColumnConfig();
                        columnConfig.setHeader(colName);
                        columnConfig.setName(colName);
                        columnConfig.setType(dataTypes[i]);
                        change.addColumn(columnConfig);
                    }
                    changes.add(change);
                } else {
                    for (Map row : rs) {
                        InsertDataChange insertDataChange = new InsertDataChange();
                        insertDataChange.setSchemaName(schema);
                        insertDataChange.setTableName(table.getName());
                        for (int i = 0; i < columnNames.size(); ++i) {
                            ColumnConfig column = new ColumnConfig();
                            column.setName((String)columnNames.get(i));
                            Object value = row.get(((String)columnNames.get(i)).toUpperCase());
                            if (value == null) {
                                column.setValue(null);
                            } else if (value instanceof Number) {
                                column.setValueNumeric((Number)value);
                            } else if (value instanceof Boolean) {
                                column.setValueBoolean((Boolean)value);
                            } else if (value instanceof Date) {
                                column.setValueDate((Date)value);
                            } else {
                                column.setValue(value.toString().replace("\\", "\\\\"));
                            }
                            insertDataChange.addColumn(column);
                        }
                        changes.add(insertDataChange);
                    }
                }
                if (changes.size() <= 0) continue;
                ChangeSet changeSet = this.generateChangeSet();
                for (Change change : changes) {
                    changeSet.addChange(change);
                }
                changeSets.add(changeSet);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

