/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.ext;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Assert;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class KimChangeBaseTest {
    protected static Connection connection;
    protected static Database database;

    @BeforeClass
    public static void bootstrapTestDB() throws Exception {
        connection = DriverManager.getConnection("jdbc:h2:mem:TEST");
        database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        Liquibase liquibase = new Liquibase("org/kuali/rice/liquibase/change/ext/bootstrap.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        liquibase.update("");
    }

    @Test
    public void testUpdateAndRollback() throws Exception {
        this.performUpdateAndRollback("default");
    }

    @Test
    public void testUpdateAndRollback_customNamespace() throws Exception {
        this.performUpdateAndRollback("custom-namespace");
    }

    protected abstract String entityName();

    protected abstract String whereClause();

    protected void assertInsert(String whereClause) throws SQLException {
        ResultSet r = this.getEntityResultSet(whereClause);
        if (!r.next()) {
            Assert.fail((String)"Insert failed!");
        }
    }

    protected void assertRollback(String whereClause) throws SQLException {
        ResultSet r = this.getEntityResultSet(whereClause);
        if (r.next()) {
            Assert.fail((String)"Rollback failed!");
        }
    }

    private void performUpdateAndRollback(String context) throws Exception {
        Liquibase liquibase = new Liquibase("org/kuali/rice/liquibase/change/ext/" + this.entityName() + ".xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        liquibase.update(context);
        this.assertInsert(this.whereClause());
        liquibase.rollback(1, context);
        this.assertRollback(this.whereClause());
    }

    private ResultSet getEntityResultSet(String whereClause) throws SQLException {
        PreparedStatement ps = connection.prepareStatement(String.format("select * from %s where %s", this.entityName(), whereClause));
        return ps.executeQuery();
    }
}

