/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.maven.plugins.kc;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.kualigan.maven.plugins.api.PrototypeHelper;

@Mojo(name="create-prototype", requiresProject=false)
public class CreatePrototypeMojo
extends AbstractMojo {
    @Component(role=PrototypeHelper.class, hint="default")
    protected PrototypeHelper helper;
    @Parameter(property="localRepository")
    protected ArtifactRepository localRepository;
    @Parameter(property="kc.local.path")
    protected String kcPath;
    @Parameter(property="packageName", defaultValue="org.kuali.kc")
    protected String packageName;
    @Parameter(property="groupId", defaultValue="org.kuali.kc")
    protected String groupId;
    @Parameter(property="artifactId", defaultValue="kc")
    protected String artifactId;
    @Parameter(property="version", defaultValue="5.0")
    protected String version;
    @Parameter(property="file")
    protected File file;
    @Parameter(property="sources")
    protected File sources;
    @Parameter(property="project")
    protected MavenProject project;
    @Parameter(property="repositoryId")
    protected String repositoryId;
    @Parameter(defaultValue="${maven.home}")
    protected File mavenHome;

    public void execute() throws MojoExecutionException {
        String basedir = System.getProperty("user.dir");
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("basedir", basedir);
            map.put("package", this.packageName);
            map.put("packageName", this.packageName);
            map.put("groupId", this.groupId);
            map.put("artifactId", this.artifactId);
            map.put("version", this.version);
            ArrayList archetypeRemoteRepositories = new ArrayList();
            File prototypeJar = this.helper.repack(this.file, this.artifactId);
            this.helper.extractTempPom();
            this.helper.installArtifact(this.file, null, this.getMavenHome(), this.groupId, this.artifactId, this.version, this.repositoryId);
            this.helper.installArtifact(prototypeJar, this.sources, this.getMavenHome(), this.groupId, this.artifactId, this.version, this.repositoryId);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create a new Jenkins plugin", e);
        }
    }

    public void setMavenHome(File mavenHome) {
        this.mavenHome = mavenHome;
    }

    public File getMavenHome() {
        return this.mavenHome;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }
}

