/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.maven.plugins.kfs;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.maven.archetype.Archetype;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.interactivity.Prompter;

public class MigrateMojo
extends AbstractMojo {
    private Archetype archetype;
    private Prompter prompter;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactRepositoryLayout defaultArtifactRepositoryLayout;
    private ArtifactRepository localRepository;
    private String kfsPath;
    private String packageName;
    private String groupId;
    private String artifactId;
    private String version;
    private MavenProject project;

    protected void setupDefaults() throws Exception {
        if (this.project.getFile() != null && this.groupId == null) {
            this.groupId = this.project.getGroupId();
        }
        if (this.groupId == null) {
            this.groupId = this.prompter.prompt("Enter the groupId of your institution");
        }
        if (this.packageName == null) {
            this.getLog().info((CharSequence)("Defaulting package to group ID: " + this.groupId));
            this.packageName = this.groupId;
        }
        if (this.artifactId == null) {
            this.artifactId = this.prompter.prompt("Enter the artifactId of your plugin");
        }
    }

    public void execute() throws MojoExecutionException {
        String basedir = System.getProperty("user.dir");
        try {
            this.setupDefaults();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("basedir", basedir);
            map.put("package", this.packageName);
            map.put("packageName", this.packageName);
            map.put("groupId", this.groupId);
            map.put("artifactId", this.artifactId);
            map.put("version", this.version);
            ArrayList archetypeRemoteRepositories = new ArrayList();
            Properties props = new Properties();
            props.load(((Object)((Object)this)).getClass().getResourceAsStream("plugin.properties"));
            this.archetype.createArchetype(props.getProperty("groupId"), props.getProperty("artifactId"), props.getProperty("version"), this.localRepository, archetypeRemoteRepositories, map);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create a new Jenkins plugin", e);
        }
    }

    protected void copyFilesFromArcheType(String basedir) {
        File outDir = new File(basedir, this.artifactId);
        File viewDir = new File(outDir, "src/main/resources/" + this.groupId.replace('.', '/'));
        viewDir.mkdirs();
        for (String s : new String[]{"config.jelly", "global.jelly", "help-name.html"}) {
        }
    }

    public ArtifactRepository createRepository(String url, String repositoryId) {
        String updatePolicyFlag = "always";
        String checksumPolicyFlag = "warn";
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        return this.artifactRepositoryFactory.createArtifactRepository(repositoryId, url, this.defaultArtifactRepositoryLayout, snapshotsPolicy, releasesPolicy);
    }
}

