/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.maven.plugins.kfs;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.maven.archetype.Archetype;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.kualigan.maven.plugins.api.PrototypeHelper;

@Component(role=PrototypeHelper.class, hint="default")
public class PrototypeUtil {
    private static final Options OPTIONS = new Options();
    private static final char SET_SYSTEM_PROPERTY = 'D';
    private static final char OFFLINE = 'o';
    private static final char REACTOR = 'r';
    private static final char QUIET = 'q';
    private static final char DEBUG = 'X';
    private static final char ERRORS = 'e';
    private static final char NON_RECURSIVE = 'N';
    private static final char UPDATE_SNAPSHOTS = 'U';
    private static final char ACTIVATE_PROFILES = 'P';
    private static final String FORCE_PLUGIN_UPDATES = "cpu";
    private static final String FORCE_PLUGIN_UPDATES2 = "up";
    private static final String SUPPRESS_PLUGIN_UPDATES = "npu";
    private static final String SUPPRESS_PLUGIN_REGISTRY = "npr";
    private static final char CHECKSUM_FAILURE_POLICY = 'C';
    private static final char CHECKSUM_WARNING_POLICY = 'c';
    private static final char ALTERNATE_USER_SETTINGS = 's';
    private static final String FAIL_FAST = "ff";
    private static final String FAIL_AT_END = "fae";
    private static final String FAIL_NEVER = "fn";
    private static final String ALTERNATE_POM_FILE = "f";
    @Requirement
    protected Archetype archetype;
    @Requirement
    protected Prompter prompter;
    @Requirement
    protected ArtifactRepositoryFactory artifactRepositoryFactory;
    @Requirement(role=ArtifactRepositoryLayout.class, hint="default")
    protected ArtifactRepositoryLayout defaultArtifactRepositoryLayout;
    @Requirement
    protected ArchiverManager archiverManager;
    private AbstractMojo caller;

    protected void logUnpack(File file, File location, String includes, String excludes) {
        if (!this.getCaller().getLog().isInfoEnabled()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Unpacking ");
        msg.append(file);
        msg.append(" to ");
        msg.append(location);
        if (includes != null && excludes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\" and excludes \"");
            msg.append(excludes);
            msg.append("\"");
        } else if (includes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\"");
        } else if (excludes != null) {
            msg.append(" with excludes \"");
            msg.append(excludes);
            msg.append("\"");
        }
        this.getCaller().getLog().info((CharSequence)msg.toString());
    }

    public File repack(File file, String artifactId) throws MojoExecutionException {
        File workingDirectory = new File(System.getProperty("java.io.tmpdir") + File.separator + artifactId + "-repack");
        File warDirectory = new File(workingDirectory, "war");
        File repackDirectory = new File(workingDirectory, artifactId);
        File classesDirectory = new File(warDirectory, "WEB-INF/classes");
        File retval = new File(workingDirectory, artifactId + ".jar");
        try {
            workingDirectory.mkdirs();
            workingDirectory.mkdir();
            workingDirectory.deleteOnExit();
            warDirectory.mkdir();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create working directory for repackaging", e);
        }
        this.unpack(file, warDirectory, "**/classes/**", null);
        try {
            FileUtils.copyDirectoryStructure((File)classesDirectory, (File)repackDirectory);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to copy files into the repack directory");
        }
        try {
            this.pack(retval, repackDirectory, "**/**", null);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Was unable to create the jar", e);
        }
        return retval;
    }

    protected void unpack(File file, File location, String includes, String excludes) throws MojoExecutionException {
        try {
            this.logUnpack(file, location, includes, excludes);
            location.mkdirs();
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(file);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            if (StringUtils.isNotEmpty((String)excludes) || StringUtils.isNotEmpty((String)includes)) {
                IncludeExcludeFileSelector[] selectors = new IncludeExcludeFileSelector[]{new IncludeExcludeFileSelector()};
                if (StringUtils.isNotEmpty((String)excludes)) {
                    selectors[0].setExcludes(excludes.split(","));
                }
                if (StringUtils.isNotEmpty((String)includes)) {
                    selectors[0].setIncludes(includes.split(","));
                }
                unArchiver.setFileSelectors((FileSelector[])selectors);
            }
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error unpacking file: " + file + " to: " + location + "\r\n" + e.toString(), (Exception)((Object)e));
        }
    }

    protected void pack(File file, final File location, final String includes, final String excludes) throws MojoExecutionException {
        try {
            Archiver archiver = this.archiverManager.getArchiver(file);
            archiver.addFileSet((FileSet)new DefaultFileSet(){
                {
                    this.setDirectory(location);
                    if (includes != null) {
                        this.setIncludes(includes.split(","));
                    }
                    if (excludes != null) {
                        this.setExcludes(excludes.split(","));
                    }
                }
            });
            archiver.setDestFile(file);
            archiver.createArchive();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error packing directory: " + location + " to: " + file + "\r\n" + e.toString(), e);
        }
    }

    private void setupRequest(InvocationRequest req, String additionalArguments) throws MojoExecutionException {
        try {
            String[] args = CommandLineUtils.translateCommandline((String)additionalArguments);
            CommandLine cli = new PosixParser().parse(OPTIONS, args);
            if (cli.hasOption('D')) {
                String[] properties = cli.getOptionValues('D');
                Properties props = new Properties();
                for (int i = 0; i < properties.length; ++i) {
                    String value;
                    String name;
                    String property = properties[i];
                    int sep = property.indexOf("=");
                    if (sep <= 0) {
                        name = property.trim();
                        value = "true";
                    } else {
                        name = property.substring(0, sep).trim();
                        value = property.substring(sep + 1).trim();
                    }
                    props.setProperty(name, value);
                }
                req.setProperties(props);
            }
            if (cli.hasOption('o')) {
                req.setOffline(true);
            }
            if (cli.hasOption('q')) {
                req.setDebug(false);
            } else if (cli.hasOption('X')) {
                req.setDebug(true);
            } else if (cli.hasOption('e')) {
                req.setShowErrors(true);
            }
            if (cli.hasOption('r')) {
                req.setRecursive(true);
            } else if (cli.hasOption('N')) {
                req.setRecursive(false);
            }
            if (cli.hasOption('U')) {
                req.setUpdateSnapshots(true);
            }
            if (cli.hasOption('P')) {
                String[] profiles = cli.getOptionValues('P');
                ArrayList<String> activatedProfiles = new ArrayList<String>();
                ArrayList<String> deactivatedProfiles = new ArrayList<String>();
                if (profiles != null) {
                    for (int i = 0; i < profiles.length; ++i) {
                        StringTokenizer profileTokens = new StringTokenizer(profiles[i], ",");
                        while (profileTokens.hasMoreTokens()) {
                            String profileAction = profileTokens.nextToken().trim();
                            if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                                deactivatedProfiles.add(profileAction.substring(1));
                                continue;
                            }
                            if (profileAction.startsWith("+")) {
                                activatedProfiles.add(profileAction.substring(1));
                                continue;
                            }
                            activatedProfiles.add(profileAction);
                        }
                    }
                }
                if (!deactivatedProfiles.isEmpty()) {
                    this.getCaller().getLog().warn((CharSequence)("Explicit profile deactivation is not yet supported. The following profiles will NOT be deactivated: " + StringUtils.join(deactivatedProfiles.iterator(), (String)", ")));
                }
                if (!activatedProfiles.isEmpty()) {
                    req.setProfiles(activatedProfiles);
                }
            }
            if (cli.hasOption(FORCE_PLUGIN_UPDATES) || cli.hasOption(FORCE_PLUGIN_UPDATES2)) {
                this.getCaller().getLog().warn((CharSequence)"Forcing plugin updates is not supported currently.");
            } else if (cli.hasOption(SUPPRESS_PLUGIN_UPDATES)) {
                req.setNonPluginUpdates(true);
            }
            if (cli.hasOption(SUPPRESS_PLUGIN_REGISTRY)) {
                this.getCaller().getLog().warn((CharSequence)"Explicit suppression of the plugin registry is not supported currently.");
            }
            if (cli.hasOption('C')) {
                req.setGlobalChecksumPolicy("fail");
            } else if (cli.hasOption('c')) {
                req.setGlobalChecksumPolicy("warn");
            }
            if (cli.hasOption('s')) {
                req.setUserSettingsFile(new File(cli.getOptionValue('s')));
            }
            if (cli.hasOption(FAIL_AT_END)) {
                req.setFailureBehavior("fail-at-end");
            } else if (cli.hasOption(FAIL_FAST)) {
                req.setFailureBehavior("fail-fast");
            }
            if (cli.hasOption(FAIL_NEVER)) {
                req.setFailureBehavior("fail-never");
            }
            if (cli.hasOption(ALTERNATE_POM_FILE)) {
                if (req.getPomFileName() != null) {
                    this.getCaller().getLog().info((CharSequence)"pomFileName is already set, ignoring the -f argument");
                } else {
                    req.setPomFileName(cli.getOptionValue(ALTERNATE_POM_FILE));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to re-parse additional arguments for Maven invocation.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installArtifact(final File artifact, final File sources, File mavenHome, final String groupId, final String artifactId, final String version, final String repositoryId) throws MojoExecutionException {
        Invoker invoker = new DefaultInvoker().setMavenHome(mavenHome);
        String additionalArguments = "";
        InvocationRequest req = new DefaultInvocationRequest().setInteractive(false).setProperties(new Properties(){
            {
                this.setProperty("groupId", groupId);
                this.setProperty("artifactId", artifactId);
                this.setProperty("version", version);
                this.setProperty("packaging", artifact.getName().endsWith("jar") ? "jar" : "war");
                this.setProperty("pomFile", PrototypeUtil.this.getTempPomPath());
                this.setProperty("repositoryId", repositoryId);
                if (sources != null) {
                    try {
                        this.setProperty("sources", sources.getCanonicalPath());
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("Cannot get path for the sources file ", e);
                    }
                }
                try {
                    this.setProperty("file", artifact.getCanonicalPath());
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Cannot get path for the war file ", e);
                }
                this.setProperty("updateReleaseInfo", "true");
            }
        });
        this.setupRequest(req, "");
        if (repositoryId == null) {
            req.setGoals((List)new ArrayList<String>(){
                {
                    this.add("install:install-file");
                }
            });
        } else {
            req.setGoals((List)new ArrayList<String>(){
                {
                    this.add("deploy:deploy-file");
                }
            });
        }
        try {
            InvocationResult invocationResult = invoker.execute(req);
            if (invocationResult.getExecutionException() != null) {
                throw new MojoExecutionException("Error executing Maven.", (Exception)invocationResult.getExecutionException());
            }
            if (invocationResult.getExitCode() != 0) {
                throw new MojoExecutionException("Maven execution failed, exit code: '" + invocationResult.getExitCode() + "'");
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Failed to invoke Maven build.", (Exception)((Object)e));
        }
    }

    protected String getTempPomPath() {
        return System.getProperty("java.io.tmpdir") + File.separator + "prototype-pom.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractTempPom() throws MojoExecutionException {
        this.getCaller().getLog().info((CharSequence)"Extracting the Temp POM");
        InputStream pom_is = this.getClass().getClassLoader().getResourceAsStream("prototype-resources/pom.xml");
        byte[] fileBytes = null;
        try {
            DataInputStream dis = new DataInputStream(pom_is);
            fileBytes = new byte[dis.available()];
            dis.readFully(fileBytes);
            dis.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Wasn't able to read in the prototype pom", e);
        }
        finally {
            try {
                pom_is.close();
            }
            catch (Exception e) {}
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.getTempPomPath());
            try {
                fos.write(fileBytes);
            }
            finally {
                fos.close();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not write temporary pom file", e);
        }
    }

    public void setCaller(AbstractMojo caller) {
        this.caller = caller;
    }

    public AbstractMojo getCaller() {
        return this.caller;
    }
}

