/*
 * Copyright 2007 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.opensource.org/licenses/ecl2.php
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kualigan.maven.plugins.api;

import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.AbstractMojo;


/**
 * @author Leo Przybylski (leo [at] rsmart.com)
 */
public interface OverlayHelper {
    String ROLE = OverlayHelper.class.getName();

    /**
     * Invokes the maven goal {@code archetype:generate} with the appropriate properties.
     * 
     */
    void generateArchetype(final File mavenHome,
                           final String archetypeGroupId,
                           final String archetypeArtifactId,
                           final String archetypeVersion,
                           final String groupId,
                           final String artifactId,
                           final String version,
                           final String prototypeGroupId,
                           final String prototypeArtifactId,
                           final String prototypeVersion) throws MojoExecutionException;

    void setCaller(final AbstractMojo caller);
    
    AbstractMojo getCaller();
}
